/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.service.impl;

import com.centit.locode.platform.dao.ApplicationRuleDao;
import com.centit.locode.platform.po.ApplicationRule;
import com.centit.locode.platform.service.ApplicationRuleService;
import com.centit.product.metadata.dao.DataCheckRuleDao;
import com.centit.support.database.utils.PageDesc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ApplicationRuleServiceImpl
implements ApplicationRuleService {
    @Autowired
    private ApplicationRuleDao applicationRuleDao;
    @Autowired
    private DataCheckRuleDao dataCheckRuleDao;

    @Override
    public void createApplicationRule(ApplicationRule applicationRule) {
        this.applicationRuleDao.saveNewObject(applicationRule);
    }

    @Override
    public void updateApplicationRule(ApplicationRule applicationRule) {
        this.applicationRuleDao.updateObject(applicationRule);
    }

    @Override
    public void deleteApplicationRule(String id) {
        this.applicationRuleDao.deleteObjectById(id);
    }

    @Override
    public List<ApplicationRule> listApplicationRule(Map<String, Object> params, PageDesc pageDesc) {
        return this.applicationRuleDao.listObjectsByProperties(params, pageDesc);
    }

    @Override
    public ApplicationRule getApplicationRule(String id) {
        return (ApplicationRule)this.applicationRuleDao.getObjectById(id);
    }

    @Override
    public void deleteAppRule(String osId, String ruleId) {
        if (osId == null) {
            return;
        }
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("osId", osId);
        if (StringUtils.isNotBlank((CharSequence)ruleId)) {
            filterMap.put("ruleId", ruleId);
        }
        this.applicationRuleDao.deleteObjectsByProperties(filterMap);
    }

    @Override
    public void deleteCheckRule(String ruleId) {
        this.dataCheckRuleDao.deleteObjectById((Object)ruleId);
        HashMap<String, String> filterMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)ruleId)) {
            filterMap.put("ruleId", ruleId);
        }
        this.applicationRuleDao.deleteObjectsByProperties(filterMap);
    }
}

