/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.controller;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.dde.adapter.po.CallApiLog;
import com.centit.dde.adapter.po.CallApiLogDetail;
import com.centit.dde.services.TaskLogManager;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"taskLog"})
@Api(value="\u4efb\u52a1\u65e5\u5fd7", tags={"\u4efb\u52a1\u65e5\u5fd7"})
public class TaskLogController
extends BaseController {
    private static final Log log = LogFactory.getLog(TaskLogController.class);
    private final TaskLogManager taskLogManager;

    @Autowired
    public TaskLogController(TaskLogManager taskLogManager) {
        this.taskLogManager = taskLogManager;
    }

    @DeleteMapping(value={"/{logId}"})
    @ApiOperation(value="\u5220\u9664\u65e5\u5fd7")
    @ApiImplicitParam(name="logId", value="\u65e5\u5fd7ID")
    @WrapUpResponseBody
    public void delTaskLog(@PathVariable String logId) {
        this.taskLogManager.deleteTaskLogById(logId);
    }

    @GetMapping
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u65e5\u5fd7")
    @WrapUpResponseBody
    public PageQueryResult<Map<String, Object>> listTaskLog(PageDesc pageDesc, HttpServletRequest request) {
        Map parameters = TaskLogController.collectRequestParameters((HttpServletRequest)request);
        List callApiLogs = this.taskLogManager.listTaskLog(parameters, pageDesc);
        return PageQueryResult.createResult((Collection)callApiLogs, (PageDesc)pageDesc);
    }

    @GetMapping(value={"/{logId}"})
    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u65e5\u5fd7")
    @ApiImplicitParam(name="logId", value="\u65e5\u5fd7ID")
    @WrapUpResponseBody
    public CallApiLog getTaskLog(@PathVariable String logId) {
        return this.taskLogManager.getLogWithDetail(logId);
    }

    @GetMapping(value={"/details/{logId}"})
    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u65e5\u5fd7\u660e\u7ec6")
    @ApiImplicitParam(name="logId", value="\u65e5\u5fd7ID")
    @WrapUpResponseBody
    public List<CallApiLogDetail> getTaskLogDetails(@PathVariable String logId) {
        return this.taskLogManager.listLogDetails(logId);
    }

    @GetMapping(value={"/statByTask"})
    @ApiOperation(value="\u65e5\u5fd7\u7edf\u8ba1,\u5355\u6761API\u65e5\u5fd7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="API\u63a5\u53e3ID"), @ApiImplicitParam(name="statType", value="\u7edf\u8ba1\u7c7b\u578b\uff1amonth/week/day")})
    @WrapUpResponseBody
    public JSONArray statApiCallSumByTask(String taskId, String statType) {
        Date currentDate = DatetimeOpt.currentUtilDate();
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)statType, (CharSequence[])new CharSequence[]{"month"})) {
            return this.taskLogManager.statApiCallSumByTask(taskId, DatetimeOpt.truncateToDay((Date)DatetimeOpt.addMonths((Date)currentDate, (int)-1)), currentDate);
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)statType, (CharSequence[])new CharSequence[]{"week"})) {
            return this.taskLogManager.statApiCallSumByTask(taskId, DatetimeOpt.truncateToDay((Date)DatetimeOpt.addDays((Date)currentDate, (int)-7)), currentDate);
        }
        return this.taskLogManager.statApiCallSumByTask(taskId, DatetimeOpt.addDays((Date)currentDate, (int)-1), currentDate);
    }

    @GetMapping(value={"/statByOs"})
    @ApiOperation(value="\u65e5\u5fd7\u7edf\u8ba1\uff0c\u4e00\u4e2a\u5e94\u7528\u4e0b\u7684\u65e5\u5fd7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="osId", value="\u5e94\u7528ID\uff0capplicationId/osId"), @ApiImplicitParam(name="statType", value="\u7edf\u8ba1\u7c7b\u578b\uff1amonth/week/day")})
    @WrapUpResponseBody
    public JSONArray statApiCallSumByApplication(String osId, String statType) {
        Date currentDate = DatetimeOpt.currentUtilDate();
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)statType, (CharSequence[])new CharSequence[]{"month"})) {
            return this.taskLogManager.statApiCallSumByApplication(osId, DatetimeOpt.truncateToDay((Date)DatetimeOpt.addMonths((Date)currentDate, (int)-1)), currentDate);
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)statType, (CharSequence[])new CharSequence[]{"week"})) {
            return this.taskLogManager.statApiCallSumByApplication(osId, DatetimeOpt.truncateToDay((Date)DatetimeOpt.addDays((Date)currentDate, (int)-7)), currentDate);
        }
        return this.taskLogManager.statApiCallSumByApplication(osId, DatetimeOpt.addDays((Date)currentDate, (int)-1), currentDate);
    }

    @GetMapping(value={"/statByTopUnit"})
    @ApiOperation(value="\u65e5\u5fd7\u7edf\u8ba1\uff0c\u4e00\u4e2a\u79df\u6237\u4e0b\u7684\u65e5\u5fd7")
    @ApiImplicitParam(name="statType", value="\u7edf\u8ba1\u7c7b\u578b\uff1amonth/week/day")
    @WrapUpResponseBody
    public JSONArray statApiCallSumByTopUnit(String statType, HttpServletRequest request) {
        Date currentDate = DatetimeOpt.currentUtilDate();
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)statType, (CharSequence[])new CharSequence[]{"month"})) {
            return this.taskLogManager.statApiCallSumByTopUnit(topUnit, DatetimeOpt.truncateToDay((Date)DatetimeOpt.addMonths((Date)currentDate, (int)-1)), currentDate);
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)statType, (CharSequence[])new CharSequence[]{"week"})) {
            return this.taskLogManager.statApiCallSumByTopUnit(topUnit, DatetimeOpt.truncateToDay((Date)DatetimeOpt.addDays((Date)currentDate, (int)-7)), currentDate);
        }
        return this.taskLogManager.statApiCallSumByTopUnit(topUnit, DatetimeOpt.addDays((Date)currentDate, (int)-1), currentDate);
    }

    @GetMapping(value={"/apiEfficiency"})
    @ApiOperation(value="\u65e5\u5fd7\u7edf\u8ba1\uff0c\u6839\u636eoptId\u7edf\u8ba1\u63a5\u53e3\u54cd\u5e94\u65f6\u95f4\u548c\u6210\u529f\u7387")
    @ApiImplicitParams(value={@ApiImplicitParam(name="optId", value="\u63a5\u53e3ID"), @ApiImplicitParam(name="startDate", value="\u5f00\u59cb\u65f6\u95f4"), @ApiImplicitParam(name="endDate", value="\u7ed3\u675f\u65f6\u95f4")})
    @WrapUpResponseBody
    public JSONObject statApiEfficiency(String optId, Date startDate, Date endDate) {
        return this.taskLogManager.statApiEfficiency(optId, startDate, endDate);
    }

    @GetMapping(value={"/osStatInfo"})
    @ApiOperation(value="\u5e94\u7528\u4e0b\u9762\u7684\u7edf\u8ba1\u4fe1\u606f")
    @ApiImplicitParam(name="osId", value="\u5e94\u7528ID\uff0capplicationId/osId")
    @WrapUpResponseBody
    public JSONObject statApplication(String osId) {
        return this.taskLogManager.statApplicationInfo(osId);
    }

    @GetMapping(value={"/topActive"})
    @ApiOperation(value="\u5e94\u7528\u4e0b\u9762\u6700\u6d3b\u8dc3\u7684\u5e94\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="osId", value="\u5e94\u7528ID\uff0capplicationId/osId"), @ApiImplicitParam(name="topSize", value=">=5, \u6839\u636e\u7a7a\u95f4\u9009\u62e9\uff0c &topSize=15"), @ApiImplicitParam(name="statType", value="\u7edf\u8ba1\u7c7b\u578b\uff1amonth/week/day")})
    @WrapUpResponseBody
    public JSONArray statTopActive(String osId, Integer topSize, String statType) {
        if (topSize == null || topSize < 5) {
            topSize = 5;
        }
        Date currentDate = DatetimeOpt.currentUtilDate();
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)statType, (CharSequence[])new CharSequence[]{"month"})) {
            return this.taskLogManager.statTopActive(osId, topSize.intValue(), DatetimeOpt.truncateToDay((Date)DatetimeOpt.addMonths((Date)currentDate, (int)-1)), currentDate);
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)statType, (CharSequence[])new CharSequence[]{"week"})) {
            return this.taskLogManager.statTopActive(osId, topSize.intValue(), DatetimeOpt.truncateToDay((Date)DatetimeOpt.addDays((Date)currentDate, (int)-7)), currentDate);
        }
        return this.taskLogManager.statTopActive(osId, topSize.intValue(), DatetimeOpt.addDays((Date)currentDate, (int)-1), currentDate);
    }

    @GetMapping(value={"/topFailed"})
    @ApiOperation(value="\u5e94\u7528\u4e0b\u9762\u5931\u8d25\u7684\u5e94\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="osId", value="\u5e94\u7528ID\uff0capplicationId/osId"), @ApiImplicitParam(name="topSize", value=">=5, \u6839\u636e\u7a7a\u95f4\u9009\u62e9\uff0c &topSize=15"), @ApiImplicitParam(name="statType", value="\u7edf\u8ba1\u7c7b\u578b\uff1amonth/week/day")})
    @WrapUpResponseBody
    public JSONArray statTopFailed(String osId, Integer topSize, String statType) {
        if (topSize == null || topSize < 5) {
            topSize = 5;
        }
        Date currentDate = DatetimeOpt.currentUtilDate();
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)statType, (CharSequence[])new CharSequence[]{"month"})) {
            return this.taskLogManager.statTopFailed(osId, topSize.intValue(), DatetimeOpt.truncateToDay((Date)DatetimeOpt.addMonths((Date)currentDate, (int)-1)), currentDate);
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)statType, (CharSequence[])new CharSequence[]{"week"})) {
            return this.taskLogManager.statTopFailed(osId, topSize.intValue(), DatetimeOpt.truncateToDay((Date)DatetimeOpt.addDays((Date)currentDate, (int)-7)), currentDate);
        }
        return this.taskLogManager.statTopFailed(osId, topSize.intValue(), DatetimeOpt.addDays((Date)currentDate, (int)-1), currentDate);
    }
}

