/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.dao.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.dde.adapter.dao.DataPacketDao;
import com.centit.dde.adapter.po.DataPacket;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.stereotype.Repository;

@Repository(value="this")
public class DataPacketDaoImpl
extends BaseDaoImpl<DataPacket, String>
implements DataPacketDao {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>(1);
        filterField.put("(splitforin)optids", "opt_id in (:optids)");
        return filterField;
    }

    public void updateDataPacketOptJson(String packetId, String dataPacketOptJson) {
        DatabaseOptUtils.batchUpdateObject((BaseDaoImpl)this, DataPacket.class, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"dataOptDescJson", dataPacketOptJson}), (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"packetId", packetId}));
    }

    public void publishDataPacket(DataPacket dataPacket) {
        this.mergeObject((Serializable)dataPacket);
        this.saveObjectReferences((Serializable)dataPacket);
    }

    public int[] batchUpdateOptIdByApiId(final String optId, final List<String> apiIds) {
        String sql = "UPDATE q_data_packet SET OPT_ID=?, PUBLISH_DATE =?, IS_DISABLE='F' WHERE PACKET_ID = ?";
        int[] dataPacket = this.getJdbcTemplate().batchUpdate(sql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                ps.setString(1, optId);
                ps.setTimestamp(2, DatetimeOpt.currentSqlTimeStamp());
                ps.setString(3, (String)apiIds.get(i));
            }

            public int getBatchSize() {
                return apiIds.size();
            }
        });
        return dataPacket;
    }

    public void updateDisableStatus(String packetId, String disable) {
        String sql = "UPDATE q_data_packet SET is_disable= ?,PUBLISH_DATE =? WHERE PACKET_ID = ? ";
        this.getJdbcTemplate().update(sql, new Object[]{disable, DatetimeOpt.currentSqlTimeStamp(), packetId});
    }

    public void batchDeleteByPacketIds(final String[] packetIds) {
        String delSql = "DELETE FROM q_data_packet WHERE PACKET_ID = ? ";
        this.getJdbcTemplate().batchUpdate(delSql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                ps.setString(1, packetIds[i]);
            }

            public int getBatchSize() {
                return packetIds.length;
            }
        });
    }

    public void updatePublishPackedStatus(int logLevel, Boolean isValid, Boolean isDisable, String packetId) {
        String sql = "UPDATE q_data_packet SET log_level= :logLevel, is_valid = :isValid, is_disable =:isDisable,  publish_date = :toDay WHERE PACKET_ID = :api ";
        DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this, (String)sql, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"logLevel", logLevel, "isValid", isValid == null || isValid != false ? "T" : "F", "isDisable", isDisable != null && isDisable != false ? "T" : "F", "toDay", DatetimeOpt.currentUtilDate(), "api", packetId}));
    }

    public void updatePackedLogLevel(int logLevel, List<String> packetIds) {
        String sql = "UPDATE q_data_packet SET log_level = :logLevel, publish_date = :toDay WHERE PACKET_ID in (:apis) ";
        DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this, (String)sql, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"logLevel", logLevel, "toDay", DatetimeOpt.currentUtilDate(), "apis", packetIds}));
        sql = "UPDATE q_data_packet_draft SET log_level= :logLevel WHERE PACKET_ID in (:apis) ";
        DatabaseOptUtils.doExecuteNamedSql((BaseDaoImpl)this, (String)sql, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"logLevel", logLevel, "apis", packetIds}));
    }

    public void updateApplicationLogLevel(int logLevel, String osId) {
        String sql = "UPDATE q_data_packet SET log_level = ?, publish_date = ? WHERE os_id = ?";
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{logLevel, DatetimeOpt.currentUtilDate(), osId});
        sql = "UPDATE q_data_packet_draft SET log_level = ? WHERE os_id = ?";
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{logLevel, osId});
    }

    public JSONArray listApiWithRoute(String osId) {
        return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this, (String)"select a.packet_id, a.route_url, a.task_type from q_data_packet a where a.os_id = ? and a.route_url is not null", (Object[])new Object[]{osId});
    }

    public int clearTrashStand(String osId) {
        String delSql = "DELETE FROM q_data_packet WHERE IS_DISABLE = 'T' AND OS_ID=? ";
        int delCount = DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)delSql, (Object[])new Object[]{osId});
        return delCount;
    }

    public Map<String, Object> statApplicationInfo(String applicationId) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        int apiCount = NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)"select count(*) as dataSum from q_data_packet where os_id = ?", (Object[])new Object[]{applicationId}), (Integer)0);
        int pageCount = NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)"select count(*) as dataSum from m_meta_form_model where os_id = ?", (Object[])new Object[]{applicationId}), (Integer)0);
        int flowCount = NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)"select count(distinct flow_code) as dataSum from wf_flow_define where os_id = ?", (Object[])new Object[]{applicationId}), (Integer)0);
        int moduleCount = NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)"select count(*) as dataSum from f_optinfo where os_id = ?", (Object[])new Object[]{applicationId}), (Integer)0);
        map.put("apiCount", apiCount);
        map.put("pageCount", pageCount);
        map.put("flowCount", flowCount);
        map.put("moduleCount", moduleCount);
        return map;
    }

    public Map<String, String> mapDataPacketName(List<String> packetIds) {
        if (packetIds == null || packetIds.isEmpty()) {
            return Collections.emptyMap();
        }
        JSONArray jsonArray = DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this, (String)"select a.packet_id, a.packet_name from q_data_packet a where a.packet_id in (:ids) ", (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"ids", packetIds}));
        if (jsonArray == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>(jsonArray.size());
        for (Object obj : jsonArray) {
            JSONObject jsonObject = (JSONObject)obj;
            map.put(jsonObject.getString("packetId"), jsonObject.getString("packetName"));
        }
        return map;
    }
}

