/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.client.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.framework.appclient.AppSession;
import com.centit.framework.appclient.HttpReceiveJSON;
import com.centit.framework.appclient.RestfulHttpRequest;
import com.centit.framework.common.ResponseData;
import com.centit.framework.model.adapter.UserUnitVariableTranslate;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.network.UrlOptUtils;
import com.centit.workflow.client.service.impl.WorkflowAppSession;
import com.centit.workflow.commons.CreateFlowOptions;
import com.centit.workflow.commons.SubmitOptOptions;
import com.centit.workflow.po.FlowInfo;
import com.centit.workflow.po.FlowInstance;
import com.centit.workflow.po.FlowInstanceGroup;
import com.centit.workflow.po.FlowOrganize;
import com.centit.workflow.po.FlowVariable;
import com.centit.workflow.po.FlowWarning;
import com.centit.workflow.po.FlowWorkTeam;
import com.centit.workflow.po.NodeInfo;
import com.centit.workflow.po.NodeInstance;
import com.centit.workflow.po.StageInstance;
import com.centit.workflow.po.UserTask;
import com.centit.workflow.service.FlowEngine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowEngineClientImpl
implements FlowEngine {
    private WorkflowAppSession appSession;

    @Autowired
    public void setAppSession(WorkflowAppSession appSession) {
        this.appSession = appSession;
    }

    public FlowInstance createInstance(CreateFlowOptions options) {
        String flowJson = RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/flow/engine/createInstance", (Object)options);
        HttpReceiveJSON receiveJSON = HttpReceiveJSON.valueOfJson((String)flowJson);
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        return (FlowInstance)receiveJSON.getDataAsObject(FlowInstance.class);
    }

    public void saveFlowVariable(String flowInstId, String varName, Object varValue) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("flowInstId", flowInstId);
        paramMap.put("varName", varName);
        paramMap.put("varValue", varValue);
        RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/flow/engine/saveFlowVariable", paramMap);
    }

    public void saveFlowNodeVariable(String nodeInstId, String varName, Object varValue) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("nodeInstId", nodeInstId);
        paramMap.put("varName", varName);
        paramMap.put("varValue", varValue);
        RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/flow/engine/saveFlowNodeVariable", paramMap);
    }

    public void saveFlowNodeVariable(String flowInstId, String runToken, String sVar, Object sValue) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void assignFlowWorkTeam(String flowInstId, String roleCode, List<String> userCodes) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("flowInstId", flowInstId);
        paramMap.put("roleCode", roleCode);
        paramMap.put("userCode", userCodes);
        RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/flow/engine/assignFlowWorkTeam", paramMap);
    }

    public void updateFlowInstanceTeamAndVar(String flowInstId, String nodeInstId, Map<String, String> flowVariables, Map<String, List<String>> flowRoleUsers) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void assignFlowWorkTeamByNode(String nodeInstId, String roleCode, List<String> userCodeSet) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void assignFlowOrganize(String flowInstId, String roleCode, List<String> orgCodeSet) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("flowInstId", flowInstId);
        paramMap.put("roleCode", roleCode);
        paramMap.put("orgCodeSet", orgCodeSet);
        RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/flow/engine/assignFlowOrganize", paramMap);
    }

    public void assignFlowOrganize(String flowInstId, String roleCode, String unitCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("flowInstId", flowInstId);
        paramMap.put("roleCode", roleCode);
        paramMap.put("unitCode", unitCode);
        RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/flow/engine/addFlowOrganize", paramMap);
    }

    public List<String> submitOpt(SubmitOptOptions options) {
        String returnJson = RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/flow/engine/submitOpt", (Object)options);
        HttpReceiveJSON receiveJSON = HttpReceiveJSON.valueOfJson((String)returnJson);
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        JSONArray nextNodeInsts = receiveJSON.getJSONObject().getJSONArray("nextNodeInsts");
        if (!nextNodeInsts.isEmpty()) {
            return nextNodeInsts.toJavaList(String.class, new JSONReader.Feature[0]);
        }
        return new ArrayList<String>();
    }

    public Map<String, Object> submitFlowOpt(SubmitOptOptions options) {
        return null;
    }

    public FlowInstance getFlowInstById(String flowInstId) {
        return (FlowInstance)RestfulHttpRequest.getResponseObject((AppSession)this.appSession, (String)("/flow/engine/inst/" + flowInstId), FlowInstance.class);
    }

    public FlowInfo getFlowDefine(String flowInstId) {
        return (FlowInfo)RestfulHttpRequest.getResponseObject((AppSession)this.appSession, (String)("/flow/engine/instDef/" + flowInstId), FlowInfo.class);
    }

    public NodeInstance getNodeInstById(String nodeInstId) {
        return (NodeInstance)RestfulHttpRequest.getResponseObject((AppSession)this.appSession, (String)("/flow/engine/nodeInst/" + nodeInstId), NodeInstance.class);
    }

    public NodeInfo getNodeInfo(String nodeInstId) {
        return (NodeInfo)RestfulHttpRequest.getResponseObject((AppSession)this.appSession, (String)("/flow/engine/nodeDef/" + nodeInstId), NodeInfo.class);
    }

    public List<FlowVariable> viewFlowVariablesByVarName(String flowInstId, String varName) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("flowInstId", flowInstId);
        paramMap.put("varName", varName);
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)"/flow/engine/viewFlowVariablesByVarname", paramMap, FlowVariable.class);
    }

    public void deleteFlowWorkTeam(String flowInstId, String roleCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("flowInstId", flowInstId);
        paramMap.put("roleCode", roleCode);
        RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/flow/engine/deleteFlowWorkTeam", paramMap);
    }

    public void deleteFlowOrganize(String flowInstId, String roleCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("flowInstId", flowInstId);
        paramMap.put("roleCode", roleCode);
        RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/flow/engine/deleteFlowOrganize", paramMap);
    }

    public List<FlowInstance> listAllFlowInstByOptTag(String optTag) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("flowOptTag", optTag);
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)"/flow/engine/listAllFlowInstByOptTag", paramMap, FlowInstance.class);
    }

    public void updateFlowInstOptInfo(String flowInstId, String flowOptName, String flowOptTag) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("flowInstId", flowInstId);
        paramMap.put("flowOptName", flowOptName);
        paramMap.put("flowOptTag", flowOptTag);
        RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/flow/engine/updateFlowOptInfo", paramMap);
    }

    public void updateNodeInstanceParam(String nodeInstId, String nodeParam) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("nodeInstId", nodeInstId);
        paramMap.put("nodeParam", nodeParam);
        RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/flow/engine/updateNodeParam", paramMap);
    }

    public void lockNodeTask(String nodeInstId, String userCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("nodeInstId", nodeInstId);
        paramMap.put("userCode", userCode);
        RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/flow/engine/lockTask", paramMap);
    }

    public List<FlowWorkTeam> viewFlowWorkTeam(String flowInstId) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public List<FlowWorkTeam> viewFlowWorkTeam(String flowInstId, String roleCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("flowInstId", flowInstId);
        paramMap.put("roleCode", roleCode);
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)"/flow/engine/viewFlowWorkTeam", paramMap, FlowWorkTeam.class);
    }

    public List<String> viewFlowOrganize(String flowInstId, String roleCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("flowInstId", flowInstId);
        paramMap.put("roleCode", roleCode);
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)"/flow/engine/viewFlowOrganize", paramMap, String.class);
    }

    public void deleteFlowVariable(String flowInstId, String runToken, String varName) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("flowInstId", flowInstId);
        paramMap.put("runToken", runToken);
        paramMap.put("varName", varName);
        RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/flow/engine/deleteFlowVariable", paramMap);
    }

    public boolean nodeCanBeReclaim(String nodeInstId) {
        HttpReceiveJSON receiveJSON = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/flow/engine/nodeCanBeReclaim/" + nodeInstId));
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        return BooleanBaseOpt.castObjectToBoolean((Object)receiveJSON.getData(), (Boolean)false);
    }

    public NodeInstance reclaimNode(String nodeInstId, String userCode) {
        throw new ObjectException(613, "\u5f53\u524d\u7248\u672c\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\uff01");
    }

    public String rollBackNode(String nodeInstId, CentitUserDetails managerUser) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("nodeInstId", nodeInstId);
        paramMap.put("managerUserCode", managerUser.getUserCode());
        String res = RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/flow/engine/rollBackNode", paramMap);
        HttpReceiveJSON receiveJSON = HttpReceiveJSON.valueOfJson((String)res);
        return receiveJSON.getDataAsString();
    }

    public Map<String, String> listFlowNodeForCreate(String flowInstId) {
        HttpReceiveJSON receiveJSON = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/flow/engine/nodeForCreate/" + flowInstId));
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        return receiveJSON.getDataAsMap(String.class);
    }

    public NodeInstance createIsolatedNodeInst(String flowInstId, String curNodeInstId, String nodeCode, String createUser, String userCode, String unitCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("flowInstId", flowInstId);
        paramMap.put("curNodeInstId", curNodeInstId);
        paramMap.put("createUser", createUser);
        paramMap.put("nodeCode", nodeCode);
        paramMap.put("userCode", userCode);
        paramMap.put("unitCode", unitCode);
        String json = RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/flow/engine/isolatedNode", paramMap);
        HttpReceiveJSON receiveJSON = HttpReceiveJSON.valueOfJson((String)json);
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        return (NodeInstance)receiveJSON.getDataAsObject(NodeInstance.class);
    }

    public NodeInstance duplicateMultiNodeInst(String flowInstId, String multiNodeCode, String createUser, String userCode, String unitCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("flowInstId", flowInstId);
        paramMap.put("createUser", createUser);
        paramMap.put("nodeCode", multiNodeCode);
        paramMap.put("userCode", userCode);
        paramMap.put("unitCode", unitCode);
        String json = RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/flow/engine/duplicateMultiNode", paramMap);
        HttpReceiveJSON receiveJSON = HttpReceiveJSON.valueOfJson((String)json);
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        return (NodeInstance)receiveJSON.getDataAsObject(NodeInstance.class);
    }

    public NodeInstance createPrepNodeInst(String flowInstId, String curNodeInstId, String nodeCode, String createUser, String userCode, String unitCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("flowInstId", flowInstId);
        paramMap.put("curNodeInstId", curNodeInstId);
        paramMap.put("nodeCode", nodeCode);
        paramMap.put("createUser", createUser);
        paramMap.put("userCode", userCode);
        paramMap.put("unitCode", unitCode);
        String json = RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/flow/engine/prepNode", paramMap);
        HttpReceiveJSON receiveJSON = HttpReceiveJSON.valueOfJson((String)json);
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        return (NodeInstance)receiveJSON.getDataAsObject(NodeInstance.class);
    }

    public FlowInstanceGroup createFlowInstGroup(String name, String desc) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("flowGroupName", name);
        paramMap.put("flowGroupDesc", desc);
        String json = RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/flow/engine/flowGroup", paramMap);
        HttpReceiveJSON receiveJSON = HttpReceiveJSON.valueOfJson((String)json);
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        return (FlowInstanceGroup)receiveJSON.getDataAsObject(FlowInstanceGroup.class);
    }

    public List<FlowInstanceGroup> listFlowInstGroup(Map<String, Object> paramMap, PageDesc pageDesc) {
        HttpReceiveJSON receiveJSON = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)UrlOptUtils.appendParamsToUrl((String)UrlOptUtils.appendParamsToUrl((String)"/flow/engine/flowGroup", paramMap), (Map)((JSONObject)JSON.toJSON((Object)pageDesc))));
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        pageDesc.copy((PageDesc)receiveJSON.getDataAsObject("pageDesc", PageDesc.class));
        return receiveJSON.getDataAsArray("objList", FlowInstanceGroup.class);
    }

    public JSONArray viewFlowNodes(String flowInstId) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void updateFlowWorkTeam(FlowWorkTeam u) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public List<UserTask> listNodeOperators(String nodeInstId) {
        HttpReceiveJSON receiveJSON = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/flow/engine/nodeTaskUsers?nodeInstId=" + nodeInstId));
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        return receiveJSON.getDataAsArray(UserTask.class);
    }

    public List<UserTask> listFlowActiveNodeOperators(String flowInstId) {
        HttpReceiveJSON receiveJSON = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/flow/engine/flowActiveNodeTask/" + flowInstId));
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        return receiveJSON.getDataAsArray(UserTask.class);
    }

    public List<UserTask> listUserDynamicTask(Map<String, Object> paramMap, PageDesc pageDesc) {
        String userCode = StringBaseOpt.castObjectToString((Object)paramMap.get("userCode"));
        if (StringUtils.isBlank((CharSequence)userCode)) {
            return null;
        }
        HttpReceiveJSON receiveJSON = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)UrlOptUtils.appendParamsToUrl((String)UrlOptUtils.appendParamsToUrl((String)"/flow/engine/dynamicTasks", paramMap), (Map)((JSONObject)JSON.toJSON((Object)pageDesc))));
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        pageDesc.copy((PageDesc)receiveJSON.getDataAsObject("pageDesc", PageDesc.class));
        return receiveJSON.getDataAsArray("objList", UserTask.class);
    }

    public ResponseData dubboUserDynamicTask(Map<String, Object> searchColumn, PageDesc pageDesc) {
        return null;
    }

    public List<UserTask> listUserStaticTask(Map<String, Object> searchColumn, PageDesc pageDesc) {
        HttpReceiveJSON receiveJSON = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)UrlOptUtils.appendParamsToUrl((String)UrlOptUtils.appendParamsToUrl((String)"/flow/engine/staticTasks", searchColumn), (Map)((JSONObject)JSON.toJSON((Object)pageDesc))));
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        pageDesc.copy((PageDesc)receiveJSON.getDataAsObject("pageDesc", PageDesc.class));
        return receiveJSON.getDataAsArray("objList", UserTask.class);
    }

    public ResponseData dubboUserStaticTask(Map<String, Object> searchColumn, PageDesc pageDesc) {
        return null;
    }

    public ResponseData dubboUnitTask(Map<String, Object> searchColumn, PageDesc pageDesc) {
        return null;
    }

    public List<UserTask> listUserGrantorTask(Map<String, Object> searchColumn, PageDesc pageDesc) {
        HttpReceiveJSON receiveJSON = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)UrlOptUtils.appendParamsToUrl((String)UrlOptUtils.appendParamsToUrl((String)"/flow/engine/grantorTasks", searchColumn), (Map)((JSONObject)JSON.toJSON((Object)pageDesc))));
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        pageDesc.copy((PageDesc)receiveJSON.getDataAsObject("pageDesc", PageDesc.class));
        return receiveJSON.getDataAsArray("objList", UserTask.class);
    }

    public ResponseData dubboUserGrantorTask(Map<String, Object> searchColumn, PageDesc pageDesc) {
        return null;
    }

    public List<UserTask> listUserStaticAndGrantorTask(Map<String, Object> paramMap, PageDesc pageDesc) {
        HttpReceiveJSON receiveJSON = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)UrlOptUtils.appendParamsToUrl((String)UrlOptUtils.appendParamsToUrl((String)"/flow/engine/staticAndGrantorTasks", paramMap), (Map)((JSONObject)JSON.toJSON((Object)pageDesc))));
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        pageDesc.copy((PageDesc)receiveJSON.getDataAsObject("pageDesc", PageDesc.class));
        return receiveJSON.getDataAsArray("objList", UserTask.class);
    }

    public ResponseData dubboUserStaticAndGrantorTask(Map<String, Object> searchColumn, PageDesc pageDesc) {
        return null;
    }

    public List<UserTask> listUserAllTask(Map<String, Object> filterMap, PageDesc pageDesc) {
        String userCode = StringBaseOpt.castObjectToString((Object)filterMap.get("userCode"));
        if (StringUtils.isBlank((CharSequence)userCode)) {
            return null;
        }
        HttpReceiveJSON receiveJSON = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)UrlOptUtils.appendParamsToUrl((String)UrlOptUtils.appendParamsToUrl((String)"/flow/engine/userTasks", filterMap), (Map)((JSONObject)JSON.toJSON((Object)pageDesc))));
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        pageDesc.copy((PageDesc)receiveJSON.getDataAsObject("pageDesc", PageDesc.class));
        return receiveJSON.getDataAsArray("objList", UserTask.class);
    }

    public ResponseData dubboUserAllTask(Map<String, Object> searchColumn, PageDesc pageDesc) {
        return null;
    }

    public FlowInstance createInstance(CreateFlowOptions options, UserUnitVariableTranslate varTrans) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public List<String> submitOpt(SubmitOptOptions options, UserUnitVariableTranslate varTrans) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public Set<NodeInfo> viewNextNode(SubmitOptOptions options) {
        String json = RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/flow/engine/viewNextNode", (Object)options);
        HttpReceiveJSON receiveJSON = HttpReceiveJSON.valueOfJson((String)json);
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        return new HashSet<NodeInfo>(receiveJSON.getDataAsArray(NodeInfo.class));
    }

    public Set<String> viewNextNodeOperator(String nextNodeId, SubmitOptOptions options) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("nextNodeId", nextNodeId);
        paramMap.put("options", (String)options);
        String json = RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/flow/engine/viewNextNodeOperator", paramMap);
        HttpReceiveJSON receiveJSON = HttpReceiveJSON.valueOfJson((String)json);
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        return new HashSet<String>(receiveJSON.getDataAsArray(String.class));
    }

    public List<UserTask> listUserCompleteTasks(Map<String, Object> filterMap, PageDesc pageDesc) {
        HttpReceiveJSON receiveJSON = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)UrlOptUtils.appendParamsToUrl((String)UrlOptUtils.appendParamsToUrl((String)"/flow/engine/listCompleteTasks", filterMap), (Map)((JSONObject)JSON.toJSON((Object)pageDesc))));
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        pageDesc.copy((PageDesc)receiveJSON.getDataAsObject("pageDesc", PageDesc.class));
        return receiveJSON.getDataAsArray("objList", UserTask.class);
    }

    public boolean canAccess(String nodeInstId, String userCode) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public String getTaskGrantor(String nodeInstId, String userCode) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public List<FlowWarning> listFlowWarning(Map<String, Object> filterMap, PageDesc pageDesc) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public List<FlowWarning> listFlowWarningByInst(String flowInstId, PageDesc pageDesc) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public List<FlowWarning> listFlowWarningByNodeInst(String nodeInstId, PageDesc pageDesc) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public List<FlowWarning> listFlowWarningByWarningCode(String warningCode, PageDesc pageDesc) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void updateFlowInstParentNode(String flowInstId, String parentFlowInstId, String parentNodeInstId) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void disableOtherBranchNodes(String nodeInstId, String optUserCode) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void assignFlowWorkTeam(String flowInstId, String roleCode, String runToken, List<String> userCodeSet) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void deleteFlowWorkTeam(String flowInstId, String roleCode, String userCode) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void assignFlowOrganize(String flowInstId, String roleCode, String unitCode, String authdesc) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void assignFlowOrganize(String flowInstId, String roleCode, List<String> unitCodeSet, String authdesc) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void deleteFlowOrganize(String flowInstId, String roleCode, String unitCode) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void deleteFlowOrganizeByAuth(String flowInstId, String roleCode, String authDesc) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public Map<String, List<String>> viewFlowOrganize(String flowInstId) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public List<FlowOrganize> viewFlowOrganizeList(String flowInstId, String roleCode) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public List<FlowOrganize> viewFlowOrganizeList(String flowInstId, String roleCode, String authDesc) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public List<FlowVariable> listFlowVariables(String flowInstId) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public FlowVariable viewNodeVariable(String flowInstId, String runToken, String varname) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public String getNodeOptUrl(String nodeInstId, String userCode) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public List<NodeInstance> listNodeInstanceByNodeCode(String flowInstId, String nodeCode) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public StageInstance getStageInstByNodeInstId(String nodeInstId) {
        throw new ObjectException("This function is not been implemented in client.");
    }
}

