/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.client.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.appclient.AppSession;
import com.centit.framework.appclient.HttpReceiveJSON;
import com.centit.framework.appclient.RestfulHttpRequest;
import com.centit.framework.common.ResponseData;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.network.UrlOptUtils;
import com.centit.workflow.client.service.impl.WorkflowAppSession;
import com.centit.workflow.po.FlowInstance;
import com.centit.workflow.po.FlowInstanceGroup;
import com.centit.workflow.po.NodeInstance;
import com.centit.workflow.po.RoleRelegate;
import com.centit.workflow.po.StageInstance;
import com.centit.workflow.po.TaskMove;
import com.centit.workflow.service.FlowManager;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowManagerClientImpl
implements FlowManager {
    private WorkflowAppSession appSession;

    @Autowired
    public void setAppSession(WorkflowAppSession appSession) {
        this.appSession = appSession;
    }

    public List<NodeInstance> listFlowInstNodes(String wfinstid) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("flowInstId", String.valueOf(wfinstid));
        HttpReceiveJSON receiveJSON = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)"/flow/manager/listFlowInstNodes", paramMap);
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        return receiveJSON.getDataAsArray(NodeInstance.class);
    }

    public List<NodeInstance> listFlowActiveNodes(String flowInstId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("flowInstId", String.valueOf(flowInstId));
        HttpReceiveJSON receiveJSON = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)"/flow/engine/activeNodes", paramMap);
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        return receiveJSON.getDataAsArray(NodeInstance.class);
    }

    public FlowInstance getFlowInstance(String flowInstId) {
        HttpReceiveJSON receiveJSON = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/flow/manager/" + flowInstId));
        return (FlowInstance)receiveJSON.getDataAsObject("flowInst", FlowInstance.class);
    }

    public int stopInstance(String flowInstId, CentitUserDetails managerUser, String admindesc) {
        RestfulHttpRequest.jsonPut((AppSession)this.appSession, (String)("/flow/manager/stopInstance/" + flowInstId + "/" + managerUser.getUserCode()), null);
        return 0;
    }

    public int suspendInstance(String flowInstId, CentitUserDetails managerUser, String admindesc) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("admin", managerUser.getUserCode());
        paramMap.put("stopDesc", admindesc);
        RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/flow/manager/suspendinst/" + flowInstId), paramMap);
        return 0;
    }

    public int activizeInstance(String flowInstId, CentitUserDetails managerUser, String admindesc) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("admin", managerUser.getUserCode());
        paramMap.put("stopDesc", admindesc);
        RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/flow/manager/activizeinst/" + flowInstId), paramMap);
        return 0;
    }

    public long suspendNodeInstance(String nodeInstId, CentitUserDetails managerUser) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("admin", managerUser.getUserCode());
        RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/flow/manager/suspendNodeInst/" + nodeInstId), paramMap);
        return 0L;
    }

    public long activizeNodeInstance(String nodeInstId, CentitUserDetails managerUser) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("admin", managerUser.getUserCode());
        RestfulHttpRequest.jsonPut((AppSession)this.appSession, (String)("/flow/manager/activizeNodeInst/" + nodeInstId), paramMap);
        return 0L;
    }

    public String forceCommit(String nodeInstId, CentitUserDetails managerUser) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("admin", managerUser.getUserCode());
        HttpReceiveJSON receiveJSON = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/flow/manager/forceCommit/" + nodeInstId), paramMap);
        return receiveJSON.getDataAsString();
    }

    public NodeInstance resetFlowToThisNode(String nodeInstId, CentitUserDetails managerUser) {
        String json = RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)("/flow/manager/resetToCurrent/" + nodeInstId + "?userCode=" + managerUser.getUserCode()), null);
        HttpReceiveJSON receiveJSON = HttpReceiveJSON.valueOfJson((String)json);
        return (NodeInstance)receiveJSON.getDataAsObject(NodeInstance.class);
    }

    public int assignNodeTask(String nodeInstId, String userCode, CentitUserDetails managerUser, String authDesc) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userCode", userCode);
        paramMap.put("authDesc", authDesc);
        RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)("/flow/manager/assign/" + nodeInstId + "/" + managerUser.getUserCode()), paramMap);
        return 0;
    }

    public List<OperationLog> listNodeActionLogs(String flowInstId, String nodeInstId) {
        HttpReceiveJSON receiveJSON = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/flow/manager/nodelogs/" + flowInstId + "/" + nodeInstId));
        return receiveJSON.getDataAsArray(OperationLog.class);
    }

    public List<OperationLog> listFlowActionLogs(String flowInstId, String topUnit) {
        HttpReceiveJSON receiveJSON = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/flow/manager/flowlogs/" + flowInstId + "?topUnit=" + topUnit));
        return receiveJSON.getDataAsArray(OperationLog.class);
    }

    public List<? extends OperationLog> listUserActionLogs(String userCode, Date lastTime, PageDesc pageDesc) {
        String url = UrlOptUtils.appendParamsToUrl((String)("/flow/manager/userlogs/" + userCode), (Map)((JSONObject)JSON.toJSON((Object)pageDesc)));
        if (lastTime != null) {
            UrlOptUtils.appendParamToUrl((String)url, (String)("lastTime=" + DatetimeOpt.convertDatetimeToString((Date)lastTime)));
        }
        HttpReceiveJSON receiveJSON = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)url);
        pageDesc.copy((PageDesc)receiveJSON.getDataAsObject("pageDesc", PageDesc.class));
        return receiveJSON.getDataAsArray("objList", OperationLog.class);
    }

    public JSONArray listFlowInstance(Map<String, Object> filterMap, PageDesc pageDesc) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public Map<String, Object> viewFlowInstance(String flowInstId) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public String viewFlowNodeInstance(String flowInstId) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public List<FlowInstance> listPauseTimerFlowInst(String userCode, PageDesc pageDesc) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public int suspendFlowInstTimer(String flowInstId, CentitUserDetails managerUser) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public int activizeFlowInstTimer(String flowInstId, CentitUserDetails managerUser) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public long resetFlowTimelimt(String flowInstId, String timeLimit, CentitUserDetails managerUser, String admindesc) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void updateFlowInstUnit(String flowInstId, String unitCode, CentitUserDetails managerUser) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public List<NodeInstance> listPauseTimerNodeInst(String userCode, PageDesc pageDesc) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public int suspendNodeInstTimer(String nodeInstId, CentitUserDetails managerUser) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public int activizeNodeInstTimer(String nodeInstId, CentitUserDetails managerUser) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public String forceDissociateRuning(String nodeInstId, CentitUserDetails managerUser) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void updateNodeInstUnit(String nodeInstId, String unitCode, CentitUserDetails managerUser) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void updateNodeRoleInfo(String nodeInstId, String roleType, String roleCode, CentitUserDetails managerUser) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public long resetNodeTimelimt(String nodeInstId, String timeLimit, CentitUserDetails managerUser, String topUnit) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public List<StageInstance> listStageInstByFlowInstId(String flowInstId) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public long resetStageTimelimt(String flowInstId, String stageId, String timeLimit, CentitUserDetails managerUser, String admindesc) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public List<? extends OperationLog> listNodeActionLogs(String nodeInstId) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public List<NodeInstance> listNodesWithoutOpt() {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public RoleRelegate getRoleRelegateById(String relegateno) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void saveRoleRelegate(RoleRelegate roleRelegate) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void deleteRoleRelegateByUserCode(String grantor, String grantee) {
    }

    public List<RoleRelegate> listRoleRelegateByUser(String userCode) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public List<RoleRelegate> listRoleRelegateByGrantor(String grantor) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public int moveUserTaskTo(String topUnit, String fromUserCode, String toUserCode, CentitUserDetails managerUser, String moveDesc) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public int moveUserTaskToByOs(String osId, String fromUserCode, String toUserCode, CentitUserDetails managerUser, String moveDesc) {
        return 0;
    }

    public int moveUserTaskTo(List<String> nodeInstIds, String fromUserCode, String toUserCode, CentitUserDetails managerUser, String moveDesc) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void moveUserTaskTo(Map<String, Object> params, String fromUserCode, String toUserCode, CentitUserDetails managerUser, String moveDesc) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void updateFlow(FlowInstance flowInstance) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public int changeTaskAssignScheme(TaskMove taskMove, CentitUserDetails managerUser) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public NodeInstance reStartFlow(String flowInstId, CentitUserDetails managerUser, Boolean force) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public List<JSONObject> getListRoleRelegateByGrantor(String grantor) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public JSONArray listFlowInstGroup(Map<String, Object> filterMap, PageDesc pageDesc) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public FlowInstanceGroup getFlowInstanceGroup(String flowInstGroupId) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void updateFlowInstOptInfoAndUser(String flowInstId, String flowOptName, String flowOptTag, String userCode, String unitCode) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public NodeInstance getFirstNodeInst(String flowInstId) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public boolean deleteFlowInstById(String flowInstId, String userCode) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public List<NodeInstance> listNodeInstance(Map<String, Object> searchColumn, PageDesc pageDesc) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public ResponseData dubboNodeInstance(Map<String, Object> searchColumn, PageDesc pageDesc) {
        return null;
    }

    public void updateFlowState(String flowInstId, CentitUserDetails managerUser, String instState, String desc) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public JSONArray listFlowInstDetailed(Map<String, Object> searchColumn, PageDesc pageDesc) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void deleteFlowInstByIds(List<String> flowInstIds) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void upgradeFlowVersion(String flowCode, long newVersion, long oldVersion, String topUnit, CentitUserDetails managerUser) {
        throw new ObjectException("This function is not been implemented in client.");
    }

    public void updateNodeState(String nodeInstId, String newState, CentitUserDetails managerUser) {
        throw new ObjectException("This function is not been implemented in client.");
    }
}

