/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.dbdesign.controller;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.fileserver.utils.SystemTempFileUtils;
import com.centit.fileserver.utils.UploadDownloadUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.DictionaryMapColumn;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.product.dbdesign.service.MetaChangLogManager;
import com.centit.product.dbdesign.service.MetaTableManager;
import com.centit.product.dbdesign.service.TranslateColumn;
import com.centit.product.metadata.po.MetaChangLog;
import com.centit.product.metadata.po.PendingMetaColumn;
import com.centit.product.metadata.po.PendingMetaTable;
import com.centit.product.metadata.utils.PdmTableInfoUtils;
import com.centit.support.common.ObjectException;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileSystemOpt;
import com.centit.support.network.HtmlFormUtils;
import com.centit.support.security.SecurityOptUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/mdtable"})
@Api(value="\u6570\u636e\u91cd\u6784", tags={"\u6570\u636e\u91cd\u6784"})
public class MetaTableController
extends BaseController {
    @Resource
    private MetaTableManager metaTableManager;
    @Resource
    private MetaChangLogManager metaChangLogManager;
    @Resource
    private TranslateColumn translateColumn;

    @ApiOperation(value="\u67e5\u8be2\u91cd\u6784\u8bb0\u5f55")
    @RequestMapping(value={"/{databaseCode}/log"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult loglist(@PathVariable String databaseCode, String[] field, PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = MetaTableController.collectRequestParameters((HttpServletRequest)request);
        searchColumn.put("databaseCode", databaseCode);
        JSONArray listObjects = this.metaChangLogManager.listMdChangLogsAsJson(field, searchColumn, pageDesc);
        if (ArrayUtils.isNotEmpty((Object[])field)) {
            return PageQueryResult.createJSONArrayResult((JSONArray)listObjects, (PageDesc)pageDesc, (String[])field, (Class[])new Class[]{MetaChangLog.class});
        }
        return PageQueryResult.createJSONArrayResult((JSONArray)listObjects, (PageDesc)pageDesc, (Class[])new Class[]{MetaChangLog.class});
    }

    @ApiOperation(value="\u67e5\u770b\u5355\u4e2a\u8868\u91cd\u6784\u8bb0\u5f55")
    @RequestMapping(value={"/log/{changeId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public MetaChangLog getMdTableLog(@PathVariable String changeId) {
        return this.metaTableManager.getMetaChangLog(changeId);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u8868\u91cd\u6784\u5b57\u6bb5")
    @RequestMapping(value={"/{tableId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public PendingMetaTable getMdTableDraft(@PathVariable String tableId, HttpServletRequest request) {
        PendingMetaTable mdTable = this.metaTableManager.getPendingMetaTable(tableId);
        if (null != mdTable) {
            if (null == mdTable.getColumns()) {
                mdTable.setMdColumns(new ArrayList());
            }
            return mdTable;
        }
        mdTable = this.metaTableManager.initPendingMetaTable(tableId, WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        return mdTable;
    }

    @ApiOperation(value="\u65b0\u589e\u91cd\u6784\u8868")
    @RequestMapping(method={RequestMethod.POST})
    @WrapUpResponseBody
    public String createMdTable(PendingMetaTable mdTable, HttpServletRequest request) {
        this.judgeColumnsRepeat(mdTable);
        boolean isExist = this.metaTableManager.isTableExist(mdTable.getTableName(), mdTable.getDatabaseCode());
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        mdTable.setRecorder(userCode);
        mdTable.setTableState("W");
        mdTable.setViewSql(HtmlFormUtils.htmlString((String)mdTable.getViewSql()));
        PendingMetaTable table = new PendingMetaTable();
        table.copyNotNullProperty(mdTable);
        if (!isExist) {
            this.metaTableManager.saveNewPendingMetaTable(table);
            return table.getTableId();
        }
        if ("V".equals(mdTable.getTableType())) {
            this.metaTableManager.savePendingMetaTable(table);
            return table.getTableId();
        }
        throw new ObjectException(800, mdTable.getTableName() + "\u5df2\u5b58\u5728");
    }

    private void judgeColumnsRepeat(PendingMetaTable mdTable) {
        if (mdTable.getColumns() != null && mdTable.getColumns().size() > 0) {
            int columnLength = mdTable.getColumns().size();
            HashSet<String> columnUppers = new HashSet<String>();
            for (int i = 0; i < columnLength; ++i) {
                columnUppers.add(StringUtils.upperCase((String)((PendingMetaColumn)mdTable.getColumns().get(i)).getColumnName()));
            }
            int columnUpperLength = columnUppers.size();
            if (columnLength != columnUpperLength) {
                throw new ObjectException(800, "\u7ecf\u540e\u53f0\u68c0\u6d4b\u540e\uff0c\u6709\u91cd\u590d\u5b57\u6bb5\u4ee3\u7801(\u4e0d\u533a\u5206\u5927\u5c0f\u5199)");
            }
        }
    }

    @ApiOperation(value="\u4fee\u6539\u91cd\u6784\u8868")
    @PutMapping(value={"/table/{tableId}"})
    @WrapUpResponseBody
    public void updateMetaTable(@PathVariable String tableId, @RequestBody PendingMetaTable metaTable, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        metaTable.setTableId(tableId);
        metaTable.setRecorder(userCode);
        metaTable.setViewSql(HtmlFormUtils.htmlString((String)metaTable.getViewSql()));
        this.metaTableManager.updateMetaTable(metaTable);
    }

    @ApiOperation(value="\u4fee\u6539\u91cd\u6784\u8868\u5b57\u6bb5")
    @PutMapping(value={"/column/{tableId}/{columnCode}"})
    @WrapUpResponseBody
    public void updateMetaColumns(@PathVariable String tableId, @PathVariable String columnCode, @RequestBody String mcJsonStr) {
        PendingMetaColumn metaColumn = (PendingMetaColumn)JSONObject.parseObject((String)SecurityOptUtils.decodeSecurityString((String)mcJsonStr), PendingMetaColumn.class);
        metaColumn.setTableId(tableId);
        metaColumn.setColumnName(columnCode);
        this.metaTableManager.updateMetaColumn(metaColumn);
    }

    @ApiOperation(value="\u7f16\u8f91\u91cd\u6784\u8868")
    @RequestMapping(value={"/{tableId}"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public void updateMdTable(@PathVariable String tableId, @RequestBody PendingMetaTable mdTable) {
        this.judgeColumnsRepeat(mdTable);
        mdTable.setTableId(tableId);
        List<String> alterSqls = this.metaTableManager.makeAlterTableSqlList(mdTable);
        mdTable.setTableState(alterSqls.size() > 0 ? "W" : "S");
        this.metaTableManager.savePendingMetaTable(mdTable);
    }

    @ApiOperation(value="\u5220\u9664\u91cd\u6784\u8868")
    @RequestMapping(value={"/{tableId}"}, method={RequestMethod.DELETE})
    @WrapUpResponseBody
    public void deleteMdTable(@PathVariable String tableId) {
        this.metaTableManager.deletePendingMetaTable(tableId);
    }

    @ApiOperation(value="\u67e5\u770b\u53d1\u5e03\u91cd\u6784\u8868sql")
    @RequestMapping(value={"/beforePublish/{pendingTableId}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData alertSqlBeforePublish(@PathVariable String pendingTableId) {
        List<String> sqlList = this.metaTableManager.makeAlterTableSqlList(pendingTableId);
        if (null == sqlList) {
            return ResponseData.makeErrorMessage((int)601, (String)"\u8868\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ResponseData.makeResponseData(sqlList);
    }

    @ApiOperation(value="\u53d1\u5e03\u91cd\u6784\u8868")
    @RequestMapping(value={"/publish/{pendingTableId}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData publishMdTable(@PathVariable String pendingTableId, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        return this.metaTableManager.publishMetaTable(pendingTableId, userCode);
    }

    @ApiOperation(value="\u83b7\u53d6\u521b\u5efa\u8868\u7ed3\u6784DDL\u811a\u672c")
    @RequestMapping(value={"/ddl/{pendingTableId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData makeTableDDL(@PathVariable String pendingTableId, HttpServletRequest request) {
        WebOptUtils.assertUserLogin((HttpServletRequest)request);
        return this.metaTableManager.generateTableDDL(pendingTableId);
    }

    @ApiOperation(value="\u6279\u91cf\u53d1\u5e03\u8868\u5143\u6570\u636e\u8868")
    @RequestMapping(value={"/{databaseCode}/publish"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData publishDatabase(@PathVariable String databaseCode, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        return this.metaTableManager.publishDatabase(databaseCode, userCode);
    }

    @ApiOperation(value="\u6279\u91cf\u53d1\u5e03\u8868\u5143\u6570\u636e\u8868")
    @PutMapping(value={"/batchPublishTable"})
    @WrapUpResponseBody
    public ResponseData batchPublishTable(@RequestBody String formJsonString, HttpServletRequest request) {
        JSONObject formJson = JSONObject.parseObject((String)formJsonString);
        JSONObject filter = formJson.getJSONObject("filter");
        if (filter == null) {
            throw new ObjectException(701, "\u8f93\u5165\u7684\u8868\u5355\u6570\u636e\u6709\u9519");
        }
        List<PendingMetaTable> tables = this.metaTableManager.searchPendingMetaTable(filter, true);
        if (tables == null || tables.isEmpty()) {
            throw new ObjectException(604, "\u6ca1\u6709\u8981\u53d1\u5e03\u7684\u8868\u5355");
        }
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        return this.metaTableManager.batchPublishTables(tables, userCode);
    }

    @ApiOperation(value="range")
    @CrossOrigin(origins={"*"}, allowCredentials="true", maxAge=86400L, methods={RequestMethod.GET})
    @RequestMapping(value={"/range"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public JSONObject checkFileRange(String token, long size) {
        String tempFilePath = SystemTempFileUtils.getTempFilePath((String)token, (long)size);
        long tempFileSize = SystemTempFileUtils.checkTempFileSize((String)tempFilePath);
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put("tempFilePath", token + "_" + size);
        JSONObject jsonObject = UploadDownloadUtils.makeRangeUploadJson((long)tempFileSize, (String)token, (String)(token + "_" + size));
        if (tempFileSize == size) {
            data.put("tables", this.fetchPdmTables(tempFilePath));
            jsonObject.put((Object)"tables", data);
        }
        return jsonObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiOperation(value="\u5bfc\u5165pdm\u8fd4\u56de\u8868\u6570\u636e")
    @CrossOrigin(origins={"*"}, allowCredentials="true", maxAge=86400L, methods={RequestMethod.POST})
    @RequestMapping(value={"/range"}, method={RequestMethod.POST})
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    public JSONObject syncPdm(String token, long size, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Pair fileInfo = UploadDownloadUtils.fetchInputStreamFromMultipartResolver((HttpServletRequest)request);
        FileSystemOpt.createDirect((String)SystemTempFileUtils.getTempDirectory());
        String tempFilePath = SystemTempFileUtils.getTempFilePath((String)token, (long)size);
        try (FileOutputStream out = new FileOutputStream(new File(tempFilePath));){
            long uploadSize = FileIOOpt.writeInputStreamToOutputStream((InputStream)((InputStream)fileInfo.getRight()), (OutputStream)out);
            if (uploadSize > 0L) {
                JSONObject jsonObject = new JSONObject();
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("tempFilePath", token + "_" + size);
                data.put("tables", PdmTableInfoUtils.getTableNameFromPdm((String)tempFilePath));
                jsonObject.put((Object)"tables", data);
                JSONObject jSONObject = ResponseData.makeResponseData((Map)jsonObject).toJSONObject();
                return jSONObject;
            }
            JSONObject jSONObject = UploadDownloadUtils.makeRangeUploadJson((long)uploadSize, (String)token, (String)(token + "_" + size));
            return jSONObject;
        }
        catch (ObjectException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ObjectException(e.getExceptionCode(), e.getMessage());
        }
    }

    @ApiOperation(value="\u786e\u8ba4\u5bfc\u5165pdm\u4fee\u6539\u8868\u5143\u6570\u636e\u8868")
    @RequestMapping(value={"/{databaseCode}/confirm"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData syncConfirm(@PathVariable String databaseCode, @RequestBody String data, HttpServletRequest request, HttpServletResponse response) {
        Map params = MetaTableController.collectRequestParameters((HttpServletRequest)request);
        JSONObject object = JSON.parseObject((String)data);
        object.putAll(params);
        String tempFilePath = SystemTempFileUtils.getTempDirectory() + object.getString("tempFilePath") + ".tmp";
        JSONArray jsonArray = object.getJSONArray("data");
        ArrayList<String> tables = new ArrayList<String>();
        for (Object o : jsonArray) {
            tables.add(o.toString());
        }
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        Pair<Integer, String> ret = this.metaTableManager.syncPdm(databaseCode, tempFilePath, tables, userCode);
        return ResponseData.makeErrorMessage((int)((Integer)ret.getLeft()), (String)((String)ret.getRight()));
    }

    @ApiOperation(value="\u67e5\u8be2\u8868\u5217\u6570\u636e\u5143\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tableId", value="\u8868ID")})
    @GetMapping(value={"/{tableId}/columns"})
    @WrapUpResponseBody
    public PageQueryResult<PendingMetaColumn> listColumns(@PathVariable String tableId, PageDesc pageDesc) {
        List<PendingMetaColumn> list = this.metaTableManager.listMetaColumns(tableId, pageDesc);
        return PageQueryResult.createResult(list, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u5217\u8868\u5143\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tableId", value="\u8868\u5143\u6570\u636eID"), @ApiImplicitParam(name="columnName", value="\u5217\u540d")})
    @GetMapping(value={"/{tableId}/column/{columnName}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public PendingMetaColumn getColumn(@PathVariable String tableId, @PathVariable String columnName) {
        return this.metaTableManager.getMetaColumn(tableId, columnName);
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u5143\u6570\u636e,pending\u8868\u4e0emd\u8868\u6570\u636e\u7684\u7ec4\u5408,\u901a\u8fc7osId,dataBaseCode\u8fc7\u6ee4,\u5982\u679cosId\u548cdataBaseCode\u4e0d\u4f20,\u540e\u7aef\u6839\u636etopUnit\u8fc7\u6ee4)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="databaseCode", value="\u6570\u636e\u5e93code", paramType="query"), @ApiImplicitParam(name="optId", value="\u64cd\u4f5cid", paramType="query"), @ApiImplicitParam(name="likeTableNameOrLabel", value="\u6839\u636e\u8868\u4ee3\u7801\u6216\u8868\u540d\u6a21\u7cca\u8fc7\u6ee4", paramType="query"), @ApiImplicitParam(name="tableLabelName", value="\u6839\u636e\u8868\u540d\u8fc7\u6ee4", paramType="query"), @ApiImplicitParam(name="tableName", value="\u6839\u636e\u8868\u4ee3\u7801\u8fc7\u6ee4", paramType="query"), @ApiImplicitParam(name="sourceType", value="\u6839\u636e\u8868\u7c7b\u578b\u8fc7\u6ee4\u3002\u8d44\u6e90\u7c7b\u578b,D:\u5173\u7cfb\u6570\u636e\u5e93 M:MongoDb R:redis E:elssearch K:kafka B:rabbitmq,H http\u670d\u52a1", paramType="query")})
    @GetMapping(value={"/listCombineTables"})
    @WrapUpResponseBody
    public PageQueryResult listCombineTables(PageDesc pageDesc, HttpServletRequest request) {
        Map parameters = MetaTableController.collectRequestParameters((HttpServletRequest)request);
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        parameters.put("topUnit", topUnit);
        List list = this.metaTableManager.listCombineTablesByProperty(parameters, pageDesc);
        this.tableDictionaryMap(list);
        return PageQueryResult.createResult((Collection)list, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u540c\u6b65\u6570\u636e\u5e93")
    @ApiImplicitParam(name="databaseCode", value="\u6570\u636e\u5e93ID")
    @GetMapping(value={"/sync/{databaseCode}"})
    @WrapUpResponseBody
    public ResponseData syncDb(@PathVariable String databaseCode, String[] tableNames, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (tableNames == null) {
            this.metaTableManager.syncDb(databaseCode, userCode, null);
        } else {
            this.metaTableManager.syncDb(databaseCode, userCode, tableNames);
        }
        return ResponseData.makeSuccessResponse();
    }

    private List<SimpleTableInfo> fetchPdmTables(String tempFilePath) {
        if ("".equals(tempFilePath)) {
            throw new ObjectException("pdm\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return PdmTableInfoUtils.importTableFromPdm((String)tempFilePath);
    }

    private void tableDictionaryMap(List list) {
        DictionaryMapColumn dicMap1 = new DictionaryMapColumn("recorder", "recorderName", "userCode");
        DictionaryMapColumn dicMap2 = new DictionaryMapColumn("tableType", "tableTypeText", "tableType");
        ArrayList<DictionaryMapColumn> dicMaps = new ArrayList<DictionaryMapColumn>();
        dicMaps.add(dicMap1);
        dicMaps.add(dicMap2);
        DictionaryMapUtils.mapJsonArray((List)list, dicMaps);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6570\u636e\u5e93\u8868\u6570\u636e\u5217\u8868")
    @RequestMapping(value={"/{databaseId}/viewlist"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public JSONArray viewList(@PathVariable String databaseId, @RequestBody JSONObject sql) throws IOException, SQLException {
        return this.metaTableManager.viewList(databaseId, sql.getString("sql"));
    }

    @ApiOperation(value="\u6839\u636e\u4e2d\u6587\u540d\u79f0\u7ffb\u8bd1\u8868\u540d\u6216\u8005\u5b57\u6bb5\u540d")
    @RequestMapping(value={"/map/column"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public String mapLabelToColumn(@RequestParam(value="labelName") String labelName) {
        return this.translateColumn.transLabelToColumn(labelName);
    }

    @ApiOperation(value="\u6839\u636e\u4e2d\u6587\u540d\u79f0\u7ffb\u8bd1\u5c5e\u6027\u540d\u79f0")
    @RequestMapping(value={"/map/property"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public String mapLabelToProperty(@RequestParam(value="labelName") String labelName) {
        return this.translateColumn.transLabelToProperty(labelName);
    }

    @ApiOperation(value="\u5bfc\u5165TableStore\u4e2d\u5bfc\u5165\u8868\u7ed3\u6784")
    @ApiImplicitParam(name="databaseCode", type="path", value="\u6570\u636e\u5e93ID")
    @RequestMapping(value={"/import/{databaseCode}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public void importFromTableStore(@PathVariable String databaseCode, HttpServletRequest request) throws IOException {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(403, "\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\u53ef\u80fd\u662f\u7528\u6237\u6ca1\u767b\u5f55\uff0c\u6216\u8005session\u5df2\u5931\u6548\uff01");
        }
        Pair fileInfo = UploadDownloadUtils.fetchInputStreamFromMultipartResolver((HttpServletRequest)request);
        JSONObject jsonObject = JSON.parseObject((InputStream)((InputStream)fileInfo.getRight()), (JSONReader.Feature[])new JSONReader.Feature[0]);
        if (!(jsonObject != null && jsonObject.containsKey("projectInfo") && jsonObject.containsKey("tables") && jsonObject.containsKey("modules"))) {
            throw new ObjectException(611, "\u6587\u4ef6\u4e2d\u7684json\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        this.metaTableManager.importFromTableStore(databaseCode, jsonObject, userCode);
    }

    @ApiOperation(value="\u6279\u91cf\u6dfb\u52a0\u6216\u4fee\u6539\u8868\u7684\u5b57\u6bb5\uff0c\u548c\u65b0\u5efa\u8868\u5b57\u6bb5\u4e00\u6837")
    @PutMapping(value={"/batchSetColumn"})
    @ApiImplicitParam(name="formJsonString", paramType="body", value="JSON\u4e2d\u5206\u4e24\u90e8\u5206\uff0c\u4e00\u90e8\u5206\u662f\u67e5\u8be2\u6761\u4ef6\uff0c\u4e00\u90e8\u5206\u662f\u4fee\u6539\u7684\u5c5e\u6027")
    @WrapUpResponseBody
    public int batchSetTableColumn(@RequestBody String formJsonString) {
        JSONObject formJson = JSONObject.parseObject((String)formJsonString);
        JSONObject filter = formJson.getJSONObject("filter");
        if (filter == null) {
            return 0;
        }
        JSONObject props = formJson.getJSONObject("props");
        if (props == null || props.isEmpty()) {
            return 0;
        }
        String columnName = props.getString("columnName");
        if (StringUtils.isBlank((CharSequence)columnName)) {
            throw new ObjectException(611, "\u6279\u91cf\u4fee\u6539\u8868\u7684\u5b57\u6bb5\u5c5e\u6027\uff0c\u5fc5\u987b\u6307\u5b9a\u5b57\u6bb5\u540d\uff1acolumnName\uff01");
        }
        PendingMetaColumn columnInfo = (PendingMetaColumn)props.toJavaObject(PendingMetaColumn.class, new JSONReader.Feature[0]);
        List<PendingMetaTable> tables = this.metaTableManager.searchPendingMetaTable(filter, false);
        if (tables == null || tables.isEmpty()) {
            return 0;
        }
        for (PendingMetaTable metaTable : tables) {
            this.metaTableManager.updatePendingMetaColumn(metaTable, columnInfo);
        }
        return tables.size();
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8868\u7684\u5b57\u6bb5")
    @PutMapping(value={"/batchDeleteColumn"})
    @WrapUpResponseBody
    public int batchDeleteTableColumns(@RequestBody String formJsonString) {
        JSONObject formJson = JSONObject.parseObject((String)formJsonString);
        JSONObject filter = formJson.getJSONObject("filter");
        if (filter == null) {
            return 0;
        }
        JSONObject props = formJson.getJSONObject("props");
        if (props == null || props.isEmpty()) {
            return 0;
        }
        String columnName = props.getString("columnName");
        if (StringUtils.isBlank((CharSequence)columnName)) {
            throw new ObjectException(611, "\u6279\u91cf\u4fee\u6539\u8868\u7684\u5b57\u6bb5\u5c5e\u6027\uff0c\u5fc5\u987b\u6307\u5b9a\u5b57\u6bb5\u540d\uff1acolumnName\uff01");
        }
        List<PendingMetaTable> tables = this.metaTableManager.searchPendingMetaTable(filter, false);
        if (tables == null || tables.isEmpty()) {
            return 0;
        }
        for (PendingMetaTable metaTable : tables) {
            this.metaTableManager.deletePendingMetaColumn(metaTable, columnName);
        }
        return tables.size();
    }
}

