/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.dbdesign.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.product.dbdesign.dao.MetaChangLogDao;
import com.centit.product.dbdesign.dao.PendingMetaColumnDao;
import com.centit.product.dbdesign.dao.PendingMetaTableDao;
import com.centit.product.dbdesign.service.MetaTableManager;
import com.centit.product.metadata.api.ISourceInfo;
import com.centit.product.metadata.dao.MetaColumnDao;
import com.centit.product.metadata.dao.MetaTableDao;
import com.centit.product.metadata.po.MetaChangLog;
import com.centit.product.metadata.po.MetaColumn;
import com.centit.product.metadata.po.MetaTable;
import com.centit.product.metadata.po.PendingMetaColumn;
import com.centit.product.metadata.po.PendingMetaTable;
import com.centit.product.metadata.po.SourceInfo;
import com.centit.product.metadata.service.MetaDataService;
import com.centit.product.metadata.service.SourceInfoMetadata;
import com.centit.product.metadata.service.impl.MetaDataServiceImpl;
import com.centit.product.metadata.transaction.AbstractDBConnectPools;
import com.centit.product.metadata.utils.PdmTableInfoUtils;
import com.centit.product.metadata.utils.TableStoreJsonUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.ddl.DDLOperations;
import com.centit.support.database.ddl.GeneralDDLOperations;
import com.centit.support.database.metadata.IDatabaseInfo;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.DDLUtils;
import com.centit.support.database.utils.DataSourceDescription;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.FieldType;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.TransactionHandler;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class MetaTableManagerImpl
implements MetaTableManager {
    public static final String VIEW = "V";
    private static final Logger logger = LoggerFactory.getLogger(MetaTableManagerImpl.class);
    @Autowired
    private SourceInfoMetadata sourceInfoMetadata;
    @Autowired
    private MetaDataService metaDataService;
    private MetaTableDao metaTableDao;
    @Resource
    private MetaColumnDao metaColumnDao;
    @Resource
    private MetaChangLogDao metaChangLogDao;
    @Resource
    private PendingMetaTableDao pendingMdTableDao;
    @Resource
    private PendingMetaColumnDao pendingMetaColumnDao;

    @Resource(name="metaTableDao")
    @NotNull
    public void setMetaTableDao(MetaTableDao baseDao) {
        this.metaTableDao = baseDao;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public JSONArray listMdTablesAsJson(String[] fields, Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.metaTableDao.listObjectsByPropertiesAsJson(filterMap, pageDesc);
    }

    @Override
    @Transactional
    public void saveNewPendingMetaTable(PendingMetaTable pmt) {
        this.pendingMdTableDao.saveNewObject((Serializable)pmt);
        this.pendingMdTableDao.saveObjectReferences((Serializable)pmt);
    }

    @Override
    @Transactional
    public void deletePendingMetaTable(String tableId) {
        this.pendingMdTableDao.deleteObjectById(tableId);
        HashMap<String, String> tempFilter = new HashMap<String, String>();
        tempFilter.put("tableId", tableId);
        this.pendingMetaColumnDao.deleteObjectsForceByProperties(tempFilter);
    }

    @Override
    @Transactional
    public PendingMetaTable getPendingMetaTable(String tableId) {
        PendingMetaTable resultPdMetaTable = (PendingMetaTable)this.pendingMdTableDao.getObjectById(tableId);
        return (PendingMetaTable)this.pendingMdTableDao.fetchObjectReferences((Serializable)resultPdMetaTable);
    }

    @Override
    @Transactional
    public MetaChangLog getMetaChangLog(String changeId) {
        return (MetaChangLog)this.metaChangLogDao.getObjectById(changeId);
    }

    @Override
    @Transactional
    public void savePendingMetaTable(PendingMetaTable pmt) {
        this.pendingMdTableDao.updateObject((Serializable)pmt);
        this.pendingMdTableDao.saveObjectReferences((Serializable)pmt);
    }

    @Override
    @Transactional
    public List<String> makeAlterTableSqlList(String tableId) {
        PendingMetaTable ptable = this.getPendingMetaTable(tableId);
        if (null == ptable || "T".equals(ptable.getTableType()) && null == ptable.getColumns()) {
            return null;
        }
        return this.makeAlterTableSqlList(ptable);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<String> makeAlterTableSqlList(PendingMetaTable pendingMetaTable) {
        ArrayList<String> sqlList;
        MetaTable metaTable = this.metaTableDao.getMetaTable(pendingMetaTable.getDatabaseCode(), pendingMetaTable.getTableName());
        if (metaTable != null) {
            metaTable = this.metaTableDao.fetchObjectReferences(metaTable);
        }
        SourceInfo sourceInfo = this.sourceInfoMetadata.fetchSourceInfo(pendingMetaTable.getDatabaseCode());
        DBType dbType = DBType.mapDBType((String)sourceInfo.getDatabaseUrl());
        pendingMetaTable.setDatabaseType(dbType);
        GeneralDDLOperations ddlOpt = GeneralDDLOperations.createDDLOperations((DBType)dbType);
        if (VIEW.equals(pendingMetaTable.getTableType())) {
            sqlList = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)pendingMetaTable.getViewSql())) {
                sqlList.add(ddlOpt.makeCreateViewSql(pendingMetaTable.getViewSql(), pendingMetaTable.getTableName()));
            }
        } else {
            sqlList = DDLUtils.makeAlterTableSqlList((TableInfo)pendingMetaTable, (TableInfo)metaTable, (DBType)dbType, (DDLOperations)ddlOpt);
        }
        return sqlList;
    }

    public void checkPendingMetaTable(PendingMetaTable ptable, String currentUser) {
        PendingMetaColumn col;
        if ("C".equals(ptable.getTableType()) && (col = ptable.findFieldByName("OBJECT_JSON")) == null) {
            col = new PendingMetaColumn(ptable, "OBJECT_JSON");
            col.setFieldLabelName("\u5bf9\u8c61JSON\u6570\u636e");
            col.setColumnComment("\u5bf9\u8c61JSON\u6570\u636e");
            col.setFieldType("object");
            col.setMaxLength(Integer.valueOf(32000));
            col.setLastModifyDate(DatetimeOpt.currentUtilDate());
            col.setRecorder(currentUser);
            ptable.addMdColumn(col);
        }
        if (("1".equals(ptable.getWorkFlowOptType()) || "2".equals(ptable.getWorkFlowOptType())) && (col = ptable.findFieldByName("flowInstId")) == null) {
            col = new PendingMetaColumn(ptable, "FLOW_INST_ID");
            col.setFieldLabelName("\u6d41\u7a0b\u5b9e\u4f8bID");
            col.setColumnComment("\u4e1a\u52a1\u5bf9\u5e94\u7684\u5de5\u4f5c\u6d41\u7a0b\u5b9e\u4f8bID");
            col.setFieldType("string");
            col.setMaxLength(Integer.valueOf(32));
            col.setLastModifyDate(DatetimeOpt.currentUtilDate());
            col.setRecorder(currentUser);
            ptable.addMdColumn(col);
        }
        if ("2".equals(ptable.getWorkFlowOptType()) && (col = ptable.findFieldByName("nodeInstId")) == null) {
            col = new PendingMetaColumn(ptable, "NODE_INST_ID");
            col.setFieldLabelName("\u8282\u70b9\u5b9e\u4f8bID");
            col.setColumnComment("\u4e1a\u52a1\u5bf9\u5e94\u7684\u5de5\u4f5c\u6d41\u8282\u70b9ID");
            col.setFieldType("string");
            col.setMaxLength(Integer.valueOf(32));
            col.setLastModifyDate(DatetimeOpt.currentUtilDate());
            col.setRecorder(currentUser);
            ptable.addMdColumn(col);
        }
    }

    private List<String> runDdlSql(PendingMetaTable pendingMetaTable, List<String> errors, Connection conn) throws SQLException {
        List<String> sqlList = this.makeAlterTableSqlList(pendingMetaTable);
        for (String sql : sqlList) {
            try {
                DatabaseAccess.doExecuteSql((Connection)conn, (String)sql);
            }
            catch (SQLException se) {
                errors.add(se.getMessage());
                logger.error("\u6267\u884csql\u5931\u8d25:" + sql, (Throwable)se);
            }
        }
        return sqlList;
    }

    private void pendingToMeta(String currentUser, PendingMetaTable ptable) {
        MetaTable metaTable = this.metaTableDao.getMetaTable(ptable.getDatabaseCode(), ptable.getTableName());
        if (metaTable != null) {
            metaTable = this.metaTableDao.getObjectCascadeById((Object)metaTable.getTableId());
            metaTable.setWorkFlowOptType(ptable.getWorkFlowOptType());
            metaTable.setRecorder(currentUser);
            metaTable.setRecordDate(new Date());
            this.metaTableDao.mergeObject(metaTable);
            HashSet setMetaColumn = new HashSet();
            setMetaColumn.addAll(metaTable.getMdColumns());
            HashSet setPendingMetaColumn = new HashSet();
            setPendingMetaColumn.addAll(ptable.getMdColumns());
            for (MetaColumn m : setMetaColumn) {
                for (PendingMetaColumn p : setPendingMetaColumn) {
                    if (!m.getColumnName().equalsIgnoreCase(p.getColumnName())) continue;
                    m.setColumnLength(p.getMaxLength());
                    m.setFieldLabelName(p.getFieldLabelName());
                    m.setColumnOrder(p.getColumnOrder());
                    m.setPrimaryKey(p.getPrimaryKey());
                    m.setFieldType(p.getFieldType());
                    m.setColumnType(FieldType.mapToDatabaseType((String)p.getFieldType(), (DBType)m.getDatabaseType()));
                    m.setScale(p.getScale());
                    m.setMandatory(p.getMandatory());
                    p.setIsCompare(Boolean.valueOf(true));
                    m.setIsCompare(Boolean.valueOf(true));
                }
            }
            for (MetaColumn m : setMetaColumn) {
                if (m.getIsCompare() != null && m.getIsCompare().booleanValue()) {
                    this.metaColumnDao.updateObject(m);
                    continue;
                }
                this.metaColumnDao.deleteObject(m);
            }
            for (PendingMetaColumn p : setPendingMetaColumn) {
                if (p.getIsCompare() != null && p.getIsCompare().booleanValue()) continue;
                MetaColumn tmp = p.mapToMetaColumn();
                tmp.setTableId(metaTable.getTableId());
                this.metaColumnDao.saveNewObject(tmp);
            }
        } else {
            this.metaTableDao.saveNewObject(ptable.mapToMetaTable());
            for (PendingMetaColumn p : ptable.getMdColumns()) {
                this.metaColumnDao.saveNewObject(p.mapToMetaColumn());
            }
        }
    }

    @Override
    @Transactional(readOnly=true)
    public JSONArray listDrafts(String[] fields, Map<String, Object> searchColumn, PageDesc pageDesc) {
        return this.pendingMdTableDao.listObjectsByPropertiesAsJson(searchColumn, pageDesc);
    }

    @Override
    public List<Pair<String, String>> listTablesInPdm(String pdmFilePath) {
        return PdmTableInfoUtils.listTablesInPdm((String)pdmFilePath);
    }

    @Override
    @Transactional
    public boolean importTableFromPdm(String pdmFilePath, String tableCode, String databaseCode) {
        PendingMetaTable metaTable = PdmTableInfoUtils.importTableFromPdm((String)pdmFilePath, (String)tableCode, (String)databaseCode);
        if (metaTable == null) {
            return false;
        }
        this.pendingMdTableDao.saveNewObject((Serializable)metaTable);
        return true;
    }

    @Override
    @Transactional
    public List<MetaColumn> getNotInFormFields(String tableId) {
        String sql = "select * from F_META_COLUMN  t where t.table_id= :tableId and t.column_name not in (select f.column_name from m_model_data_field f join m_meta_form_model m on f.model_code=m.model_code and m.table_id = ?)";
        return this.metaColumnDao.listObjectsBySql(sql, new Object[]{tableId});
    }

    @Override
    public List<MetaColumn> listFields(String tableId) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("tableId", tableId);
        return this.metaColumnDao.listObjectsByProperties(filterMap);
    }

    @Override
    public List<PendingMetaColumn> listMetaColumns(String tableId, PageDesc pageDesc) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("tableId", tableId);
        return this.pendingMetaColumnDao.listObjectsByProperties(filterMap, pageDesc);
    }

    @Override
    public PendingMetaColumn getMetaColumn(String tableId, String columnName) {
        return (PendingMetaColumn)this.pendingMetaColumnDao.getObjectById(new MetaColumn(tableId, columnName));
    }

    @Override
    @Transactional
    public Pair<Integer, String> syncPdm(String databaseCode, String pdmFilePath, List<String> tables, String recorder) {
        try {
            Comparator comparator;
            List pdmTables = PdmTableInfoUtils.importTableFromPdm((String)pdmFilePath, tables);
            if (pdmTables == null) {
                return new ImmutablePair((Object)-1, (Object)"\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25,\u5bfc\u5165\u5931\u8d25\uff01");
            }
            List pendingMetaTables = this.pendingMdTableDao.listObjectsByFilter("where DATABASE_CODE = ?", new Object[]{databaseCode});
            Triple triple = MetaDataServiceImpl.compareMetaBetweenDbTables((List)pendingMetaTables, (List)pdmTables, (Comparator)(comparator = (o1, o2) -> StringUtils.compare((String)o1.getTableName().toUpperCase(), (String)o2.getTableName().toUpperCase())));
            if (triple.getLeft() != null && ((List)triple.getLeft()).size() > 0) {
                for (SimpleTableInfo pdmtable : (List)triple.getLeft()) {
                    PendingMetaTable metaTable = new PendingMetaTable().convertFromPdmTable(pdmtable);
                    metaTable.setDatabaseCode(databaseCode);
                    metaTable.setRecorder(recorder);
                    this.pendingMdTableDao.saveNewObject((Serializable)metaTable);
                    List columns = pdmtable.getColumns();
                    for (SimpleTableField field : columns) {
                        PendingMetaColumn mdColumn = new PendingMetaColumn().convertFromTableField(field);
                        mdColumn.setTableId(metaTable.getTableId());
                        mdColumn.setRecorder(recorder);
                        this.pendingMetaColumnDao.saveNewObject((Serializable)mdColumn);
                    }
                }
            }
            if (triple.getMiddle() != null && ((List)triple.getMiddle()).size() > 0) {
                for (Pair pair : (List)triple.getMiddle()) {
                    PendingMetaTable oldTable = (PendingMetaTable)pair.getLeft();
                    oldTable.setRecorder(recorder);
                    SimpleTableInfo newTable = (SimpleTableInfo)pair.getRight();
                    this.pendingMdTableDao.updateObject((Serializable)oldTable.convertFromPdmTable(newTable));
                    oldTable = (PendingMetaTable)this.pendingMdTableDao.fetchObjectReferences((Serializable)oldTable);
                    List oldColumns = oldTable.getMdColumns();
                    List newColumns = newTable.getColumns();
                    Comparator columnComparator = (o1, o2) -> StringUtils.compare((String)o1.getColumnName().toUpperCase(), (String)o2.getColumnName().toUpperCase());
                    Triple columnCompared = MetaDataServiceImpl.compareMetaBetweenDbTables((List)oldColumns, (List)newColumns, (Comparator)columnComparator);
                    if (columnCompared.getLeft() != null && ((List)columnCompared.getLeft()).size() > 0) {
                        for (SimpleTableField tableField : (List)columnCompared.getLeft()) {
                            PendingMetaColumn metaColumn = new PendingMetaColumn().convertFromTableField(tableField);
                            metaColumn.setTableId(oldTable.getTableId());
                            metaColumn.setRecorder(recorder);
                            this.pendingMetaColumnDao.saveNewObject((Serializable)metaColumn);
                        }
                    }
                    if (columnCompared.getRight() != null && ((List)columnCompared.getRight()).size() > 0) {
                        for (PendingMetaColumn metaColumn : (List)columnCompared.getRight()) {
                            this.pendingMetaColumnDao.deleteObject((Serializable)metaColumn);
                        }
                    }
                    if (columnCompared.getMiddle() == null || ((List)columnCompared.getMiddle()).size() <= 0) continue;
                    for (Pair columnPair : (List)columnCompared.getMiddle()) {
                        PendingMetaColumn oldColumn = (PendingMetaColumn)columnPair.getLeft();
                        oldColumn.setRecorder(recorder);
                        SimpleTableField newColumn = (SimpleTableField)columnPair.getRight();
                        this.pendingMetaColumnDao.updateObject((Serializable)oldColumn.convertFromTableField(newColumn));
                    }
                }
            }
            return new ImmutablePair((Object)0, (Object)"\u5bfc\u5165\u6210\u529f\uff01");
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            logger.error(e.getMessage());
            return new ImmutablePair((Object)-1, (Object)("\u5bfc\u5165\u5931\u8d25!" + e.getMessage()));
        }
    }

    @Override
    @Transactional
    public ResponseData generateTableDDL(String tableId) {
        PendingMetaTable pTable = (PendingMetaTable)this.pendingMdTableDao.getObjectWithReferences(tableId);
        ResponseMapData resp = new ResponseMapData();
        SourceInfo sourceInfo = this.sourceInfoMetadata.fetchSourceInfo(pTable.getDatabaseCode());
        DBType dbType = DBType.mapDBType((String)sourceInfo.getDatabaseUrl());
        pTable.setDatabaseType(dbType);
        GeneralDDLOperations ddlOpt = GeneralDDLOperations.createDDLOperations((DBType)dbType);
        if (VIEW.equals(pTable.getTableType())) {
            resp.addResponseData("ddl", (Object)ddlOpt.makeCreateViewSql(pTable.getViewSql(), pTable.getTableName()));
        } else {
            resp.addResponseData("ddl", (Object)ddlOpt.makeCreateTableSql((TableInfo)pTable, true));
            MetaTable metaTable = this.metaTableDao.getMetaTable(pTable.getDatabaseCode(), pTable.getTableName());
            if (metaTable != null) {
                metaTable = this.metaTableDao.fetchObjectReferences(metaTable);
            }
            List sqlList = DDLUtils.makeAlterTableSqlList((TableInfo)pTable, (TableInfo)metaTable, (DBType)dbType, (DDLOperations)ddlOpt);
            resp.addResponseData("alter", (Object)sqlList);
        }
        return resp;
    }

    @Override
    @Transactional
    public ResponseData publishMetaTable(String tableId, String currentUser) {
        try {
            Pair ret;
            PendingMetaTable pTable = (PendingMetaTable)this.pendingMdTableDao.getObjectById(tableId);
            this.pendingMdTableDao.fetchObjectReferences((Serializable)pTable);
            if (VIEW.equals(pTable.getTableType())) {
                ret = GeneralDDLOperations.checkViewWellDefined((TableInfo)pTable);
                if (StringBaseOpt.isNvl((String)pTable.getViewSql())) {
                    ret = new ImmutablePair((Object)-1, (Object)("\u89c6\u56fe" + pTable.getTableName() + "\u6ca1\u6709\u5b9a\u4e49sql\uff01"));
                }
            } else {
                ret = GeneralDDLOperations.checkTableWellDefined((TableInfo)pTable);
            }
            if ((Integer)ret.getLeft() != 0) {
                return ResponseData.makeErrorMessageWithData((Object)ret.getRight(), (int)((Integer)ret.getLeft()), (String)((String)ret.getRight()));
            }
            MetaChangLog chgLog = new MetaChangLog();
            ArrayList errors = new ArrayList();
            SourceInfo mdb = this.sourceInfoMetadata.fetchSourceInfo(pTable.getDatabaseCode());
            DataSourceDescription dbc = DataSourceDescription.valueOf((IDatabaseInfo)mdb);
            DBType databaseType = DBType.mapDBType((String)mdb.getDatabaseUrl());
            pTable.setDatabaseType(databaseType);
            this.checkPendingMetaTable(pTable, currentUser);
            List sqlList = (List)TransactionHandler.executeInTransaction((DataSourceDescription)dbc, conn -> this.runDdlSql(pTable, errors, conn));
            if (!sqlList.isEmpty()) {
                chgLog.setDatabaseCode(pTable.getDatabaseCode());
                chgLog.setChangeScript(JSON.toJSONString((Object)sqlList));
                chgLog.setChangeComment(JSON.toJSONString(errors));
                chgLog.setTableID(pTable.getTableId());
                chgLog.setChanger(currentUser);
                this.metaChangLogDao.saveNewObject((Serializable)chgLog);
            }
            if (sqlList.isEmpty()) {
                return ResponseData.makeErrorMessageWithData((Object)"\u4fe1\u606f\u672a\u53d8\u66f4\uff0c\u65e0\u9700\u53d1\u5e03", (int)2, (String)"\u4fe1\u606f\u672a\u53d8\u66f4\uff0c\u65e0\u9700\u53d1\u5e03");
            }
            if (errors.isEmpty()) {
                pTable.setRecorder(currentUser);
                pTable.setTableState("S");
                pTable.setLastModifyDate(new Date());
                this.pendingMdTableDao.mergeObject((Serializable)pTable);
                this.pendingMdTableDao.saveObjectReferences((Serializable)pTable);
                if (!sqlList.isEmpty()) {
                    if (VIEW.equals(pTable.getTableType())) {
                        this.metaDataService.syncSingleTable(pTable.getDatabaseCode(), currentUser, pTable.getTableName(), pTable.getTableId());
                    } else {
                        this.pendingToMeta(currentUser, pTable);
                    }
                }
                return ResponseData.makeErrorMessageWithData((Object)chgLog.getChangeId(), (int)0, (String)"\u53d1\u5e03\u6210\u529f!");
            }
            return ResponseData.makeErrorMessageWithData(errors, (int)1, (String)"\u53d1\u5e03\u5931\u8d25!");
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            logger.error(e.getMessage());
            return ResponseData.makeErrorMessageWithData((Object)e.getMessage(), (int)1, (String)("\u53d1\u5e03\u5931\u8d25!" + e.getMessage()));
        }
    }

    @Override
    @Transactional
    public ResponseData batchPublishTables(List<PendingMetaTable> metaTables, String recorder) {
        try {
            List<String> errLogs;
            HashSet<String> databases = new HashSet<String>();
            HashMap<String, ArrayList<String>> success = new HashMap<String, ArrayList<String>>();
            HashMap<String, ArrayList<String>> errors = new HashMap<String, ArrayList<String>>();
            for (PendingMetaTable metaTable : metaTables) {
                metaTable = (PendingMetaTable)this.pendingMdTableDao.fetchObjectReferences((Serializable)metaTable);
                Pair ret = GeneralDDLOperations.checkTableWellDefined((TableInfo)metaTable);
                ArrayList<Object> error = new ArrayList<Object>();
                if ((Integer)ret.getLeft() != 0) {
                    error.add(ret.getRight());
                } else {
                    SourceInfo mdb = this.sourceInfoMetadata.fetchSourceInfo(metaTable.getDatabaseCode());
                    DataSourceDescription dbc = DataSourceDescription.valueOf((IDatabaseInfo)mdb);
                    DBType databaseType = DBType.mapDBType((String)mdb.getDatabaseUrl());
                    metaTable.setDatabaseType(databaseType);
                    this.checkPendingMetaTable(metaTable, recorder);
                    PendingMetaTable finalMetaTable = metaTable;
                    List sqls = (List)TransactionHandler.executeInTransaction((DataSourceDescription)dbc, conn -> this.runDdlSql(finalMetaTable, error, conn));
                    databases.add(metaTable.getDatabaseCode());
                    if (!sqls.isEmpty()) {
                        ArrayList<String> sqlLogs = (ArrayList<String>)success.get(metaTable.getDatabaseCode());
                        if (sqlLogs == null) {
                            sqlLogs = new ArrayList<String>();
                            sqlLogs.add(sqls.toString());
                            success.put(metaTable.getDatabaseCode(), sqlLogs);
                        } else {
                            sqlLogs.add(sqls.toString());
                        }
                    }
                    if (error.isEmpty()) {
                        metaTable.setRecorder(recorder);
                        metaTable.setTableState("S");
                        metaTable.setLastModifyDate(new Date());
                        this.pendingMdTableDao.mergeObject((Serializable)metaTable);
                        this.pendingMdTableDao.saveObjectReferences((Serializable)metaTable);
                        if (!sqls.isEmpty()) {
                            this.pendingToMeta(recorder, metaTable);
                        }
                    }
                }
                if (error.isEmpty()) continue;
                errLogs = (List)errors.get(metaTable.getDatabaseCode());
                if (errLogs == null) {
                    errLogs = new ArrayList<String>();
                    errLogs.add(((Object)error).toString());
                    errors.put(metaTable.getDatabaseCode(), (ArrayList<String>)errLogs);
                    continue;
                }
                errLogs.add(((Object)error).toString());
            }
            for (String dbcode : databases) {
                MetaChangLog chgLog = new MetaChangLog();
                List sqlLogs = (List)success.get(dbcode);
                errLogs = (ArrayList<String>)errors.get(dbcode);
                if (sqlLogs == null && errLogs == null) continue;
                chgLog.setDatabaseCode(dbcode);
                if (sqlLogs != null) {
                    chgLog.setChangeScript(JSON.toJSONString((Object)sqlLogs));
                }
                if (errLogs != null) {
                    chgLog.setChangeComment(JSON.toJSONString((Object)errLogs));
                }
                chgLog.setChanger(recorder);
                this.metaChangLogDao.saveNewObject((Serializable)chgLog);
            }
            if (success.isEmpty() && errors.isEmpty()) {
                return ResponseData.makeErrorMessageWithData((Object)"\u4fe1\u606f\u672a\u53d8\u66f4\uff0c\u65e0\u9700\u6279\u91cf\u53d1\u5e03", (int)2, (String)"\u4fe1\u606f\u672a\u53d8\u66f4\uff0c\u65e0\u9700\u6279\u91cf\u53d1\u5e03");
            }
            if (errors.isEmpty()) {
                return ResponseData.makeErrorMessageWithData(success, (int)0, (String)"\u6279\u91cf\u53d1\u5e03\u5931\u8d25\u6210\u529f\uff01");
            }
            return ResponseData.makeErrorMessageWithData(errors, (int)-1, (String)"\u6279\u91cf\u53d1\u5e03\u5931\u8d25!");
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            logger.error(e.getMessage());
            return ResponseData.makeErrorMessageWithData((Object)e.getMessage(), (int)-1, (String)("\u6279\u91cf\u53d1\u5e03\u5931\u8d25!" + e.getMessage()));
        }
    }

    @Override
    public ResponseData publishDatabase(String databaseCode, String recorder) {
        List metaTables = this.pendingMdTableDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"databaseCode", databaseCode, "tableState", "W"}));
        if (metaTables == null || metaTables.isEmpty()) {
            return ResponseData.makeErrorMessageWithData((Object)"\u6ca1\u6709\u9700\u8981\u53d1\u5e03\u7684\u8868", (int)2, (String)"\u6ca1\u6709\u9700\u8981\u53d1\u5e03\u7684\u8868");
        }
        return this.batchPublishTables(metaTables, recorder);
    }

    @Override
    @Transactional
    public void updateMetaTable(PendingMetaTable metaTable) {
        this.pendingMdTableDao.updateObject((Serializable)metaTable);
    }

    @Override
    @Transactional
    public void updateMetaColumn(PendingMetaColumn metaColumn) {
        this.pendingMetaColumnDao.updateObject((Serializable)metaColumn);
    }

    @Override
    public MetaTable getMetaTableWithReferences(String tableId) {
        return this.metaTableDao.getObjectWithReferences((Object)tableId);
    }

    @Override
    @Transactional
    public List listCombineTablesByProperty(Map<String, Object> parameters, PageDesc pageDesc) {
        String databaseCode = MapUtils.getString(parameters, (Object)"databaseCode");
        String optId = MapUtils.getString(parameters, (Object)"optId");
        String osId = MapUtils.getString(parameters, (Object)"osId");
        String topUnit = MapUtils.getString(parameters, (Object)"topUnit");
        List<Object> mergeTableList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)databaseCode)) {
            mergeTableList = this.listCombineTables(parameters);
        } else if (StringUtils.isNotBlank((CharSequence)optId) || StringUtils.isNotBlank((CharSequence)osId)) {
            JSONArray metaTablesJsonArray = this.metaTableDao.getMetaTableListWithTableOptRelation(parameters);
            JSONArray pendingMetaTableJSONArray = this.pendingMdTableDao.getPendingMetaTableListWithTableOptRelation(parameters);
            mergeTableList = this.mergeTableDataList(JSONArray.parseArray((String)JSON.toJSONString((Object)metaTablesJsonArray), Map.class), JSONArray.parseArray((String)JSON.toJSONString((Object)pendingMetaTableJSONArray), Map.class));
        } else if (StringUtils.isNotBlank((CharSequence)topUnit)) {
            JSONArray metaTablesJsonArray = this.metaTableDao.getMetaTableList(parameters);
            JSONArray pendingMetaTableJSONArray = this.pendingMdTableDao.getPendingMetaTableList(parameters);
            mergeTableList = this.mergeTableDataList(JSONArray.parseArray((String)JSON.toJSONString((Object)metaTablesJsonArray), Map.class), JSONArray.parseArray((String)JSON.toJSONString((Object)pendingMetaTableJSONArray), Map.class));
        }
        pageDesc.setTotalRows(Integer.valueOf(mergeTableList.size()));
        if (CollectionUtils.sizeIsEmpty(mergeTableList)) {
            return Collections.emptyList();
        }
        pageDesc.setTotalRows(Integer.valueOf(mergeTableList.size()));
        this.sortCombineTables(parameters, mergeTableList);
        return this.pagination(mergeTableList, pageDesc.getPageNo(), pageDesc.getPageSize());
    }

    @Override
    public boolean isTableExist(String tableName, String dataBaseCode) {
        return this.pendingMdTableDao.isTableExist(tableName, dataBaseCode) || this.metaTableDao.isTableExist(tableName, dataBaseCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncDb(String databaseCode, String userCode, String[] tableNames) {
        SourceInfo databaseInfo = this.metaDataService.getDatabaseInfo(databaseCode);
        if (databaseInfo != null && !"D".equals(databaseInfo.getSourceType())) {
            throw new ObjectException("\u9009\u62e9\u7684\u8d44\u6e90\u4e0d\u652f\u6301\u53cd\u5411\u5de5\u7a0b\uff01");
        }
        this.metaDataService.syncDb(databaseCode, userCode, tableNames);
        this.deletePendingTableWithColumns(databaseCode, tableNames, userCode);
    }

    @Override
    @Transactional
    public PendingMetaTable initPendingMetaTable(String tableId, String userCode) {
        MetaTable metaTable = this.getMetaTableWithReferences(tableId);
        if (null == metaTable) {
            throw new ObjectException("tableId\u6709\u8bef!");
        }
        PendingMetaTable pendingMetaTable = new PendingMetaTable();
        BeanUtils.copyProperties((Object)metaTable, (Object)pendingMetaTable);
        pendingMetaTable.setRecorder(userCode);
        pendingMetaTable.setTableState("S");
        ArrayList<PendingMetaColumn> mdColumns = new ArrayList<PendingMetaColumn>();
        List metaColumns = metaTable.getColumns();
        for (MetaColumn metaColumn : metaColumns) {
            PendingMetaColumn pendingMetaColumn = new PendingMetaColumn();
            BeanUtils.copyProperties((Object)metaColumn, (Object)pendingMetaColumn);
            mdColumns.add(pendingMetaColumn);
        }
        pendingMetaTable.setMdColumns(mdColumns);
        this.saveNewPendingMetaTable(pendingMetaTable);
        return pendingMetaTable;
    }

    private void deletePendingTableWithColumns(String databaseCode, String[] tableNames, String userCode) {
        List metaTables;
        Map filterMap = CollectionsOpt.createHashMap((Object[])new Object[]{"databaseCode", databaseCode, "tableType_ne", VIEW});
        if (tableNames != null) {
            filterMap.put("tableNames", tableNames);
        }
        if (!CollectionUtils.sizeIsEmpty((Object)(metaTables = this.metaTableDao.listObjectsByProperties(filterMap)))) {
            String[] tableIds = (String[])CollectionsOpt.listToArray((Collection)metaTables.stream().map(MetaTable::getTableId).collect(Collectors.toSet()));
            Map deleteFilterMap = CollectionsOpt.createHashMap((Object[])new Object[]{"tableId_in", tableIds});
            this.pendingMdTableDao.deleteObjectsByProperties(deleteFilterMap);
            this.pendingMetaColumnDao.deleteObjectsByProperties(deleteFilterMap);
            for (String tableId : tableIds) {
                this.initPendingMetaTable(tableId, userCode);
            }
        }
    }

    private List<Map<String, Object>> mergeTableDataList(List<Map> mcMaps, List<Map> pmcMaps) {
        Comparator comparator = (o1, o2) -> StringUtils.compare((String)(MapUtils.getString((Map)o1, (Object)"tableName") + MapUtils.getString((Map)o1, (Object)"databaseCode")).toLowerCase(), (String)(MapUtils.getString((Map)o2, (Object)"tableName") + MapUtils.getString((Map)o2, (Object)"databaseCode")).toLowerCase());
        Triple listTriple = CollectionsOpt.compareTwoList(mcMaps, pmcMaps, (Comparator)comparator);
        List left = (List)listTriple.getLeft();
        List middle = (List)listTriple.getMiddle();
        List right = (List)listTriple.getRight();
        ArrayList<Map<String, Object>> resultMaps = new ArrayList<Map<String, Object>>();
        if (!CollectionUtils.sizeIsEmpty((Object)left)) {
            for (Map map : left) {
                map.put("state", "NEW");
                resultMaps.add(map);
            }
        }
        if (!CollectionUtils.sizeIsEmpty((Object)right)) {
            for (Map map : right) {
                map.put("state", "UNCHANGED");
                resultMaps.add(map);
            }
        }
        if (!CollectionUtils.sizeIsEmpty((Object)middle)) {
            for (Pair pair : middle) {
                Map leftPair = (Map)pair.getLeft();
                Map rightPair = (Map)pair.getRight();
                if ("S".equals(MapUtils.getString((Map)rightPair, (Object)"tableState"))) {
                    leftPair.put("state", "RELEASED");
                } else {
                    leftPair.put("state", "UPDATE");
                }
                resultMaps.add(leftPair);
            }
        }
        return resultMaps;
    }

    private void sortCombineTables(Map<String, Object> filterMap, List<Map<String, Object>> resultMaps) {
        String[] sortKey = new String[]{"tableType", "tableName"};
        Comparator comparator = (a, b) -> {
            for (String sort : sortKey) {
                int cr = GeneralAlgorithm.compareTwoObject(a.get(sort), b.get(sort));
                if (cr == 0) continue;
                return cr;
            }
            return 0;
        };
        resultMaps.sort(comparator);
    }

    private <T> List<T> pagination(List<T> records, int pageNum, int pageSize) {
        if (CollectionUtils.isEmpty(records)) {
            return Collections.emptyList();
        }
        int pageNumCopy = pageNum;
        if (0 == pageNum) {
            pageNumCopy = 1;
        }
        if (pageNumCopy < 0 || pageSize < 0) {
            return Collections.emptyList();
        }
        return records.stream().skip((pageNumCopy - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
    }

    private List<Map<String, Object>> listCombineTables(Map<String, Object> filerMap) {
        List metaTables = this.metaTableDao.listObjectsByProperties(filerMap);
        List pendingMetaTables = this.pendingMdTableDao.listObjectsByProperties(filerMap);
        if (CollectionUtils.sizeIsEmpty((Object)metaTables) && CollectionUtils.sizeIsEmpty((Object)pendingMetaTables)) {
            return Collections.EMPTY_LIST;
        }
        List metaTablesMaps = JSONArray.parseArray((String)JSON.toJSONString((Object)metaTables), Map.class);
        List pendingMetaTablesMaps = JSONArray.parseArray((String)JSON.toJSONString((Object)pendingMetaTables), Map.class);
        return this.mergeTableDataList(metaTablesMaps, pendingMetaTablesMaps);
    }

    @Override
    public JSONArray viewList(String databaseId, String sql) throws SQLException, IOException {
        SourceInfo sourceInfo = this.sourceInfoMetadata.fetchSourceInfo(databaseId);
        try (Connection conn = AbstractDBConnectPools.getDbcpConnect((ISourceInfo)sourceInfo);){
            JSONArray jSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)sql, null, (int)1, (int)10);
            return jSONArray;
        }
    }

    @Override
    @Transactional
    public void importFromTableStore(String databaseCode, JSONObject jsonObject, String userCode) {
        List tableList = TableStoreJsonUtils.fetchTables((JSONObject)jsonObject);
        if (tableList == null || tableList.size() == 0) {
            return;
        }
        HashMap<String, String> tableIdMap = new HashMap<String, String>();
        for (PendingMetaTable table : tableList) {
            PendingMetaTable dbTable = this.pendingMdTableDao.getTableByName(table.getTableName(), databaseCode);
            if (dbTable != null) {
                tableIdMap.put(table.getTableId(), dbTable.getTableId());
                dbTable.setTableType(table.getTableType());
                dbTable.setTableLabelName(table.getTableLabelName());
                dbTable.setTableComment(table.getTableComment());
                dbTable.setViewSql(table.getViewSql());
                dbTable.setTableState("W");
                List columns = table.getMdColumns();
                if (columns != null && columns.size() > 0) {
                    for (PendingMetaColumn col : columns) {
                        col.setTableId(dbTable.getTableId());
                    }
                }
                dbTable.setMdColumns(columns);
                this.pendingMdTableDao.updateObject((Serializable)dbTable);
                this.pendingMdTableDao.saveObjectReference((Serializable)dbTable, "mdColumns");
                continue;
            }
            String newTalbeId = UuidOpt.getUuidAsString22();
            tableIdMap.put(table.getTableId(), newTalbeId);
            table.setDatabaseCode(databaseCode);
            table.setTableState("W");
            table.setRecorder(userCode);
            List columns = table.getMdColumns();
            if (columns != null && columns.size() > 0) {
                for (PendingMetaColumn col : columns) {
                    col.setTableId(newTalbeId);
                }
            }
            this.pendingMdTableDao.saveNewObject((Serializable)table);
            this.pendingMdTableDao.saveObjectReference((Serializable)table, "mdColumns");
        }
    }

    @Override
    @Transactional
    public List<PendingMetaTable> searchPendingMetaTable(JSONObject filter, boolean canUpdateOnly) {
        String filterType = filter.getString("filterType");
        if ("database".equals(filterType)) {
            String databaseCode = filter.getString("databaseCode");
            if (canUpdateOnly) {
                return this.pendingMdTableDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"databaseCode", databaseCode, "tableState", "W"}));
            }
            return this.pendingMdTableDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"databaseCode", databaseCode}));
        }
        if ("opt".equals(filterType)) {
            String optId = filter.getString("optId");
            if (canUpdateOnly) {
                return this.pendingMdTableDao.listObjectsByFilter("where TABLE_STATE = 'W' and TABLE_ID in (select table_id from f_table_opt_relation where OPT_ID = ?)", new Object[]{optId});
            }
            return this.pendingMdTableDao.listObjectsByFilter("where TABLE_ID in (select table_id from f_table_opt_relation where OPT_ID = ?)", new Object[]{optId});
        }
        if ("select".equals(filterType)) {
            List tableIds = filter.getList("tableIds", String.class, new JSONReader.Feature[0]);
            if (canUpdateOnly) {
                return this.pendingMdTableDao.listObjectsByFilter("where TABLE_STATE = 'W' and TABLE_ID in (:tableIds)", CollectionsOpt.createHashMap((Object[])new Object[]{"tableIds", tableIds}));
            }
            return this.pendingMdTableDao.listObjectsByFilter("where TABLE_ID in (:tableIds)", CollectionsOpt.createHashMap((Object[])new Object[]{"tableIds", tableIds}));
        }
        return null;
    }

    @Override
    @Transactional
    public void updatePendingMetaColumn(PendingMetaTable metaTable, PendingMetaColumn metaColumn) {
        this.pendingMdTableDao.fetchObjectReferences((Serializable)metaTable);
        metaColumn.setTableId(metaTable.getTableId());
        PendingMetaColumn dbColumn = metaTable.findFieldByColumn(metaColumn.getColumnName());
        if (dbColumn == null) {
            metaTable.addMdColumn(metaColumn);
            this.pendingMetaColumnDao.saveNewObject((Serializable)metaColumn);
        } else {
            dbColumn.copyNotNullProperty(metaColumn);
            this.pendingMetaColumnDao.updateObject((Serializable)dbColumn);
        }
        List<String> alterSqls = this.makeAlterTableSqlList(metaTable);
        metaTable.setTableState(alterSqls.size() > 0 ? "W" : "S");
        this.pendingMdTableDao.updateObject(CollectionsOpt.createList((Object[])new String[]{"tableState"}), (Serializable)metaTable);
    }

    @Override
    @Transactional
    public void deletePendingMetaColumn(PendingMetaTable metaTable, String columnName) {
        this.pendingMdTableDao.fetchObjectReferences((Serializable)metaTable);
        PendingMetaColumn dbColumn = metaTable.findFieldByColumn(columnName);
        if (dbColumn != null) {
            this.pendingMetaColumnDao.deleteObject((Serializable)dbColumn);
            metaTable.getColumns().remove(dbColumn);
            List<String> alterSqls = this.makeAlterTableSqlList(metaTable);
            metaTable.setTableState(alterSqls.size() > 0 ? "W" : "S");
            this.pendingMdTableDao.updateObject(CollectionsOpt.createList((Object[])new String[]{"tableState"}), (Serializable)metaTable);
        }
    }
}

