/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.dao.json;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.product.metadata.dao.MetaTableDao;
import com.centit.product.metadata.po.MetaColumn;
import com.centit.product.metadata.po.MetaRelDetail;
import com.centit.product.metadata.po.MetaRelation;
import com.centit.product.metadata.po.MetaTable;
import com.centit.support.common.CachedMap;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository(value="metaTableDao")
public class MetaTableDaoImpl
implements MetaTableDao {
    @Value(value="${app.home:./}")
    private String appHome;
    private CachedMap<String, MetaTable> metaTableCache = new CachedMap(tableId -> this.loadMetaTable((String)tableId), 86400L);

    private MetaTable loadMetaTable(String tableId) {
        String tableFile = this.appHome + File.separator + "config" + File.separator + "metadata" + File.separator + tableId + ".json";
        try {
            JSONArray relations;
            JSONObject tableJson = JSON.parseObject((InputStream)new FileInputStream(tableFile), (JSONReader.Feature[])new JSONReader.Feature[0]);
            MetaTable metaTable = (MetaTable)tableJson.toJavaObject(MetaTable.class, new JSONReader.Feature[0]);
            JSONArray columns = tableJson.getJSONArray("columns");
            if (columns != null) {
                List cols = columns.toJavaList(MetaColumn.class, new JSONReader.Feature[0]);
                metaTable.setMdColumns(cols);
            }
            if ((relations = tableJson.getJSONArray("relations")) != null) {
                ArrayList<MetaRelation> rels = new ArrayList<MetaRelation>(relations.size());
                for (Object obj : relations) {
                    if (!(obj instanceof JSONObject)) continue;
                    JSONObject relation = (JSONObject)obj;
                    MetaRelation rel = (MetaRelation)relation.toJavaObject(MetaRelation.class, new JSONReader.Feature[0]);
                    JSONArray details = relation.getJSONArray("details");
                    if (details != null) {
                        rel.setRelationDetails(details.toJavaList(MetaRelDetail.class, new JSONReader.Feature[0]));
                    }
                    rels.add(rel);
                }
                metaTable.setMdRelations(rels);
            }
            return metaTable;
        }
        catch (IOException e) {
            return null;
        }
    }

    public MetaTable getObjectById(Object tableId) {
        return (MetaTable)this.metaTableCache.getCachedValue((Object)((String)tableId));
    }

    public MetaTable getObjectCascadeById(Object tableId) {
        return (MetaTable)this.metaTableCache.getCachedValue((Object)((String)tableId));
    }

    public MetaTable getObjectWithReferences(Object tableId) {
        return (MetaTable)this.metaTableCache.getCachedValue((Object)((String)tableId));
    }

    public void saveNewObject(MetaTable tableInfo) {
        throw new ObjectException(613, "Runtime \u8fd0\u884c\u65f6\u73af\u5883\uff0c\u4e0d\u652f\u6301\u5143\u6570\u636e\u7684\u4fee\u6539!");
    }

    public MetaTable getMetaTable(String databaseCode, String tableName) {
        throw new ObjectException(613, "Runtime \u8fd0\u884c\u65f6\u73af\u5883\uff0c\u4e0d\u652f\u6301\u5143\u6570\u636e\u7684\u4fee\u6539!");
    }

    public JSONArray getMetaTableList(Map<String, Object> parameters) {
        throw new ObjectException(613, "Runtime \u8fd0\u884c\u65f6\u73af\u5883\uff0c\u4e0d\u652f\u6301\u5143\u6570\u636e\u7684\u4fee\u6539!");
    }

    public JSONArray getMetaTableListWithTableOptRelation(Map<String, Object> parameters) {
        throw new ObjectException(613, "Runtime \u8fd0\u884c\u65f6\u73af\u5883\uff0c\u4e0d\u652f\u6301\u5143\u6570\u636e\u7684\u4fee\u6539!");
    }

    public boolean isTableExist(String tableName, String dataBaseCode) {
        throw new ObjectException(613, "Runtime \u8fd0\u884c\u65f6\u73af\u5883\uff0c\u4e0d\u652f\u6301\u5143\u6570\u636e\u7684\u4fee\u6539!");
    }

    public MetaTable fetchObjectReference(MetaTable object, String columnName) {
        return object;
    }

    public MetaTable fetchObjectReferences(MetaTable object) {
        return object;
    }

    public JSONArray listObjectsByPropertiesAsJson(Map<String, Object> filterMap, PageDesc pageDesc) {
        throw new ObjectException(613, "Runtime \u8fd0\u884c\u65f6\u73af\u5883\uff0c\u4e0d\u652f\u6301\u5143\u6570\u636e\u7684\u4fee\u6539!");
    }

    public List<MetaTable> listObjectsByProperties(Map<String, Object> filterMap) {
        throw new ObjectException(613, "Runtime \u8fd0\u884c\u65f6\u73af\u5883\uff0c\u4e0d\u652f\u6301\u5143\u6570\u636e\u7684\u4fee\u6539!");
    }

    public List<MetaTable> listObjectsByFilter(String sqlWhere, Object[] params) {
        throw new ObjectException(613, "Runtime \u8fd0\u884c\u65f6\u73af\u5883\uff0c\u4e0d\u652f\u6301\u5143\u6570\u636e\u7684\u4fee\u6539!");
    }

    public List<MetaTable> listObjectsByFilter(String sqlWhere, Map<String, Object> filterMap) {
        throw new ObjectException(613, "Runtime \u8fd0\u884c\u65f6\u73af\u5883\uff0c\u4e0d\u652f\u6301\u5143\u6570\u636e\u7684\u4fee\u6539!");
    }

    public int deleteObjectReferences(MetaTable object) {
        throw new ObjectException(613, "Runtime \u8fd0\u884c\u65f6\u73af\u5883\uff0c\u4e0d\u652f\u6301\u5143\u6570\u636e\u7684\u4fee\u6539!");
    }

    public int deleteObject(MetaTable object) {
        throw new ObjectException(613, "Runtime \u8fd0\u884c\u65f6\u73af\u5883\uff0c\u4e0d\u652f\u6301\u5143\u6570\u636e\u7684\u4fee\u6539!");
    }

    public int updateObject(MetaTable object) {
        throw new ObjectException(613, "Runtime \u8fd0\u884c\u65f6\u73af\u5883\uff0c\u4e0d\u652f\u6301\u5143\u6570\u636e\u7684\u4fee\u6539!");
    }

    public int mergeObject(MetaTable object) {
        throw new ObjectException(613, "Runtime \u8fd0\u884c\u65f6\u73af\u5883\uff0c\u4e0d\u652f\u6301\u5143\u6570\u636e\u7684\u4fee\u6539!");
    }
}

