/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.dao.json;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONReader;
import com.centit.product.metadata.dao.SourceInfoDao;
import com.centit.product.metadata.po.SourceInfo;
import com.centit.support.common.CachedObject;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository(value="sourceInfoDao")
public class SourceInfoDaoImpl
implements SourceInfoDao {
    @Value(value="${app.home:./}")
    private String appHome;
    public CachedObject<List<SourceInfo>> sourceInfoRepo = new CachedObject(this::loadAllSourceInfo, 86400L);

    private List<SourceInfo> loadAllSourceInfo() {
        String ruleFile = this.appHome + File.separator + "config" + File.separator + "resources.json";
        try {
            JSONArray array = JSON.parseArray((InputStream)new FileInputStream(ruleFile), (JSONReader.Feature[])new JSONReader.Feature[0]);
            return array.toJavaList(SourceInfo.class, new JSONReader.Feature[0]);
        }
        catch (IOException e) {
            return null;
        }
    }

    public List<SourceInfo> listDatabase() {
        return (List)this.sourceInfoRepo.getCachedTarget();
    }

    public List<SourceInfo> listDatabaseByOsId(String osId) {
        return (List)this.sourceInfoRepo.getCachedTarget();
    }

    public SourceInfo getDatabaseInfoById(String databaseCode) {
        List allDatabases = (List)this.sourceInfoRepo.getCachedTarget();
        if (allDatabases != null) {
            for (SourceInfo database : allDatabases) {
                if (!StringUtils.equals((CharSequence)database.getDatabaseCode(), (CharSequence)databaseCode)) continue;
                return database;
            }
        }
        return null;
    }

    public JSONArray queryDatabaseAsJson(String databaseName, PageDesc pageDesc) {
        throw new ObjectException(613, "Runtime \u8fd0\u884c\u65f6\u73af\u5883\uff0c\u4e0d\u652f\u6301\u5143\u6570\u636e\u7684\u4fee\u6539!");
    }

    public int countDataBase(Map<String, Object> params) {
        List allDatabases = (List)this.sourceInfoRepo.getCachedTarget();
        if (allDatabases != null) {
            return allDatabases.size();
        }
        return 0;
    }

    public List<SourceInfo> listObjectsByProperties(Map<String, Object> filterMap) {
        throw new ObjectException(613, "Runtime \u8fd0\u884c\u65f6\u73af\u5883\uff0c\u4e0d\u652f\u6301\u5143\u6570\u636e\u7684\u4fee\u6539!");
    }

    public JSONArray listObjectsByPropertiesAsJson(Map<String, Object> filterMap, PageDesc pageDesc) {
        throw new ObjectException(613, "Runtime \u8fd0\u884c\u65f6\u73af\u5883\uff0c\u4e0d\u652f\u6301\u5143\u6570\u636e\u7684\u4fee\u6539!");
    }

    public void saveNewObject(SourceInfo sourceInfo) {
        throw new ObjectException(613, "Runtime \u8fd0\u884c\u65f6\u73af\u5883\uff0c\u4e0d\u652f\u6301\u5143\u6570\u636e\u7684\u4fee\u6539!");
    }

    public int mergeObject(SourceInfo sourceInfo) {
        throw new ObjectException(613, "Runtime \u8fd0\u884c\u65f6\u73af\u5883\uff0c\u4e0d\u652f\u6301\u5143\u6570\u636e\u7684\u4fee\u6539!");
    }

    public int deleteObjectById(Object id) {
        throw new ObjectException(613, "Runtime \u8fd0\u884c\u65f6\u73af\u5883\uff0c\u4e0d\u652f\u6301\u5143\u6570\u636e\u7684\u4fee\u6539!");
    }

    public List<SourceInfo> listObjects() {
        return (List)this.sourceInfoRepo.getCachedTarget();
    }

    public JSONArray listRelativeOsInfo(String databaseId) {
        return null;
    }
}

