/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.dao.rmdb;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.product.metadata.dao.SourceInfoDao;
import com.centit.product.metadata.po.SourceInfo;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryAndParams;
import com.centit.support.database.utils.QueryUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository(value="sourceInfoDao")
public class SourceInfoDaoImpl
extends BaseDaoImpl<SourceInfo, String>
implements SourceInfoDao {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("databaseName", "LIKE");
        filterField.put("databaseCode", "EQUAL");
        filterField.put("osId", "database_code in (select database_id from m_application_resources where os_id=:osId)");
        filterField.put("databaseType", "LIKE");
        filterField.put("hostPort", "LIKE");
        filterField.put("databaseUrl", "LIKE");
        filterField.put("username", "LIKE");
        filterField.put("password", "LIKE");
        filterField.put("dataDesc", "LIKE");
        filterField.put("createTime", "LIKE");
        filterField.put("created", "LIKE");
        filterField.put("sourceType", "EQUAL");
        filterField.put("topUnit", "EQUAL");
        filterField.put("databaseCodes", "Database_Code in (:databaseCodes)");
        return filterField;
    }

    public List<SourceInfo> listDatabase() {
        return this.listObjects();
    }

    public List<SourceInfo> listDatabaseByOsId(String osId) {
        return super.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"osId", osId}));
    }

    public SourceInfo getDatabaseInfoById(String databaseCode) {
        return (SourceInfo)this.getObjectById(databaseCode);
    }

    public JSONArray queryDatabaseAsJson(String databaseName, PageDesc pageDesc) {
        if (StringUtils.isBlank((CharSequence)databaseName)) {
            return super.listObjectsByPropertiesAsJson(new HashMap(1), pageDesc);
        }
        String matchStr = QueryUtils.getMatchString((String)databaseName);
        return super.listObjectsByFilterAsJson("where DATABASE_NAME like ? or DATABASE_URL like ?", new Object[]{matchStr, matchStr}, pageDesc);
    }

    public int countDataBase(Map<String, Object> params) {
        String sql = "  SELECT COUNT(1) COUNT FROM F_DATABASE_INFO WHERE 1 = 1 [ :topUnit | AND TOP_UNIT = :topUnit ]  [ :sourceType |  AND SOURCE_TYPE  = :sourceType ]  ";
        QueryAndParams queryAndParams = QueryAndParams.createFromQueryAndNamedParams((QueryAndNamedParams)QueryUtils.translateQuery((String)sql, params));
        return NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)queryAndParams.getQuery(), (Object[])queryAndParams.getParams()));
    }

    public JSONArray listRelativeOsInfo(String databaseId) {
        String sqlSen = "select a.OS_ID, a.OS_NAME from m_application_resources b join F_OS_INFO a on (b.os_id = a.os_id) where b.database_id = ?";
        return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this, (String)sqlSen, (Object[])new Object[]{databaseId});
    }
}

