/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.controller;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.product.metadata.po.DataCheckRule;
import com.centit.product.metadata.service.DataCheckRuleService;
import com.centit.product.metadata.utils.DataCheckResult;
import com.centit.support.common.ObjectException;
import com.centit.support.compiler.ObjectTranslate;
import com.centit.support.compiler.VariableFormula;
import com.centit.support.compiler.VariableTranslate;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u6570\u636e\u6821\u9a8c\u89c4\u5219\u7ef4\u62a4\u63a5\u53e3", tags={"\u6570\u636e\u6821\u9a8c\u89c4\u5219\u7ef4\u62a4\u63a5\u53e3"})
@RestController
@RequestMapping(value={"dataCheckRule"})
public class DataCheckRuleController
extends BaseController {
    @Autowired
    private DataCheckRuleService dataCheckRuleService;
    private String optId = "DATACHECKRULE";

    @ApiOperation(value="\u6240\u6709\u6570\u636e\u6821\u9a8c\u89c4\u5219\u4fe1\u606f", notes="\u6240\u6709\u6570\u636e\u6821\u9a8c\u89c4\u5219\u4fe1\u606f")
    @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\uff0c\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)
    @RequestMapping(method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<Object> list(PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            searchColumn.put("topUnit", "system");
        }
        String[] strArry = new String[]{topUnit, "system"};
        searchColumn.put("topUnit", strArry);
        JSONArray listObjects = this.dataCheckRuleService.listObjectsByPropertiesAsJson(searchColumn, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)listObjects, (PageDesc)pageDesc, (Class[])new Class[]{DataCheckRule.class});
    }

    @ApiOperation(value="\u5f53\u524d\u79df\u6237\u7684\u6570\u636e\u6821\u9a8c\u89c4\u5219\u4fe1\u606f", notes="\u5f53\u524d\u79df\u6237\u7684\u6570\u636e\u6821\u9a8c\u89c4\u5219\u4fe1\u606f")
    @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\uff0c\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)
    @RequestMapping(value={"/listByTopUnit"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<Object> listByTopUnit(PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            throw new ObjectException(500, "topUnit\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        searchColumn.put("topUnit", topUnit);
        JSONArray listObjects = this.dataCheckRuleService.listObjectsByPropertiesAsJson(searchColumn, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)listObjects, (PageDesc)pageDesc, (Class[])new Class[]{DataCheckRule.class});
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u6821\u9a8c\u89c4\u5219\u4fe1\u606f", notes="\u65b0\u589e\u6570\u636e\u6821\u9a8c\u89c4\u5219\u4fe1\u606f")
    @ApiImplicitParam(name="dataCheckRule", value="json\u683c\u5f0f\uff0c\u6570\u636e\u6821\u9a8c\u89c4\u5219\u4fe1\u606f", required=true, paramType="body", dataTypeClass=DataCheckRule.class)
    @RequestMapping(method={RequestMethod.POST})
    public void saveDataCheckRule(@RequestBody DataCheckRule dataCheckRule, HttpServletRequest request, HttpServletResponse response) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)dataCheckRule.getTopUnit())) {
            if (StringUtils.isBlank((CharSequence)topUnit)) {
                dataCheckRule.setTopUnit("system");
            }
            dataCheckRule.setTopUnit(topUnit);
        }
        this.dataCheckRuleService.saveNewObject(dataCheckRule);
        JsonResultUtils.writeSingleDataJson((Object)dataCheckRule.getRuleId(), (HttpServletResponse)response);
        OperationLogCenter.logNewObject((HttpServletRequest)request, (String)this.optId, (String)dataCheckRule.getRuleId(), (String)"create", (String)"\u65b0\u589e\u6570\u636e\u6821\u9a8c\u89c4\u5219", (Object)dataCheckRule);
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e\u6821\u9a8c\u89c4\u5219\u4fe1\u606f", notes="\u4fee\u6539\u6570\u636e\u6821\u9a8c\u89c4\u5219\u4fe1\u606f\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ruleId", value="\u6570\u636e\u6821\u9a8c\u89c4\u5219\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="dataCheckRule", value="json\u683c\u5f0f\uff0c\u6570\u636e\u5e93\u5bf9\u8c61\u4fe1\u606f", required=true, paramType="body", dataTypeClass=DataCheckRule.class)})
    @RequestMapping(value={"/{ruleId}"}, method={RequestMethod.PUT})
    public void updateDataCheckRule(@PathVariable String ruleId, @RequestBody DataCheckRule dataCheckRule, HttpServletRequest request, HttpServletResponse response) {
        DataCheckRule temp = this.dataCheckRuleService.getObjectById(ruleId);
        DataCheckRule oldValue = new DataCheckRule();
        BeanUtils.copyProperties((Object)temp, (Object)oldValue);
        this.dataCheckRuleService.updateObject(dataCheckRule);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logUpdateObject((HttpServletRequest)request, (String)this.optId, (String)ruleId, (String)"update", (String)"\u4fee\u6539\u6570\u636e\u6821\u9a8c\u89c4\u5219\u4fe1\u606f", (Object)dataCheckRule, (Object)oldValue);
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u4e2a\u6570\u636e\u6821\u9a8c\u89c4\u5219", notes="\u83b7\u53d6\u5355\u4e2a\u6570\u636e\u6821\u9a8c\u89c4\u5219\u3002")
    @ApiImplicitParam(name="ruleId", value="\u6570\u636e\u6821\u9a8c\u89c4\u5219\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{ruleId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public DataCheckRule getDataCheckRule(@PathVariable String ruleId, HttpServletResponse response) {
        return this.dataCheckRuleService.getObjectById(ruleId);
    }

    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u6570\u636e\u6821\u9a8c\u89c4\u5219", notes="\u5220\u9664\u5355\u4e2a\u6570\u636e\u6821\u9a8c\u89c4\u5219\u3002")
    @ApiImplicitParam(name="ruleId", value="\u6570\u636e\u6821\u9a8c\u89c4\u5219\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{ruleId}"}, method={RequestMethod.DELETE})
    public void deleteDataCheckRule(@PathVariable String ruleId, HttpServletRequest request, HttpServletResponse response) {
        DataCheckRule dataChdeckRule = this.dataCheckRuleService.getObjectById(ruleId);
        this.dataCheckRuleService.deleteObjectById(ruleId);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
        OperationLogCenter.logDeleteObject((HttpServletRequest)request, (String)this.optId, (String)ruleId, (String)"delete", (String)"\u5220\u9664\u6570\u636e\u6821\u9a8c\u89c4\u5219", (Object)dataChdeckRule);
    }

    @PostMapping(value={"/testformula"})
    @ApiOperation(value="\u6d4b\u8bd5\u8868\u8fbe\u5f0f")
    @WrapUpResponseBody
    public Object testFormula(@RequestBody JSONObject jsonObject) {
        VariableFormula variableFormula = new VariableFormula();
        variableFormula.setExtendFuncMap(DataCheckResult.extraFunc);
        variableFormula.setTrans((VariableTranslate)new ObjectTranslate(jsonObject.containsKey("jsonString") ? jsonObject.get("jsonString") : ""));
        variableFormula.setFormula(jsonObject.containsKey("formula") ? jsonObject.getString("formula") : "");
        return variableFormula.calcFormula();
    }
}

