/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.transaction;

import com.centit.product.metadata.api.ISourceInfo;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRedisConnectPools {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRedisConnectPools.class);
    private static final Map<ISourceInfo, RedisClient> REDIS_CLIENT_POOLS = new ConcurrentHashMap<ISourceInfo, RedisClient>();

    private AbstractRedisConnectPools() {
        throw new IllegalAccessError("Utility class");
    }

    private static RedisClient createRedisClient(ISourceInfo dsDesc) {
        RedisURI uri = RedisURI.create((String)dsDesc.getDatabaseUrl());
        uri.setUsername(dsDesc.getUsername());
        uri.setPassword(dsDesc.getClearPassword());
        return RedisClient.create((RedisURI)uri);
    }

    static synchronized StatefulRedisConnection<String, String> getRedisConnect(ISourceInfo dsDesc) {
        RedisClient redisClient = REDIS_CLIENT_POOLS.get(dsDesc);
        if (redisClient == null) {
            redisClient = AbstractRedisConnectPools.createRedisClient(dsDesc);
            REDIS_CLIENT_POOLS.put(dsDesc, redisClient);
        }
        StatefulRedisConnection connection = redisClient.connect();
        return connection;
    }

    static void closeConnect(StatefulRedisConnection<String, String> connection) {
        if (connection != null) {
            connection.close();
        }
    }
}

