/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.transaction;

import com.centit.product.metadata.api.ISourceInfo;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.network.HttpExecutor;
import com.centit.support.network.HttpExecutorContext;
import java.io.IOException;
import java.util.Map;
import org.apache.http.client.CookieStore;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpContextCreator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHttpContextCreator.class);

    private AbstractHttpContextCreator() {
        throw new IllegalAccessError("Utility class");
    }

    private static void loginOpt(ISourceInfo dsDesc, HttpClientContext context, CloseableHttpClient httpClient) throws IOException {
        if (dsDesc.getExtProps() != null && dsDesc.getExtProps().get("loginUrl") != null) {
            HttpExecutor.formPost((HttpExecutorContext)HttpExecutorContext.create((CloseableHttpClient)httpClient).context((HttpContext)context), (String)((String)dsDesc.getExtProps().get("loginUrl")), (Object)dsDesc.getExtProps(), (boolean)false);
        }
    }

    static synchronized HttpExecutorContext createHttpConnect(ISourceInfo dsDesc) throws Exception {
        Map extProps = dsDesc.getExtProps();
        if (extProps.containsKey("SSL") && BooleanBaseOpt.castObjectToBoolean(extProps.get("SSL")).booleanValue()) {
            CloseableHttpClient keepSessionHttpsClient = HttpExecutor.createKeepSessionHttpsClient();
            return HttpExecutorContext.create((CloseableHttpClient)keepSessionHttpsClient);
        }
        HttpClientContext context = HttpClientContext.create();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        int maxTotal = NumberBaseOpt.castObjectToInteger(dsDesc.getExtProps().get("maxTotal"), (Integer)200);
        int maxPerRoute = NumberBaseOpt.castObjectToInteger(dsDesc.getExtProps().get("maxPerRoute"), (Integer)20);
        connectionManager.setMaxTotal(maxTotal);
        connectionManager.setDefaultMaxPerRoute(maxPerRoute);
        BasicCookieStore cookieStore = new BasicCookieStore();
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultCookieStore((CookieStore)cookieStore).build();
        AbstractHttpContextCreator.loginOpt(dsDesc, context, httpClient);
        context.setCookieStore((CookieStore)cookieStore);
        String connection = StringBaseOpt.castObjectToString(dsDesc.getExtProps().get("connection"), (String)"close");
        int timeout = NumberBaseOpt.castObjectToInteger(dsDesc.getExtProps().get("timeout"), (Integer)10000);
        return HttpExecutorContext.create((CloseableHttpClient)httpClient).context((HttpContext)context).header("Connection", connection).timout(timeout);
    }
}

