/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.utils;

import com.centit.product.metadata.po.PendingMetaColumn;
import com.centit.product.metadata.po.PendingMetaTable;
import com.centit.support.database.metadata.PdmReader;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public abstract class PdmTableInfoUtils {
    public static List<Pair<String, String>> listTablesInPdm(String pdmFilePath) {
        PdmReader pdmReader = new PdmReader();
        if (!pdmReader.loadPdmFile(pdmFilePath)) {
            return null;
        }
        return pdmReader.getAllTableCode();
    }

    public static PendingMetaTable importTableFromPdm(String pdmFilePath, String tableCode, String databaseCode) {
        PdmReader pdmReader = new PdmReader();
        if (!pdmReader.loadPdmFile(pdmFilePath)) {
            return null;
        }
        SimpleTableInfo pdmTable = pdmReader.getTableMetadata(tableCode);
        if (pdmTable == null) {
            return null;
        }
        PendingMetaTable metaTable = new PendingMetaTable();
        metaTable.setDatabaseCode(databaseCode);
        metaTable.setTableName(pdmTable.getTableName());
        metaTable.setTableLabelName(pdmTable.getTableLabelName());
        metaTable.setTableState("N");
        metaTable.setTableComment(pdmTable.getTableComment());
        for (SimpleTableField field : pdmTable.getColumns()) {
            PendingMetaColumn mdColumn = new PendingMetaColumn();
            mdColumn.setColumnName(field.getColumnName());
            mdColumn.setFieldType(field.getColumnType());
            mdColumn.setColumnComment(field.getColumnComment());
            mdColumn.setMaxLength(field.getMaxLength());
            mdColumn.setScale(field.getScale());
            mdColumn.setMandatory(Boolean.valueOf(field.isMandatory()));
            mdColumn.setPrimaryKey(Boolean.valueOf(field.isPrimaryKey()));
            metaTable.addMdColumn(mdColumn);
        }
        return metaTable;
    }

    public static List<SimpleTableInfo> getTableNameFromPdm(String pdmFilePath) {
        PdmReader pdmReader = new PdmReader();
        if (!pdmReader.loadPdmFile(pdmFilePath)) {
            return null;
        }
        ArrayList<SimpleTableInfo> pdmTables = new ArrayList<SimpleTableInfo>();
        List tabNames = pdmReader.getAllTableCode();
        for (Pair tabName : tabNames) {
            SimpleTableInfo pdmTable = new SimpleTableInfo();
            pdmTable.setTableName((String)tabName.getKey());
            pdmTable.setTableLabelName((String)tabName.getValue());
            pdmTables.add(pdmTable);
        }
        return pdmTables;
    }

    public static List<SimpleTableInfo> importTableFromPdm(String pdmFilePath) {
        PdmReader pdmReader = new PdmReader();
        if (!pdmReader.loadPdmFile(pdmFilePath)) {
            return null;
        }
        ArrayList<SimpleTableInfo> pdmTables = new ArrayList<SimpleTableInfo>();
        List tabNames = pdmReader.getAllTableCode();
        for (Pair tabName : tabNames) {
            SimpleTableInfo pdmTable = pdmReader.getTableMetadata((String)tabName.getKey());
            if (pdmTable == null) continue;
            pdmTables.add(pdmTable);
        }
        return pdmTables;
    }

    public static List<SimpleTableInfo> importTableFromPdm(String pdmFilePath, List<String> tables) {
        PdmReader pdmReader = new PdmReader();
        if (!pdmReader.loadPdmFile(pdmFilePath)) {
            return null;
        }
        ArrayList<SimpleTableInfo> pdmTables = new ArrayList<SimpleTableInfo>();
        for (String table : tables) {
            SimpleTableInfo pdmTable = pdmReader.getTableMetadata(table);
            if (pdmTable != null) continue;
            pdmTables.add(pdmTable);
        }
        return pdmTables;
    }
}

