/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.controller;

import com.centit.fileserver.common.FileLibraryInfo;
import com.centit.fileserver.common.OperateFileLibrary;
import com.centit.fileserver.service.FileLibraryInfoManager;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.basedata.UnitInfo;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.support.image.ImageOpt;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.awt.Color;
import java.awt.Image;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"library"})
@Api(value="FILE_LIBRARY_INFO", tags={"\u6587\u4ef6\u5e93\u4fe1\u606f"})
public class FileLibraryInfoController
extends BaseController {
    private final FileLibraryInfoManager fileLibraryInfoMag;
    @Autowired
    private OperateFileLibrary operateFileLibrary;

    public FileLibraryInfoController(FileLibraryInfoManager fileLibraryInfoMag) {
        this.fileLibraryInfoMag = fileLibraryInfoMag;
    }

    @RequestMapping(method={RequestMethod.GET})
    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u62e5\u6709\u6587\u4ef6\u5e93\u5217\u8868")
    @WrapUpResponseBody
    public PageQueryResult<FileLibraryInfo> list(HttpServletRequest request) {
        String userCode = this.getUserCode(request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            return null;
        }
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        String libraryType = request.getParameter("libraryType");
        List<FileLibraryInfo> fileLibraryInfos = this.fileLibraryInfoMag.listFileLibrary(topUnit, userCode, libraryType);
        return PageQueryResult.createResult(fileLibraryInfos, null);
    }

    @RequestMapping(value={"/{libraryId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u6587\u4ef6\u5e93\u4fe1\u606f")
    @WrapUpResponseBody
    public Object getFileLibraryInfo(@PathVariable String libraryId, HttpServletRequest request) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isEmpty((CharSequence)topUnit)) {
            topUnit = request.getParameter("topUnit");
        }
        return DictionaryMapUtils.objectToJSONCascade((Object)this.fileLibraryInfoMag.getFileLibrary(topUnit, libraryId));
    }

    @RequestMapping(value={"/unitpath"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u67e5\u8be2\u673a\u6784\u5168\u8def\u5f84")
    @WrapUpResponseBody
    public List<UnitInfo> listUnitPathsByUserCode(HttpServletRequest request) {
        String userCode = this.getUserCode(request);
        if (userCode == null) {
            return null;
        }
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        return this.fileLibraryInfoMag.listUnitPathsByUserCode(topUnit, userCode);
    }

    @RequestMapping(value={"/libraryimage/{name}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6839\u636e\u5e93\u540d\u83b7\u53d6\u56fe\u7247")
    @WrapUpResponseBody(contentType=WrapUpContentType.IMAGE)
    public Image getImage(@PathVariable String name, Integer size, Integer red, Integer green, Integer blue, Boolean border) {
        if (size == null) {
            size = 20;
        }
        if (red == null || green == null || blue == null) {
            red = 167;
            green = 214;
            blue = 211;
        }
        if (border == null) {
            border = true;
        }
        return ImageOpt.createNameIcon((String)name, (int)size, (Color)new Color(red, green, blue), (boolean)border);
    }

    @RequestMapping(value={"/initpersonlib"}, method={RequestMethod.POST})
    @ApiOperation(value="\u521d\u59cb\u5316\u4e2a\u4eba\u6587\u4ef6\u5e93")
    @WrapUpResponseBody
    public void initPersonLibrary(HttpServletRequest request) {
        UserInfo userInfo = WebOptUtils.assertUserLogin((HttpServletRequest)request);
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        this.fileLibraryInfoMag.initPersonLibrary(topUnit, userInfo.getUserCode());
    }

    @RequestMapping(value={"/initunitlib/{unitCode}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u521d\u59cb\u5316\u673a\u6784\u5e93")
    @WrapUpResponseBody
    public void initUnitLibrary(@PathVariable String unitCode, HttpServletRequest request) {
        UserInfo userInfo = WebOptUtils.assertUserLogin((HttpServletRequest)request);
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        this.fileLibraryInfoMag.initUnitLibrary(topUnit, unitCode, userInfo.getUserCode());
    }

    @RequestMapping(method={RequestMethod.POST})
    @ApiOperation(value="\u65b0\u589e\u6587\u4ef6\u5e93\u4fe1\u606f")
    @WrapUpResponseBody
    public void createFileLibraryInfo(@RequestBody FileLibraryInfo fileLibraryInfo, HttpServletRequest request, HttpServletResponse response) {
        UserInfo userInfo = WebOptUtils.assertUserLogin((HttpServletRequest)request);
        fileLibraryInfo.setCreateUser(userInfo.getUserCode());
        if (StringUtils.isBlank((CharSequence)fileLibraryInfo.getOwnUnit())) {
            fileLibraryInfo.setOwnUnit(WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        }
        this.fileLibraryInfoMag.createFileLibrary(fileLibraryInfo);
        JsonResultUtils.writeSingleDataJson((Object)fileLibraryInfo, (HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/addlibrary"})
    @ApiOperation(value="\u901a\u8fc7\u65b0\u589e\u6587\u4ef6\u5e93\u4fe1\u606f")
    @WrapUpResponseBody
    public FileLibraryInfo mergeFileLibraryInfo(@RequestBody FileLibraryInfo fileLibrary) {
        return this.operateFileLibrary.insertFileLibrary(fileLibrary);
    }

    @RequestMapping(value={"/{libraryId}"}, method={RequestMethod.DELETE})
    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u6587\u4ef6\u5e93\u4fe1\u606f")
    @WrapUpResponseBody
    public void deleteFileLibraryInfo(@PathVariable String libraryId) {
        this.fileLibraryInfoMag.deleteFileLibrary(libraryId);
    }

    @RequestMapping(method={RequestMethod.PUT})
    @ApiOperation(value="\u66f4\u65b0\u6587\u4ef6\u5e93\u4fe1\u606f")
    @WrapUpResponseBody
    public void updateFileLibraryInfo(@RequestBody FileLibraryInfo fileLibraryInfo, HttpServletRequest request, HttpServletResponse response) {
        fileLibraryInfo.setUpdateUser(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        this.fileLibraryInfoMag.updateFileLibrary(fileLibraryInfo);
        JsonResultUtils.writeSingleDataJson((Object)fileLibraryInfo, (HttpServletResponse)response);
    }

    private String getUserCode(HttpServletRequest request) {
        String userCode = request.getParameter("userCode");
        if (StringUtils.isBlank((CharSequence)userCode) || "undefined".equals(userCode)) {
            userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        }
        if (StringUtils.isBlank((CharSequence)userCode)) {
            return null;
        }
        return userCode;
    }
}

