/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.controller;

import com.centit.fileserver.common.FileLibraryInfo;
import com.centit.fileserver.service.FileLibraryInfoManager;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.model.adapter.OperationLogWriter;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/log"})
@Api(value="\u6587\u4ef6\u65e5\u5fd7", tags={"\u6587\u4ef6\u65e5\u5fd7"})
public class FileLogController
extends BaseController {
    public static final String LOG_OPERATION_NAME = "FileServerLog";
    private final OperationLogWriter optLogManager;
    @Autowired
    private FileLibraryInfoManager fileLibraryInfoManager;

    public FileLogController(OperationLogWriter optLogManager) {
        this.optLogManager = optLogManager;
    }

    @ApiOperation(value="\u67e5\u8be2\u6587\u4ef6\u65e5\u5fd7\u5217\u8868", notes="request\u53c2\u6570\uff1aoptTag(\u6587\u4ef6id),userCode(\u64cd\u4f5c\u4eba\u5458)")
    @GetMapping
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public List<? extends OperationLog> listFileLog(PageDesc pageDesc, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            userCode = request.getParameter("userCode");
        }
        if (StringUtils.isBlank((CharSequence)userCode)) {
            return null;
        }
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        List<FileLibraryInfo> fileLibraryInfos = this.fileLibraryInfoManager.listFileLibrary(topUnit, userCode, "I");
        if (fileLibraryInfos != null) {
            String[] units = new String[fileLibraryInfos.size()];
            for (int i = 0; i < fileLibraryInfos.size(); ++i) {
                units[i] = fileLibraryInfos.get(i).getLibraryId();
            }
            searchColumn.put("unitCode_in", units);
        }
        return this.optLogManager.listOptLog(LOG_OPERATION_NAME, searchColumn, pageDesc.getPageNo(), pageDesc.getPageSize());
    }
}

