/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.task;

import com.centit.fileserver.common.FileBaseInfo;
import com.centit.fileserver.common.FileTaskInfo;
import com.centit.fileserver.common.FileTaskOpeator;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.pretreat.FilePretreatUtils;
import com.centit.fileserver.service.FileInfoManager;
import com.centit.fileserver.task.FileStoreOpt;
import com.centit.fileserver.utils.SystemTempFileUtils;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.file.FileSystemOpt;
import com.centit.support.security.SecurityOptUtils;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class EncryptFileOpt
extends FileStoreOpt
implements FileTaskOpeator {
    private static final Logger logger = LoggerFactory.getLogger(EncryptFileOpt.class);
    @Autowired
    private FileInfoManager fileInfoManager;

    public String getOpeatorName() {
        return "encrypt";
    }

    public FileTaskInfo attachTaskInfo(FileInfo fileInfo, long fileSize, Map<String, Object> pretreatInfo) {
        String password = SecurityOptUtils.decodeSecurityString((String)StringBaseOpt.castObjectToString((Object)pretreatInfo.get("password")));
        String encryptType = StringBaseOpt.castObjectToString((Object)pretreatInfo.get("encryptType"));
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)encryptType, (CharSequence[])new CharSequence[]{"A", "S", "M", "G"})) {
            FileTaskInfo taskInfo = new FileTaskInfo(this.getOpeatorName());
            taskInfo.copy((FileBaseInfo)fileInfo);
            taskInfo.setFileSize(Long.valueOf(fileSize));
            taskInfo.putOptParam("password", (Object)password);
            taskInfo.putOptParam("encryptType", (Object)encryptType);
            return taskInfo;
        }
        return null;
    }

    private void doEncryptFile(FileInfo fileInfo, long fileSize, String encryptType, String encryptPass) {
        String originalTempFilePath = SystemTempFileUtils.getTempFilePath((String)fileInfo.getFileMd5(), (long)fileSize);
        String aesEncryptedFile = FilePretreatUtils.encryptFile(fileInfo, originalTempFilePath, encryptType, encryptPass);
        this.save(aesEncryptedFile, fileInfo, new File(aesEncryptedFile).length());
        this.fileInfoManager.updateObject((Serializable)fileInfo);
        FileSystemOpt.deleteFile((String)originalTempFilePath);
    }

    public int runTaskInfo(FileInfo fileInfo, long fileSize, Map<String, Object> pretreatInfo) {
        String password = SecurityOptUtils.decodeSecurityString((String)StringBaseOpt.castObjectToString((Object)pretreatInfo.get("password")));
        String encryptType = StringBaseOpt.castObjectToString((Object)pretreatInfo.get("encryptType"));
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)encryptType, (CharSequence[])new CharSequence[]{"A", "S", "M", "G"})) {
            this.doEncryptFile(fileInfo, fileSize, encryptType, password);
            return 1;
        }
        return 0;
    }

    public void doFileTask(FileTaskInfo fileOptTaskInfo) {
        String fileId = fileOptTaskInfo.getFileId();
        long fileSize = fileOptTaskInfo.getFileSize();
        String encryptPass = (String)fileOptTaskInfo.getOptParam("password");
        String encryptType = (String)fileOptTaskInfo.getOptParam("encryptType");
        FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
        if (fileInfo == null) {
            return;
        }
        this.doEncryptFile(fileInfo, fileSize, encryptType, encryptPass);
    }
}

