/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.task;

import com.centit.fileserver.common.FileBaseInfo;
import com.centit.fileserver.common.FileStore;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.po.FileStoreInfo;
import com.centit.fileserver.service.FileStoreInfoManager;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileSystemOpt;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class FileStoreOpt {
    private static final Logger logger = LoggerFactory.getLogger(FileStoreOpt.class);
    @Autowired
    protected FileStoreInfoManager fileStoreInfoManager;
    @Autowired
    protected FileStore fileStore;

    private String fetchOrSaveFile(String tempFilePath, FileInfo file, long fileSize) throws IOException {
        String fileStoreUrl = this.fileStore.matchFileStoreUrl((FileBaseInfo)file, fileSize);
        if (this.fileStore.checkFile(fileStoreUrl)) {
            return fileStoreUrl;
        }
        fileStoreUrl = this.fileStore.saveFile(tempFilePath, (FileBaseInfo)file, fileSize);
        FileSystemOpt.deleteFile((String)tempFilePath);
        return fileStoreUrl;
    }

    private void transTempFileToStore(FileStoreInfo fileStoreInfo) {
        try {
            FileInfo fileInfo = new FileInfo();
            fileInfo.setFileMd5(fileStoreInfo.getFileMd5());
            fileInfo.setFileSize(fileStoreInfo.getFileSize().longValue());
            String fileStoreUrl = this.fetchOrSaveFile(fileStoreInfo.getFileStorePath(), fileInfo, fileStoreInfo.getFileSize());
            fileStoreInfo.setFileStorePath(fileStoreUrl);
            fileStoreInfo.setIsTemp("F");
            this.fileStoreInfoManager.updateObject(fileStoreInfo);
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u8f6c\u5b58\u5931\u8d25", (Throwable)e);
            OperationLogCenter.log((OperationLog)OperationLog.create().operation("FileServerLog").user("system").unit("platform").topUnit("system").level("1").correlation("transTempFileToStore").method("\u6587\u4ef6\u8f6c\u50a8").tag("fixbug").content("\u6587\u4ef6\u8f6c\u5b58\u5931\u8d25,\u4e34\u65f6\u6587\u4ef6\u8fc7\u671f\u5bfc\u81f4\u6587\u4ef6\u4e0d\u53ef\u7528").oldObject((Object)fileStoreInfo));
            this.fileStoreInfoManager.markStoreErrorTag(fileStoreInfo);
        }
    }

    public void checkTempFileAndCreateTask(int limitSize) {
        List<FileStoreInfo> tempFils = this.fileStoreInfoManager.listTempFile(limitSize);
        if (tempFils == null || tempFils.isEmpty()) {
            return;
        }
        for (FileStoreInfo tempFile : tempFils) {
            this.transTempFileToStore(tempFile);
        }
    }

    protected void save(String tempFilePath, FileInfo file, long fileSize) {
        try {
            FileStoreInfo fileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)file.getFileMd5()));
            if (fileStoreInfo == null) {
                String fileStorePath = this.fetchOrSaveFile(tempFilePath, file, fileSize);
                fileStoreInfo = new FileStoreInfo(file.getFileMd5(), fileSize, fileStorePath, 1L, false);
                this.fileStoreInfoManager.saveNewObject(fileStoreInfo);
            } else {
                if (fileStoreInfo.isTemp().booleanValue()) {
                    fileStoreInfo.setFileStorePath(this.fetchOrSaveFile(tempFilePath, file, fileSize));
                    fileStoreInfo.setIsTemp("F");
                }
                this.fileStoreInfoManager.updateObject(fileStoreInfo);
            }
        }
        catch (Exception e) {
            logger.info("\u4fdd\u5b58\u6587\u4ef6\u51fa\u9519: " + e.getMessage());
            throw new ObjectException((Object)file, 628, e.getMessage(), (Throwable)e);
        }
    }
}

