/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.utils;

import com.centit.fileserver.common.FileBaseInfo;
import com.centit.fileserver.common.FileStore;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileSystemOpt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class OsFileStore
implements FileStore {
    private String fileRoot;

    public OsFileStore() {
    }

    public OsFileStore(String fileRoot) {
        this.setFileRoot(fileRoot);
    }

    public void setFileRoot(String fileRoot) {
        this.fileRoot = fileRoot.endsWith("/") || fileRoot.endsWith("\\") ? fileRoot : fileRoot + File.separatorChar;
    }

    public String calcFilePath(String fileStoreUrl) {
        if (fileStoreUrl.startsWith("/") || fileStoreUrl.indexOf(58) > 0) {
            return fileStoreUrl;
        }
        return this.fileRoot + fileStoreUrl;
    }

    public String matchFileStoreUrl(FileBaseInfo fileInfo, long fileSize) {
        String fileMd5 = fileInfo.getFileMd5();
        String pathname = String.valueOf(fileMd5.charAt(0)) + File.separatorChar + fileMd5.charAt(1) + File.separatorChar + fileMd5.charAt(2);
        FileSystemOpt.createDirect((String)this.calcFilePath(pathname));
        return pathname + File.separatorChar + fileMd5 + ".dat";
    }

    public String saveFile(FileBaseInfo fileInfo, long fileSize, InputStream is) throws IOException {
        String fileStroeUrl = this.matchFileStoreUrl(fileInfo, fileSize);
        String filePath = this.calcFilePath(fileStroeUrl);
        FileSystemOpt.createDirect((String)new File(filePath).getParent());
        FileIOOpt.writeInputStreamToFile((InputStream)is, (String)filePath);
        return fileStroeUrl;
    }

    public String saveFile(String sourFilePath, FileBaseInfo fileInfo, long fileSize) throws IOException {
        String filePath = this.matchFileStoreUrl(fileInfo, fileSize);
        FileSystemOpt.createDirect((String)new File(this.calcFilePath(filePath)).getParent());
        FileSystemOpt.fileCopy((String)sourFilePath, (String)this.calcFilePath(filePath));
        return filePath;
    }

    public boolean checkFile(String fileStoreUrl) {
        return FileSystemOpt.existFile((String)this.calcFilePath(fileStoreUrl));
    }

    public long getFileSize(String fileStoreUrl) throws IOException {
        File f = new File(this.calcFilePath(fileStoreUrl));
        return f.length();
    }

    public InputStream loadFileStream(String fileStoreUrl) throws IOException {
        if (FileSystemOpt.existFile((String)this.calcFilePath(fileStoreUrl))) {
            return new FileInputStream(new File(this.calcFilePath(fileStoreUrl)));
        }
        throw new ObjectException(this.calcFilePath(fileStoreUrl) + "\u65e0\u6b64\u6587\u4ef6");
    }

    public File getFile(String fileStoreUrl) throws IOException {
        return new File(this.calcFilePath(fileStoreUrl));
    }

    public boolean deleteFile(String fileUrl) throws IOException {
        return FileSystemOpt.deleteFile((String)this.calcFilePath(fileUrl));
    }

    public String getFileAccessUrl(String fileStoreUrl) {
        return fileStoreUrl;
    }
}

