/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.utils;

import com.alibaba.fastjson2.JSONObject;
import com.centit.fileserver.common.FileBaseInfo;
import com.centit.fileserver.common.FileStore;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.utils.FileRangeInfo;
import com.centit.fileserver.utils.SystemTempFileUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileMD5Maker;
import com.centit.support.file.FileSystemOpt;
import com.centit.support.file.FileType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;

public abstract class UploadDownloadUtils {
    private static final Logger logger = LoggerFactory.getLogger(UploadDownloadUtils.class);

    public static JSONObject checkFileRange(FileStore fileStore, FileBaseInfo fileInfo, long size) {
        JSONObject jsonObject;
        String tempFilePath = SystemTempFileUtils.getTempFilePath((String)fileInfo.getFileMd5(), (long)size);
        if (fileStore.checkFile(fileStore.matchFileStoreUrl(fileInfo, size))) {
            jsonObject = UploadDownloadUtils.makeRangeCheckJson(size, fileInfo.getFileMd5(), true);
        } else {
            long tempFileSize = 0L;
            if (new File(tempFilePath).exists()) {
                tempFileSize = SystemTempFileUtils.checkTempFileSize((String)tempFilePath);
            }
            jsonObject = UploadDownloadUtils.makeRangeCheckJson(tempFileSize, fileInfo.getFileMd5(), tempFileSize == size);
        }
        return jsonObject;
    }

    public static Pair<String, InputStream> fetchInputStreamFromRequest(HttpServletRequest request, boolean useCommonsReolver) throws IOException {
        String fileName = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"name", "fileName"});
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (!isMultipart) {
            return new ImmutablePair((Object)fileName, (Object)request.getInputStream());
        }
        CommonsMultipartResolver resolver = useCommonsReolver ? new CommonsMultipartResolver(request.getSession().getServletContext()) : new StandardServletMultipartResolver();
        MultipartHttpServletRequest multiRequest = resolver.resolveMultipart(request);
        Map map = multiRequest.getFileMap();
        InputStream fis = null;
        if (useCommonsReolver) {
            for (Map.Entry entry : map.entrySet()) {
                CommonsMultipartFile cMultipartFile = (CommonsMultipartFile)entry.getValue();
                FileItem fi = cMultipartFile.getFileItem();
                if (fi.isFormField()) continue;
                fileName = fi.getName();
                fis = fi.getInputStream();
                if (fis == null) continue;
                break;
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                MultipartFile cMultipartFile = (MultipartFile)entry.getValue();
                fileName = cMultipartFile.getResource().getFilename();
                fis = cMultipartFile.getInputStream();
            }
        }
        return new ImmutablePair((Object)fileName, fis);
    }

    public static Pair<String, InputStream> fetchInputStreamFromMultipartResolver(HttpServletRequest request) throws IOException {
        return UploadDownloadUtils.fetchInputStreamFromRequest(request, true);
    }

    public static Pair<String, InputStream> fetchInputStreamFromStandardResolver(HttpServletRequest request) throws IOException {
        return UploadDownloadUtils.fetchInputStreamFromRequest(request, false);
    }

    @Deprecated
    public static Pair<String, InputStream> fetchInputStreamFromRequest(HttpServletRequest request) throws IOException, FileUploadException {
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (!isMultipart) {
            String fileName = request.getParameter("name");
            if (StringUtils.isBlank((CharSequence)fileName)) {
                fileName = request.getParameter("fileName");
            }
            return new ImmutablePair((Object)fileName, (Object)request.getInputStream());
        }
        String fileName = null;
        ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        List fileItems = servletFileUpload.parseRequest(request);
        InputStream fis = null;
        for (FileItem fi : fileItems) {
            if (fi.isFormField()) continue;
            fileName = fi.getName();
            fis = fi.getInputStream();
            if (fis == null) continue;
            break;
        }
        if (StringUtils.isBlank(fileName)) {
            fileName = request.getParameter("name");
        }
        if (StringUtils.isBlank(fileName)) {
            fileName = request.getParameter("fileName");
        }
        return new ImmutablePair((Object)fileName, fis);
    }

    public static String encodeDownloadFilename(String paramName) {
        try {
            String enCodeName = new String(StringEscapeUtils.unescapeHtml4((String)paramName).getBytes("GBK"), "ISO8859-1");
            if (!Charset.forName("GBK").newEncoder().canEncode(enCodeName)) {
                return paramName;
            }
            return enCodeName;
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u8f6c\u6362\u6587\u4ef6\u540d " + paramName + " \u62a5\u9519\uff1a" + e.getMessage(), (Throwable)e);
            return paramName;
        }
    }

    public static String encodeDownloadFilename(String paramName, String downloadType) {
        try {
            if ("inline".equals(downloadType)) {
                return new String(StringEscapeUtils.unescapeHtml4((String)paramName).getBytes("utf-8"), "utf-8");
            }
            return UploadDownloadUtils.encodeDownloadFilename(paramName);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u8f6c\u6362\u6587\u4ef6\u540d " + paramName + " \u62a5\u9519\uff1a" + e.getMessage(), (Throwable)e);
            return paramName;
        }
    }

    private static void innerDownFileRange(HttpServletResponse response, InputStream inputStream, FileRangeInfo fr) throws IOException {
        long pos = fr.getRangeStart();
        BufferedInputStream bis = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, 65536);
        try (ServletOutputStream out = response.getOutputStream();
             BufferedOutputStream bufferOut = new BufferedOutputStream((OutputStream)out);){
            int length;
            long writeLen;
            if (pos > 0L) {
                bis.skip(pos);
            }
            byte[] buffer = new byte[65536];
            for (long needSize = fr.getPartSize(); needSize > 0L && (length = bis.read(buffer, 0, buffer.length)) != -1; needSize -= writeLen) {
                writeLen = Math.min(needSize, (long)length);
                bufferOut.write(buffer, 0, (int)writeLen);
                bufferOut.flush();
            }
        }
        catch (SocketException e) {
            logger.error("\u5ba2\u6237\u7aef\u65ad\u5f00\u94fe\u63a5\uff1a" + ObjectException.extortExceptionMessage((Throwable)e));
        }
    }

    private static void innerDownFileAll(HttpServletResponse response, InputStream inputStream) throws IOException {
        int fileSize = inputStream.available();
        if (fileSize > 0) {
            response.setHeader("Content-Length", String.valueOf(fileSize));
        }
        BufferedInputStream bis = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, 65536);
        try (ServletOutputStream out = response.getOutputStream();
             BufferedOutputStream bufferOut = new BufferedOutputStream((OutputStream)out);){
            int length;
            byte[] buffer = new byte[65536];
            while ((length = bis.read(buffer, 0, buffer.length)) != -1) {
                bufferOut.write(buffer, 0, length);
                bufferOut.flush();
            }
        }
        catch (SocketException e) {
            logger.error("\u5ba2\u6237\u7aef\u65ad\u5f00\u94fe\u63a5\uff1a" + ObjectException.extortExceptionMessage((Throwable)e));
        }
    }

    public static void downFileRange(HttpServletRequest request, HttpServletResponse response, InputStream inputStream, long fSize, String fileName, String downloadType, String charset) throws IOException {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = "attachment.dat";
        }
        response.setHeader("Accept-Ranges", "bytes");
        response.setContentType(FileType.getFileMimeType((String)fileName));
        if (!StringUtils.isBlank((CharSequence)charset)) {
            response.setCharacterEncoding(charset);
        }
        response.setHeader("Content-Disposition", ("inline".equalsIgnoreCase(downloadType) ? "inline" : "attachment") + "; filename=" + URLEncoder.encode(fileName, "UTF-8"));
        FileRangeInfo fr = FileRangeInfo.parseRange(request);
        if (fr == null) {
            UploadDownloadUtils.innerDownFileAll(response, inputStream);
            return;
        }
        int availableSize = inputStream.available();
        if (availableSize > 0) {
            fSize = availableSize;
        }
        if (fSize < 0L) {
            UploadDownloadUtils.innerDownFileAll(response, inputStream);
            return;
        }
        if (fr.getRangeEnd() <= 0L) {
            fr.setRangeEnd(fSize - 1L);
        }
        fr.setFileSize(fSize);
        if (fr.getPartSize() < fr.getFileSize()) {
            response.setStatus(206);
        }
        response.setHeader("Content-Length", String.valueOf(fr.getPartSize()));
        response.setHeader("Content-Range", fr.getResponseRange());
        UploadDownloadUtils.innerDownFileRange(response, inputStream, fr);
    }

    private static long checkTempFileSize(String filePath) {
        File f = new File(filePath);
        if (!f.exists()) {
            return 0L;
        }
        return f.length();
    }

    public static long uploadRange(String tempFilePath, InputStream fileInputStream, String token, long size, HttpServletRequest request) throws IOException, ObjectException {
        long tempFileSize = UploadDownloadUtils.checkTempFileSize(tempFilePath);
        FileRangeInfo range = FileRangeInfo.parseRange(request);
        if (tempFileSize < size || tempFileSize == 0L) {
            if (tempFileSize != range.getRangeStart()) {
                throw new ObjectException((Object)CollectionsOpt.createHashMap((Object[])new Object[]{"start", tempFileSize, "fileSize", tempFileSize, "fileMd5", token}), 420, "Code: 420 RANGE\u683c\u5f0f\u9519\u8bef\u6216\u8005\u8d8a\u754c\u3002Range:" + range.getRangeStart() + " savedSize:" + tempFileSize + " fileSize:" + size);
            }
            try (FileOutputStream out = new FileOutputStream(tempFilePath, true);){
                long length = FileIOOpt.writeInputStreamToOutputStream((InputStream)fileInputStream, (OutputStream)out);
                if (length != range.getPartSize()) {
                    throw new ObjectException((Object)CollectionsOpt.createHashMap((Object[])new Object[]{"start", tempFileSize, "fileSize", tempFileSize, "fileMd5", token}), 420, "Code: 420 RANGE\u683c\u5f0f\u9519\u8bef\u6216\u8005\u8d8a\u754c\u3002Range:" + range.getRangeStart() + " uploadSize:" + range.getPartSize() + "receivedSize" + length + " fileSize:" + size);
                }
            }
            tempFileSize = range.getRangeStart() + range.getPartSize();
        }
        if (tempFileSize == size) {
            String fileMd5 = FileMD5Maker.makeFileMD5((File)new File(tempFilePath));
            if (StringUtils.equals((CharSequence)fileMd5, (CharSequence)token)) {
                return size;
            }
            FileSystemOpt.deleteFile((String)tempFilePath);
            throw new ObjectException(425, "Code: 425 \u6587\u4ef6MD5\u8ba1\u7b97\u9519\u8bef\u3002");
        }
        return tempFileSize;
    }

    public static JSONObject makeRangeCheckJson(long rangeFileSize, String fileMd5, boolean hasStored) {
        JSONObject json = new JSONObject();
        json.put((Object)"start", (Object)rangeFileSize);
        if (hasStored) {
            json.put((Object)"signal", (Object)"secondpass");
            json.put((Object)"message", (Object)"\u68c0\u67e5\u6587\u4ef6\u4e0a\u4f20\u70b9, \u8bf7\u8c03\u7528\u79d2\u4f20(secondpass)\u63a5\u53e3!");
        } else {
            json.put((Object)"signal", (Object)"continue");
            json.put((Object)"message", (Object)"\u68c0\u67e5\u6587\u4ef6\u4e0a\u4f20\u70b9, \u8bf7\u8c03\u7528\u7eed\u4f20(range)\u63a5\u53e3!");
        }
        json.put((Object)"code", (Object)0);
        json.put((Object)"data", (Object)CollectionsOpt.createHashMap((Object[])new Object[]{"fileMd5", fileMd5, "fileSize", rangeFileSize}));
        return json;
    }

    public static JSONObject makeRangeUploadJson(long rangeFileSize, String fileMd5, String fileName) {
        JSONObject json = new JSONObject();
        json.put((Object)"start", (Object)rangeFileSize);
        json.put((Object)"signal", (Object)"continue");
        json.put((Object)"code", (Object)0);
        json.put((Object)"message", (Object)"\u4e0a\u4f20\u6587\u4ef6\u7247\u6bb5\u6210\u529f!");
        json.put((Object)"data", (Object)CollectionsOpt.createHashMap((Object[])new Object[]{"fileName", fileName, "fileMd5", fileMd5, "fileSize", rangeFileSize}));
        return json;
    }

    public static JSONObject makeRangeUploadCompleteJson(long fileSize, Object fileInfo, String message) {
        JSONObject json = new JSONObject();
        json.put((Object)"start", (Object)fileSize);
        json.put((Object)"signal", (Object)"complete");
        json.put((Object)"code", (Object)0);
        json.put((Object)"message", (Object)message);
        json.put((Object)"data", fileInfo);
        return json;
    }

    public static JSONObject makeRangeUploadCompleteJson(String fileMd5, long fileSize, String fileName, String fileId, String message) {
        return UploadDownloadUtils.makeRangeUploadCompleteJson(fileSize, CollectionsOpt.createHashMap((Object[])new Object[]{"fileId", fileId, "fileMd5", fileMd5, "fileSize", fileSize, "fileName", fileName}), message);
    }

    public static String encodeFileName(String fileName, String characterEncoding) {
        try {
            if (fileName.length() > 150) {
                return new String(fileName.getBytes(characterEncoding), "ISO8859-1");
            }
            return URLEncoder.encode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage());
            return fileName;
        }
    }

    private static void innerDownloadFile(InputStream downloadFile, String fileName, HttpServletResponse response, String characterEncoding) throws IOException {
        response.setContentType("application/x-msdownload;");
        response.setHeader("Content-disposition", "attachment; filename=" + UploadDownloadUtils.encodeFileName(fileName, characterEncoding));
        response.setHeader("Content-Length", String.valueOf(downloadFile.available()));
        IOUtils.copy((InputStream)downloadFile, (OutputStream)response.getOutputStream());
    }

    public static void downloadFile(InputStream downloadFile, String fileName, HttpServletResponse response) throws IOException {
        UploadDownloadUtils.innerDownloadFile(downloadFile, fileName, response, "GBK");
    }

    public static void downloadFile(InputStream downloadFile, String fileName, HttpServletRequest request, HttpServletResponse response) throws IOException {
        UploadDownloadUtils.innerDownloadFile(downloadFile, fileName, response, request.getCharacterEncoding());
    }

    public static FileInfo createFileBaseInfo(HttpServletRequest request) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFileMd5(WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"token", "fileMd5"}));
        fileInfo.setFileName(WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"name", "fileName"}));
        fileInfo.setOptId(request.getParameter("optId"));
        fileInfo.setFileOwner(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        String fileUnit = request.getParameter("fileUnit");
        if (StringUtils.isBlank((CharSequence)fileUnit)) {
            fileUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        }
        fileInfo.setFileUnit(fileUnit);
        Long fileSize = NumberBaseOpt.parseLong((String)WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"size", "fileSize"}), (Long)-1L);
        fileInfo.setFileSize(fileSize.longValue());
        return fileInfo;
    }

    public static FileInfo createFileBaseInfo(HttpServletRequest request, String fileMd5, long fileSize) {
        FileInfo fileInfo = UploadDownloadUtils.createFileBaseInfo(request);
        if (StringUtils.isNotBlank((CharSequence)fileMd5)) {
            fileInfo.setFileMd5(fileMd5);
        }
        if (fileSize > 0L) {
            fileInfo.setFileSize(fileSize);
        }
        return fileInfo;
    }

    public static FileInfo createFileBaseInfo(String fileIdIncludeMd5AndSize) {
        Pair md5Size = SystemTempFileUtils.fetchMd5AndSize((String)fileIdIncludeMd5AndSize);
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFileId(fileIdIncludeMd5AndSize);
        fileInfo.setFileMd5((String)md5Size.getLeft());
        fileInfo.setFileSize(((Long)md5Size.getRight()).longValue());
        return fileInfo;
    }
}

