/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.utils;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.centit.support.database.metadata.IDatabaseInfo;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.DataSourceDescription;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbcpConnectPools {
    private static final Logger logger = LoggerFactory.getLogger(DbcpConnectPools.class);
    private static final ConcurrentHashMap<DataSourceDescription, DruidDataSource> dbcpDataSourcePools = new ConcurrentHashMap();

    private DbcpConnectPools() {
        throw new IllegalAccessError("Utility class");
    }

    private static DruidDataSource mapDataSource(DataSourceDescription dsDesc) {
        DruidDataSource ds = new DruidDataSource();
        ds.setDriverClassName(dsDesc.getDriver());
        ds.setUsername(dsDesc.getUsername());
        ds.setPassword(dsDesc.getPassword());
        ds.setUrl(dsDesc.getConnUrl());
        ds.setInitialSize(dsDesc.getInitialSize());
        ds.setMaxActive(dsDesc.getMaxTotal());
        ds.setMaxWait((long)dsDesc.getMaxWaitMillis());
        ds.setMinIdle(dsDesc.getMinIdle());
        String validationQuery = DBType.getDBValidationQuery((DBType)dsDesc.getDbType());
        if (StringUtils.isNotBlank((CharSequence)validationQuery)) {
            ds.setValidationQuery(validationQuery);
            ds.setTestWhileIdle(true);
        }
        return ds;
    }

    public static synchronized DruidDataSource getDataSource(DataSourceDescription dsDesc) {
        DruidDataSource ds = dbcpDataSourcePools.get(dsDesc);
        if (ds == null) {
            ds = DbcpConnectPools.mapDataSource(dsDesc);
            dbcpDataSourcePools.put(dsDesc, ds);
        }
        return ds;
    }

    public static synchronized Connection getDbcpConnect(DataSourceDescription dsDesc) throws SQLException {
        DruidDataSource ds = DbcpConnectPools.getDataSource(dsDesc);
        DruidPooledConnection conn = ds.getConnection();
        conn.setAutoCommit(false);
        return conn;
    }

    public static DruidDataSource getDataSource(IDatabaseInfo dbinfo) {
        return DbcpConnectPools.getDataSource(DataSourceDescription.valueOf(dbinfo));
    }

    public static Connection getDbcpConnect(IDatabaseInfo dbinfo) throws SQLException {
        return DbcpConnectPools.getDbcpConnect(DataSourceDescription.valueOf(dbinfo));
    }

    public static Map<String, Object> getDataSourceStats(DataSourceDescription dsDesc) {
        DruidDataSource bds = dbcpDataSourcePools.get(dsDesc);
        if (bds == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("activeCount", bds.getActiveCount());
        map.put("poolingCount", bds.getPoolingCount());
        map.put("resetCount", bds.getResetCount());
        map.put("errorCount", bds.getErrorCount());
        map.put("discardCount", bds.getDiscardCount());
        return map;
    }

    public static synchronized void shutdownDataSource() {
        for (Map.Entry<DataSourceDescription, DruidDataSource> dbs : dbcpDataSourcePools.entrySet()) {
            dbs.getValue().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean testDataSource(DataSourceDescription dsDesc) {
        boolean connOk = false;
        try (DruidDataSource ds = DbcpConnectPools.mapDataSource(dsDesc);){
            DruidPooledConnection conn = ds.getConnection();
            if (conn != null) {
                connOk = true;
                conn.close();
            }
            ds.close();
        }
        return connOk;
    }

    public static void closeConnect(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

