/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.transaction;

import com.centit.support.database.transaction.ConnectThreadHolder;
import com.centit.support.database.transaction.JdbcTransaction;
import java.sql.SQLException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class JdbcTransactionAspect {
    protected static final Logger logger = LoggerFactory.getLogger(JdbcTransactionAspect.class);

    @Pointcut(value="@annotation(com.centit.support.database.transaction.JdbcTransaction)")
    public void transactionAspect() {
    }

    @AfterThrowing(pointcut="transactionAspect() && @annotation(transaction)", throwing="ex")
    public void doAfterThrowing(JoinPoint joinPoint, JdbcTransaction transaction, Throwable ex) {
        if (ex instanceof RuntimeException) {
            try {
                ConnectThreadHolder.rollbackAndRelease();
            }
            catch (SQLException e) {
                logger.error(e.getLocalizedMessage());
            }
        }
    }

    @AfterReturning(pointcut="transactionAspect() && @annotation(transaction)")
    public void doAfterReturning(JoinPoint joinPoint, JdbcTransaction transaction) {
        try {
            ConnectThreadHolder.commitAndRelease();
        }
        catch (SQLException e) {
            logger.error(e.getLocalizedMessage());
        }
    }
}

