/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.orm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.LeftRightPair;
import com.centit.support.compiler.VariableFormula;
import com.centit.support.database.jsonmaptable.GeneralJsonObjectDao;
import com.centit.support.database.jsonmaptable.JsonObjectDao;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorTime;
import com.centit.support.database.orm.JpaMetadata;
import com.centit.support.database.orm.TableMapInfo;
import com.centit.support.database.orm.ValueGenerator;
import com.centit.support.database.utils.DatabaseAccess;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class OrmUtils {
    private OrmUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static void setObjectFieldValue(Object object, SimpleTableField field, Object newValue) throws IOException {
        if (newValue instanceof Clob) {
            if ("text".equals(field.getFieldLabelName())) {
                field.setObjectFieldValue(object, newValue);
            } else {
                field.setObjectFieldValue(object, DatabaseAccess.fetchClobString((Clob)newValue));
            }
        } else if (newValue instanceof Blob) {
            if ("bytes".equals(field.getFieldLabelName())) {
                field.setObjectFieldValue(object, newValue);
            } else {
                field.setObjectFieldValue(object, DatabaseAccess.fetchBlobBytes((Blob)newValue));
            }
        } else {
            field.setObjectFieldValue(object, newValue);
        }
    }

    private static <T> T makeObjectValueByGenerator(T object, TableMapInfo mapInfo, JsonObjectDao sqlDialect, GeneratorTime generatorTime) throws SQLException, NoSuchFieldException, IOException {
        List<LeftRightPair<String, ValueGenerator>> valueGenerators = mapInfo.getValueGenerators();
        if (valueGenerators == null || valueGenerators.size() < 1) {
            return object;
        }
        for (LeftRightPair<String, ValueGenerator> ent : valueGenerators) {
            SimpleTableField filed;
            Object fieldValue;
            ValueGenerator valueGenerator = (ValueGenerator)ent.getRight();
            if (!valueGenerator.occasion().matchTime(generatorTime) || (fieldValue = ReflectionOpt.forceGetProperty(object, (String)(filed = mapInfo.findFieldByName((String)ent.getLeft())).getPropertyName())) != null && valueGenerator.condition() != GeneratorCondition.ALWAYS) continue;
            switch (valueGenerator.strategy()) {
                case UUID: {
                    filed.setObjectFieldValue(object, UuidOpt.getUuidAsString32());
                    break;
                }
                case UUID22: {
                    filed.setObjectFieldValue(object, UuidOpt.getUuidAsString22());
                    break;
                }
                case SEQUENCE: {
                    if (sqlDialect == null) break;
                    OrmUtils.setObjectFieldValue(object, filed, sqlDialect.getSequenceNextValue(valueGenerator.value()));
                    break;
                }
                case CONSTANT: {
                    OrmUtils.setObjectFieldValue(object, filed, valueGenerator.value());
                    break;
                }
                case FUNCTION: {
                    OrmUtils.setObjectFieldValue(object, filed, VariableFormula.calculate((String)valueGenerator.value(), object));
                    break;
                }
                case LSH: {
                    String genValue = valueGenerator.value();
                    int n = genValue.indexOf(58);
                    if (n <= 0 || sqlDialect == null) break;
                    String seq = genValue.substring(0, n);
                    Long seqNo = sqlDialect.getSequenceNextValue(valueGenerator.value());
                    JSONObject json = (JSONObject)JSON.toJSON(object);
                    json.put("no", (Object)seqNo);
                    OrmUtils.setObjectFieldValue(object, filed, VariableFormula.calculate((String)genValue.substring(n + 1), object));
                }
            }
        }
        return object;
    }

    public static <T> T prepareObjectForInsert(T object, TableMapInfo mapInfo, JsonObjectDao sqlDialect) throws SQLException, NoSuchFieldException, IOException {
        return OrmUtils.makeObjectValueByGenerator(object, mapInfo, sqlDialect, GeneratorTime.NEW);
    }

    public static <T> T prepareObjectForUpdate(T object, TableMapInfo mapInfo, JsonObjectDao sqlDialect) throws SQLException, NoSuchFieldException, IOException {
        return OrmUtils.makeObjectValueByGenerator(object, mapInfo, sqlDialect, GeneratorTime.UPDATE);
    }

    public static <T> T prepareObjectForMerge(T object, TableMapInfo mapInfo, JsonObjectDao sqlDialect) throws SQLException, NoSuchFieldException, IOException {
        Map<String, Object> objectMap = OrmUtils.fetchObjectDatabaseField(object, mapInfo);
        if (!GeneralJsonObjectDao.checkHasAllPkColumns(mapInfo, objectMap)) {
            return OrmUtils.makeObjectValueByGenerator(object, mapInfo, sqlDialect, GeneratorTime.NEW);
        }
        return OrmUtils.makeObjectValueByGenerator(object, mapInfo, sqlDialect, GeneratorTime.UPDATE);
    }

    public static Map<String, Object> fetchObjectField(Object object) {
        if (object instanceof Map) {
            return (Map)object;
        }
        Field[] objFields = object.getClass().getDeclaredFields();
        HashMap<String, Object> fields = new HashMap<String, Object>(objFields.length * 2);
        for (Field field : objFields) {
            Object value = ReflectionOpt.forceGetFieldValue((Object)object, (Field)field);
            fields.put(field.getName(), value);
        }
        return fields;
    }

    public static Map<String, Object> fetchObjectDatabaseField(Object object, TableMapInfo tableInfo) {
        Object value;
        List<SimpleTableField> tableFields = tableInfo.getColumns();
        if (tableFields == null) {
            return null;
        }
        HashMap<String, Object> fields = new HashMap<String, Object>(tableFields.size() * 2 + 6);
        for (SimpleTableField column : tableFields) {
            value = column.getObjectFieldValue(object);
            if (value == null) continue;
            if ("boolean".equals(column.getFieldType())) {
                value = BooleanBaseOpt.castObjectToBoolean((Object)value, (Boolean)false) != false ? "T" : "F";
            }
            fields.put(column.getPropertyName(), value);
        }
        tableFields = tableInfo.getLazyColumns();
        if (tableFields != null) {
            for (SimpleTableField column : tableFields) {
                value = column.getObjectFieldValue(object);
                if (value == null) continue;
                fields.put(column.getPropertyName(), value);
            }
        }
        return fields;
    }

    private static <T> T insideFetchFieldsFormResultSet(ResultSet rs, T object, TableMapInfo mapInfo) throws SQLException, NoSuchFieldException, IOException {
        ResultSetMetaData resMeta = rs.getMetaData();
        int fieldCount = resMeta.getColumnCount();
        for (int i = 1; i <= fieldCount; ++i) {
            String columnName = resMeta.getColumnName(i);
            SimpleTableField filed = mapInfo.findFieldByColumn(columnName);
            if (filed == null) continue;
            OrmUtils.setObjectFieldValue(object, filed, rs.getObject(i));
        }
        return OrmUtils.makeObjectValueByGenerator(object, mapInfo, null, GeneratorTime.READ);
    }

    public static <T> T fetchObjectFormResultSet(ResultSet rs, Class<T> clazz) throws SQLException, IllegalAccessException, InstantiationException, NoSuchFieldException, IOException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(clazz);
        if (mapInfo == null) {
            return null;
        }
        if (rs.next()) {
            return OrmUtils.insideFetchFieldsFormResultSet(rs, clazz.newInstance(), mapInfo);
        }
        return null;
    }

    public static <T> T fetchFieldsFormResultSet(ResultSet rs, T object, TableMapInfo mapInfo) throws SQLException, NoSuchFieldException, IOException {
        if (rs.next()) {
            object = OrmUtils.insideFetchFieldsFormResultSet(rs, object, mapInfo);
        }
        return object;
    }

    public static <T> List<T> fetchObjectListFormResultSet(ResultSet rs, Class<T> clazz) throws SQLException, IllegalAccessException, InstantiationException, NoSuchFieldException, IOException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(clazz);
        if (mapInfo == null) {
            return null;
        }
        ResultSetMetaData resMeta = rs.getMetaData();
        int fieldCount = resMeta.getColumnCount();
        SimpleTableField[] fields = new SimpleTableField[fieldCount + 1];
        for (int i = 1; i <= fieldCount; ++i) {
            String columnName = resMeta.getColumnName(i);
            fields[i] = mapInfo.findFieldByColumn(columnName);
        }
        ArrayList<T> listObj = new ArrayList<T>();
        while (rs.next()) {
            T object = clazz.newInstance();
            for (int i = 1; i <= fieldCount; ++i) {
                if (fields[i] == null) continue;
                OrmUtils.setObjectFieldValue(object, fields[i], rs.getObject(i));
            }
            listObj.add(OrmUtils.makeObjectValueByGenerator(object, mapInfo, null, GeneratorTime.READ));
        }
        return listObj;
    }
}

