/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.database.metadata.DatabaseMetadata;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.metadata.SimpleTableReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DB2Metadata
implements DatabaseMetadata {
    protected static final Logger logger = LoggerFactory.getLogger(DB2Metadata.class);
    private static final String sqlGetTabColumns = "select a.name,a.coltype,a.length, a.scale, a.nulls from sysibm.systables b , sysibm.syscolumns a where a.tbcreator= ? and a.tbname= ? and b.name=a.tbname and b.creator=a.tbcreator";
    private static final String sqlPKInfo = "select constname, colname from sysibm.syskeycoluse where tbcreator=? and tbname=? order by colseq";
    private static final String sqlFKInfo = "select tbname, relname, colcount, fkcolnames, pkcolnames from sysibm.sysrels where refkeyname= ?";
    private static final String sqlFKColumn = "select a.name,a.coltype,a.length, a.scale, a.nulls from sysibm.systables b , sysibm.syscolumns a where a.tbcreator= ? and a.tbname= ? and a.name= ? and b.name=a.tbname and b.creator=a.tbcreator";
    private String sDBSchema;
    private Connection dbc;

    @Override
    public void setDBConfig(Connection dbc) {
        this.dbc = dbc;
    }

    @Override
    public String getDBSchema() {
        return this.sDBSchema;
    }

    @Override
    public void setDBSchema(String schema) {
        if (schema != null) {
            this.sDBSchema = schema.toUpperCase();
        }
    }

    @Override
    public SimpleTableInfo getTableMetadata(String tabName) {
        Throwable throwable;
        ResultSet rs2;
        Throwable throwable2;
        PreparedStatement pStmt;
        SimpleTableInfo tab = new SimpleTableInfo(tabName);
        try {
            pStmt = this.dbc.prepareStatement(sqlGetTabColumns);
            throwable2 = null;
            try {
                pStmt.setString(1, this.sDBSchema);
                pStmt.setString(2, tabName);
                tab.setSchema(this.dbc.getSchema().toUpperCase());
                rs2 = pStmt.executeQuery();
                throwable = null;
                try {
                    while (rs2.next()) {
                        SimpleTableField field = new SimpleTableField();
                        field.setColumnName(rs2.getString("name"));
                        field.setColumnType(rs2.getString("coltype"));
                        field.setMaxLength(rs2.getInt("length"));
                        field.setPrecision(field.getMaxLength());
                        field.setScale(rs2.getInt("scale"));
                        field.setNullEnable(rs2.getString("nulls"));
                        field.mapToMetadata();
                        tab.addColumn(field);
                    }
                }
                catch (Throwable field) {
                    throwable = field;
                    throw field;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable field) {
                                throwable.addSuppressed(field);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable rs2) {
                throwable2 = rs2;
                throw rs2;
            }
            finally {
                if (pStmt != null) {
                    if (throwable2 != null) {
                        try {
                            pStmt.close();
                        }
                        catch (Throwable rs2) {
                            throwable2.addSuppressed(rs2);
                        }
                    } else {
                        pStmt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        try {
            pStmt = this.dbc.prepareStatement(sqlPKInfo);
            throwable2 = null;
            try {
                pStmt.setString(1, this.sDBSchema);
                pStmt.setString(2, tabName);
                rs2 = pStmt.executeQuery();
                throwable = null;
                try {
                    while (rs2.next()) {
                        tab.setPkName(rs2.getString("constname"));
                        tab.setColumnAsPrimaryKey(rs2.getString("colname"));
                    }
                }
                catch (Throwable field) {
                    throwable = field;
                    throw field;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable field) {
                                throwable.addSuppressed(field);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable rs3) {
                throwable2 = rs3;
                throw rs3;
            }
            finally {
                if (pStmt != null) {
                    if (throwable2 != null) {
                        try {
                            pStmt.close();
                        }
                        catch (Throwable rs3) {
                            throwable2.addSuppressed(rs3);
                        }
                    } else {
                        pStmt.close();
                    }
                }
            }
        }
        catch (SQLException e1) {
            logger.error(e1.getLocalizedMessage(), (Throwable)e1);
        }
        try {
            pStmt = this.dbc.prepareStatement(sqlFKInfo);
            throwable2 = null;
            try {
                pStmt.setString(1, tab.getPkName());
                rs2 = pStmt.executeQuery();
                throwable = null;
                try {
                    while (rs2.next()) {
                        SimpleTableReference ref = new SimpleTableReference();
                        ref.setParentTableName(tabName);
                        ref.setTableName(rs2.getString("tbname"));
                        ref.setReferenceCode(rs2.getString("relname"));
                        int nColCount = rs2.getInt("colcount");
                        String sFColNames = rs2.getString("fkcolnames").trim();
                        String[] p = sFColNames.split("\\s+");
                        String sPColNames = rs2.getString("pkcolnames").trim();
                        String[] pK = sPColNames.split("\\s+");
                        if (nColCount != p.length) {
                            System.out.println("\u5916\u952e" + ref.getReferenceCode() + "\u5b57\u6bb5\u5206\u9694\u51fa\u9519\uff01");
                        }
                        for (int i = 0; i < p.length; ++i) {
                            if (i >= pK.length) continue;
                            ref.addReferenceColumn(pK[i], p[i]);
                        }
                        tab.addReference(ref);
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                if (pStmt != null) {
                    if (throwable2 != null) {
                        try {
                            pStmt.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                    } else {
                        pStmt.close();
                    }
                }
            }
        }
        catch (SQLException e1) {
            logger.error(e1.getLocalizedMessage(), (Throwable)e1);
        }
        return tab;
    }
}

