/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.common.JavaBeanField;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.utils.FieldType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;

public class SimpleTableField
implements TableField {
    private String propertyName;
    private String fieldLabelName;
    private String columnType;
    private String columnName;
    private String columnComment;
    private String defaultValue;
    private String fieldType;
    private boolean mandatory = false;
    private Integer maxLength = 0;
    private Integer precision = 0;
    private Integer scale = 0;
    private JavaBeanField beanField;
    private boolean lazyFetch = false;
    private boolean primaryKey = false;

    public void mapToMetadata() {
        this.propertyName = FieldType.mapPropName(this.columnName);
        this.fieldType = FieldType.mapToFieldType(this.columnType, this.scale);
        boolean bl = this.lazyFetch = "text".equals(this.fieldType) || "bytes".equals(this.fieldType) || "object".equals(this.fieldType);
        if (("long".equals(this.fieldType) || "double".equals(this.fieldType)) && this.maxLength <= 0) {
            this.maxLength = 8;
        }
        if (("date".equals(this.fieldType) || "datetime".equals(this.fieldType) || "timestamp".equals(this.fieldType)) && this.maxLength <= 0) {
            this.maxLength = 7;
        }
    }

    @Override
    public Class<?> getJavaType() {
        if (this.beanField != null) {
            return this.beanField.getFieldType();
        }
        return FieldType.mapToJavaType(this.fieldType);
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String name) {
        this.propertyName = name;
    }

    @Override
    public String getFieldType() {
        if (StringUtils.isBlank((CharSequence)this.fieldType)) {
            return FieldType.mapToFieldType(this.columnType, this.scale);
        }
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    @Override
    public String getFieldLabelName() {
        return this.fieldLabelName;
    }

    public void setFieldLabelName(String desc) {
        this.fieldLabelName = desc;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String column) {
        this.columnName = column;
    }

    @Override
    public String getColumnComment() {
        return this.columnComment;
    }

    public void setColumnComment(String comment) {
        this.columnComment = comment;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean notnull) {
        this.mandatory = notnull;
    }

    public void setMandatory(String notnull) {
        this.mandatory = StringRegularOpt.isTrue((String)notnull);
    }

    @Override
    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    @Override
    public boolean isLazyFetch() {
        return this.lazyFetch;
    }

    public void setLazyFetch(boolean lazyFetch) {
        this.lazyFetch = lazyFetch;
    }

    public void setNullEnable(String nullEnable) {
        this.mandatory = StringRegularOpt.isFalse((String)nullEnable);
    }

    @Override
    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    @Override
    public String getColumnType() {
        return this.columnType;
    }

    public void setColumnType(String type) {
        if (type != null) {
            this.columnType = type.trim();
            int nPos = this.columnType.indexOf(40);
            if (nPos > 0) {
                this.columnType = this.columnType.substring(0, nPos);
            }
        }
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setObjectField(Field objectField) {
        if (this.beanField == null) {
            this.beanField = new JavaBeanField();
        }
        this.beanField.setObjectField(objectField);
    }

    public void setObjectSetFieldValueFunc(Method objectSetFieldValueFunc) {
        if (this.beanField == null) {
            this.beanField = new JavaBeanField();
        }
        this.beanField.setSetFieldValueFunc(objectSetFieldValueFunc);
    }

    public void setObjectGetFieldValueFunc(Method objectGetFieldValueFunc) {
        if (this.beanField == null) {
            this.beanField = new JavaBeanField();
        }
        this.beanField.setGetFieldValueFunc(objectGetFieldValueFunc);
    }

    public JavaBeanField getBeanField() {
        return this.beanField;
    }
}

