/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.common.JavaBeanField;
import com.centit.support.database.metadata.TableReference;
import com.centit.support.database.orm.JpaMetadata;
import com.centit.support.database.orm.TableMapInfo;
import com.centit.support.database.utils.FieldType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SimpleTableReference
implements TableReference {
    private String parentTableName;
    private String tableName;
    private String referenceName;
    private String referenceCode;
    private Class<?> referenceFieldType;
    private Class<?> targetEntityType;
    private Map<String, String> referenceColumns;
    private int nObjectId;
    private JavaBeanField beanField;

    public int getObjectId() {
        return this.nObjectId;
    }

    public void setObjectId(int objectId) {
        this.nObjectId = objectId;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public String getReferenceName() {
        return this.referenceName;
    }

    public void setReferenceName(String referenceName) {
        this.referenceName = referenceName;
    }

    @Override
    public String getReferenceCode() {
        return this.referenceCode;
    }

    public void setReferenceCode(String referenceCode) {
        this.referenceCode = referenceCode;
    }

    @Override
    public boolean containColumn(String sCol) {
        if (sCol == null || this.referenceColumns == null || this.referenceColumns.size() == 0) {
            return false;
        }
        return this.referenceColumns.containsKey(sCol);
    }

    public String getClassName() {
        if (this.tableName == null) {
            return null;
        }
        String sClassName = FieldType.mapPropName(this.tableName);
        return sClassName.substring(0, 1).toUpperCase() + sClassName.substring(1);
    }

    @Override
    public Map<String, String> getReferenceColumns() {
        if (this.referenceColumns == null) {
            this.referenceColumns = new HashMap<String, String>(6);
        }
        return this.referenceColumns;
    }

    public void setReferenceColumns(Map<String, String> referenceColumns) {
        this.referenceColumns = referenceColumns;
    }

    @Override
    public String getParentTableName() {
        return this.parentTableName;
    }

    public void setParentTableName(String parentTableName) {
        this.parentTableName = parentTableName;
    }

    public void addReferenceColumn(String column, String referencedColumn) {
        if (this.referenceColumns == null) {
            this.referenceColumns = new HashMap<String, String>(6);
        }
        this.referenceColumns.put(column, StringUtils.isBlank((CharSequence)referencedColumn) ? column : referencedColumn);
    }

    public Class<?> getReferenceFieldType() {
        return this.referenceFieldType;
    }

    public void setReferenceFieldType(Class<?> referenceFieldType) {
        this.referenceFieldType = referenceFieldType;
    }

    public Class<?> getTargetEntityType() {
        return this.targetEntityType;
    }

    public void setTargetEntityType(Class<?> targetEntityType) {
        this.targetEntityType = targetEntityType;
    }

    public void setObjectField(Field objectField) {
        if (this.beanField == null) {
            this.beanField = new JavaBeanField();
        }
        this.beanField.setObjectField(objectField);
    }

    public void setObjectSetFieldValueFunc(Method objectSetFieldValueFunc) {
        if (this.beanField == null) {
            this.beanField = new JavaBeanField();
        }
        this.beanField.setSetFieldValueFunc(objectSetFieldValueFunc);
    }

    public void setObjectGetFieldValueFunc(Method objectGetFieldValueFunc) {
        if (this.beanField == null) {
            this.beanField = new JavaBeanField();
        }
        this.beanField.setGetFieldValueFunc(objectGetFieldValueFunc);
    }

    public void setObjectFieldValue(Object obj, Object fieldValue) {
        this.beanField.setObjectFieldValue(obj, fieldValue);
    }

    public Object getObjectFieldValue(Object obj) {
        return this.beanField.getObjectFieldValue(obj);
    }

    public Map<String, Object> fetchChildFk(Object parentObject) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(parentObject.getClass());
        HashMap<String, Object> fk = new HashMap<String, Object>(8);
        for (Map.Entry<String, String> end : this.referenceColumns.entrySet()) {
            Object fkValue = mapInfo.getObjectFieldValue(parentObject, end.getKey());
            if (fkValue == null) {
                return null;
            }
            fk.put(end.getValue(), fkValue);
        }
        return fk;
    }

    public Map<String, Object> fetchParentPk(Object childObject) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(childObject.getClass());
        HashMap<String, Object> pk = new HashMap<String, Object>(8);
        for (Map.Entry<String, String> end : this.referenceColumns.entrySet()) {
            Object fkValue = mapInfo.getObjectFieldValue(childObject, end.getValue());
            if (fkValue == null) {
                return null;
            }
            pk.put(end.getKey(), fkValue);
        }
        return pk;
    }
}

