/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.ddl;

import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.compiler.Lexer;
import com.centit.support.database.ddl.DB2DDLOperations;
import com.centit.support.database.ddl.DDLOperations;
import com.centit.support.database.ddl.H2DDLOperations;
import com.centit.support.database.ddl.MySqlDDLOperations;
import com.centit.support.database.ddl.OracleDDLOperations;
import com.centit.support.database.ddl.PostgreSqlDDLOperations;
import com.centit.support.database.ddl.SqlSvrDDLOperations;
import com.centit.support.database.ddl.SqliteDDLOperations;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.QueryUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class GeneralDDLOperations
implements DDLOperations {
    protected Connection conn;

    public GeneralDDLOperations() {
    }

    public GeneralDDLOperations(Connection conn) {
        this.conn = conn;
    }

    public static GeneralDDLOperations createDDLOperations(DBType dbtype) {
        switch (dbtype) {
            case Oracle: 
            case DM: 
            case KingBase: 
            case GBase: 
            case Oscar: {
                return new OracleDDLOperations();
            }
            case DB2: {
                return new DB2DDLOperations();
            }
            case SqlServer: {
                return new SqlSvrDDLOperations();
            }
            case MySql: 
            case ClickHouse: {
                return new MySqlDDLOperations();
            }
            case H2: {
                return new H2DDLOperations();
            }
            case PostgreSql: {
                return new PostgreSqlDDLOperations();
            }
            case Sqlite: {
                return new SqliteDDLOperations();
            }
        }
        throw new ObjectException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + (Object)((Object)dbtype));
    }

    public static GeneralDDLOperations createDDLOperations(Connection conn) throws SQLException {
        DBType dbtype = DBType.mapDBType(conn.getMetaData().getURL());
        GeneralDDLOperations dllOperations = GeneralDDLOperations.createDDLOperations(dbtype);
        dllOperations.setConnect(conn);
        return dllOperations;
    }

    public static final Pair<Integer, String> checkTableWellDefined(TableInfo tableInfo) {
        if (!Lexer.isLabel((CharSequence)tableInfo.getTableName())) {
            return new ImmutablePair((Object)-1, (Object)("\u8868\u540d" + tableInfo.getTableName() + "\u683c\u5f0f\u4e0d\u6b63\u786e\uff01"));
        }
        if (tableInfo.getColumns() == null) {
            return new ImmutablePair((Object)-5, (Object)"\u6ca1\u6709\u5b9a\u4e49\u5b57\u6bb5\uff01");
        }
        for (TableField tableField : tableInfo.getColumns()) {
            if (!Lexer.isLabel((CharSequence)tableField.getColumnName())) {
                return new ImmutablePair((Object)-2, (Object)("\u5b57\u6bb5\u540d" + tableField.getColumnName() + "\u683c\u5f0f\u4e0d\u6b63\u786e\uff01"));
            }
            if (!StringUtils.isBlank((CharSequence)tableField.getColumnType())) continue;
            return new ImmutablePair((Object)-3, (Object)("\u5b57\u6bb5" + tableField.getColumnName() + "\u6ca1\u6709\u6307\u5b9a\u7c7b\u578b\uff01"));
        }
        if (!tableInfo.hasParmaryKey()) {
            return new ImmutablePair((Object)-4, (Object)"\u6ca1\u6709\u5b9a\u4e49\u4e3b\u952e\uff01");
        }
        return new ImmutablePair((Object)0, (Object)"ok\uff01");
    }

    public static final Pair<Integer, String> checkViewWellDefined(TableInfo tableInfo) {
        if (!Lexer.isLabel((CharSequence)tableInfo.getTableName())) {
            return new ImmutablePair((Object)-1, (Object)("\u89c6\u56fe\u540d" + tableInfo.getTableName() + "\u683c\u5f0f\u4e0d\u6b63\u786e\uff01"));
        }
        return new ImmutablePair((Object)0, (Object)"ok\uff01");
    }

    public static final SimpleTableInfo parseDDL(String createSql) {
        SimpleTableInfo tableInfo = new SimpleTableInfo();
        Lexer sql = new Lexer(createSql);
        String aWrod = sql.getAWord();
        while (StringUtils.isNotBlank((CharSequence)aWrod) && !"table".equalsIgnoreCase(aWrod)) {
            aWrod = sql.getAWord();
        }
        aWrod = sql.getAWord();
        aWrod = StringRegularOpt.trimString((String)aWrod);
        tableInfo.setTableName(aWrod);
        aWrod = sql.getAWord();
        while (StringUtils.isNotBlank((CharSequence)aWrod) && !"(".equalsIgnoreCase(aWrod)) {
            aWrod = sql.getAWord();
        }
        aWrod = sql.getAWord();
        while (StringUtils.isNotBlank((CharSequence)aWrod)) {
            SimpleTableField column;
            if ("constraint".equalsIgnoreCase(aWrod) || "primary".equalsIgnoreCase(aWrod) || "key".equalsIgnoreCase(aWrod)) {
                while (StringUtils.isNotBlank((CharSequence)aWrod) && !"(".equalsIgnoreCase(aWrod)) {
                    aWrod = sql.getAWord();
                }
                aWrod = sql.getAWord();
                column = tableInfo.findFieldByColumn(aWrod = StringRegularOpt.trimString((String)aWrod));
                if (column != null) {
                    column.setPrimaryKey(true);
                }
                aWrod = sql.getAWord();
                while (",".equals(aWrod)) {
                    aWrod = sql.getAWord();
                    column = tableInfo.findFieldByColumn(aWrod);
                    if (column != null) {
                        column.setPrimaryKey(true);
                    }
                    aWrod = sql.getAWord();
                }
            } else {
                column = new SimpleTableField();
                aWrod = StringRegularOpt.trimString((String)aWrod);
                column.setColumnName(aWrod);
                aWrod = sql.getAWord();
                column.setColumnType(aWrod);
                aWrod = sql.getAWord();
                while (StringUtils.isNotBlank((CharSequence)aWrod) && !",".equals(aWrod)) {
                    if ("(".equals(aWrod)) {
                        aWrod = sql.getAWord();
                        column.setMaxLength(NumberBaseOpt.castObjectToInteger((Object)aWrod, (Integer)0));
                        aWrod = sql.getAWord();
                        if (",".equals(aWrod)) {
                            aWrod = sql.getAWord();
                            column.setScale(NumberBaseOpt.castObjectToInteger((Object)aWrod, (Integer)0));
                        } else if (!")".equals(aWrod)) {
                            sql.seekToRightBracket();
                        }
                    } else if ("not".equalsIgnoreCase(aWrod)) {
                        aWrod = sql.getAWord();
                        if ("null".equals(aWrod)) {
                            column.setMandatory(true);
                        }
                    } else if ("primary".equalsIgnoreCase(aWrod)) {
                        aWrod = sql.getAWord();
                        if ("key".equals(aWrod = StringRegularOpt.trimString((String)aWrod))) {
                            column.setPrimaryKey(true);
                        }
                    } else if ("comment".equalsIgnoreCase(aWrod)) {
                        aWrod = sql.getAWord();
                        aWrod = StringRegularOpt.trimString((String)aWrod);
                        column.setFieldLabelName(aWrod);
                        column.setColumnComment(aWrod);
                    }
                    aWrod = sql.getAWord();
                }
                tableInfo.addColumn(column);
            }
            while (StringUtils.isNotBlank((CharSequence)aWrod) && !",".equals(aWrod)) {
                aWrod = sql.getAWord();
            }
            aWrod = sql.getAWord();
        }
        return tableInfo;
    }

    public void setConnect(Connection conn) {
        this.conn = conn;
    }

    @Override
    public String makeCreateSequenceSql(String sequenceName) {
        return "INSERT INTO simulate_sequence (seqname, currvalue , increment) VALUES (" + QueryUtils.buildStringForQuery(sequenceName) + ", 0, 1)";
    }

    protected void appendPkSql(TableInfo tableInfo, StringBuilder sbCreate) {
        sbCreate.append("constraint ");
        if (StringUtils.isBlank((CharSequence)tableInfo.getPkName())) {
            sbCreate.append("pk_" + tableInfo.getTableName());
        } else {
            sbCreate.append(tableInfo.getPkName());
        }
        sbCreate.append(" primary key ");
        this.appendPkColumnSql(tableInfo, sbCreate);
    }

    @Override
    public String makeCreateTableSql(TableInfo tableInfo, boolean fieldStartNewLine) {
        StringBuilder sbCreate = new StringBuilder("create table ");
        sbCreate.append(tableInfo.getTableName()).append(" (");
        this.appendColumnsSQL(tableInfo, sbCreate, fieldStartNewLine);
        if (tableInfo.hasParmaryKey()) {
            sbCreate.append(",");
            if (fieldStartNewLine) {
                sbCreate.append("\r\n");
            }
            this.appendPkSql(tableInfo, sbCreate);
        }
        if (fieldStartNewLine) {
            sbCreate.append("\r\n");
        }
        sbCreate.append(")");
        return sbCreate.toString();
    }

    @Override
    public List<String> makeTableColumnComments(TableInfo tableInfo, int commentContent) {
        ArrayList<String> comments = new ArrayList<String>();
        if (tableInfo.getColumns() == null) {
            return comments;
        }
        for (TableField tableField : tableInfo.getColumns()) {
            StringBuilder sbComment = new StringBuilder("COMMENT ON COLUMN ");
            sbComment.append(tableInfo.getTableName()).append(".").append(tableField.getColumnName()).append(" IS ");
            if (commentContent == 1) {
                sbComment.append('\'').append(tableField.getFieldLabelName()).append('\'');
            } else if (commentContent == 2) {
                sbComment.append('\'').append(tableField.getColumnComment()).append('\'');
            } else {
                sbComment.append('\'').append(tableField.getFieldLabelName()).append(':').append(tableField.getColumnComment()).append('\'');
            }
            comments.add(sbComment.toString());
        }
        return comments;
    }

    protected void appendPkColumnSql(TableInfo tableInfo, StringBuilder sbCreate) {
        sbCreate.append("(");
        int i = 0;
        for (TableField tableField : tableInfo.getPkFields()) {
            if (i > 0) {
                sbCreate.append(", ");
            }
            sbCreate.append(tableField.getColumnName());
            ++i;
        }
        sbCreate.append(")");
    }

    protected void appendColumnsSQL(TableInfo tableInfo, StringBuilder sbCreate, boolean fieldStartNewLine) {
        if (tableInfo.getColumns() == null) {
            return;
        }
        boolean first = true;
        for (TableField tableField : tableInfo.getColumns()) {
            if (!first) {
                sbCreate.append(",");
            }
            first = false;
            if (fieldStartNewLine) {
                sbCreate.append("\r\n");
            }
            this.appendColumnSQL(tableField, sbCreate);
            if (!StringUtils.isNotBlank((CharSequence)tableField.getDefaultValue())) continue;
            sbCreate.append(" default ").append(tableField.getDefaultValue());
        }
    }

    protected void appendColumnTypeSQL(TableField field, StringBuilder sbCreate) {
        sbCreate.append(field.getColumnType());
        if ("varchar".equalsIgnoreCase(field.getColumnType()) || "varchar2".equalsIgnoreCase(field.getColumnType())) {
            if (field.getMaxLength() > 0) {
                sbCreate.append("(").append(field.getMaxLength()).append(")");
            } else {
                sbCreate.append("(64)");
            }
        } else if ("number".equalsIgnoreCase(field.getColumnType()) || "decimal".equalsIgnoreCase(field.getColumnType())) {
            if (field.getMaxLength() > 0) {
                sbCreate.append("(").append(field.getMaxLength());
            } else {
                sbCreate.append("(").append(24);
            }
            if (field.getScale() > 0) {
                sbCreate.append(",").append(field.getScale());
            }
            sbCreate.append(")");
        } else if ("char".equalsIgnoreCase(field.getColumnType())) {
            if (field.getMaxLength() > 0) {
                sbCreate.append("(").append(field.getMaxLength()).append(")");
            } else {
                sbCreate.append("(1)");
            }
        }
    }

    protected void appendColumnSQL(TableField field, StringBuilder sbCreate) {
        sbCreate.append("  ").append(field.getColumnName()).append(" ");
        this.appendColumnTypeSQL(field, sbCreate);
        if (field.isMandatory()) {
            sbCreate.append(" not null");
        }
    }

    @Override
    public String makeDropTableSql(String tableCode) {
        return "drop table " + tableCode;
    }

    @Override
    public String makeAddColumnSql(String tableCode, TableField column) {
        StringBuilder sbsql = new StringBuilder("alter table ");
        sbsql.append(tableCode);
        sbsql.append(" add column ");
        this.appendColumnSQL(column, sbsql);
        return sbsql.toString();
    }

    @Override
    public String makeDropColumnSql(String tableCode, String columnCode) {
        return "alter table " + tableCode + " drop COLUMN " + columnCode;
    }

    @Override
    public String makeRenameColumnSql(String tableCode, String columnCode, TableField column) {
        StringBuilder sbsql = new StringBuilder("alter table ");
        sbsql.append(tableCode);
        sbsql.append(" rename COLUMN ");
        sbsql.append(columnCode);
        sbsql.append(" to ");
        sbsql.append(column.getColumnName());
        return sbsql.toString();
    }

    @Override
    public List<String> makeReconfigurationColumnSqls(String tableCode, String columnCode, TableField column) {
        ArrayList<String> sqls = new ArrayList<String>();
        SimpleTableField tempColumn = new SimpleTableField();
        tempColumn.setColumnName(columnCode + "_1");
        sqls.add(this.makeRenameColumnSql(tableCode, columnCode, tempColumn));
        sqls.add(this.makeAddColumnSql(tableCode, column));
        sqls.add("update tableCode set " + column.getColumnName() + " = " + columnCode);
        sqls.add(this.makeDropColumnSql(tableCode, columnCode + "_1"));
        return sqls;
    }

    @Override
    public void createSequence(String sequenceName) throws SQLException {
        DatabaseAccess.doExecuteSql(this.conn, this.makeCreateSequenceSql(sequenceName));
    }

    @Override
    public void createTable(TableInfo tableInfo) throws SQLException {
        DatabaseAccess.doExecuteSql(this.conn, this.makeCreateTableSql(tableInfo));
    }

    @Override
    public void dropTable(String tableCode) throws SQLException {
        DatabaseAccess.doExecuteSql(this.conn, this.makeDropTableSql(tableCode));
    }

    @Override
    public void addColumn(String tableCode, TableField column) throws SQLException {
        DatabaseAccess.doExecuteSql(this.conn, this.makeAddColumnSql(tableCode, column));
    }

    @Override
    public void modifyColumn(String tableCode, TableField oldColumn, TableField column) throws SQLException {
        DatabaseAccess.doExecuteSql(this.conn, this.makeModifyColumnSql(tableCode, oldColumn, column));
    }

    @Override
    public void dropColumn(String tableCode, String columnCode) throws SQLException {
        DatabaseAccess.doExecuteSql(this.conn, this.makeDropColumnSql(tableCode, columnCode));
    }

    @Override
    public void renameColumn(String tableCode, String columnCode, TableField column) throws SQLException {
        DatabaseAccess.doExecuteSql(this.conn, this.makeRenameColumnSql(tableCode, columnCode, column));
    }

    @Override
    public void reconfigurationColumn(String tableCode, String columnCode, TableField column) throws SQLException {
        List<String> sqList = this.makeReconfigurationColumnSqls(tableCode, columnCode, column);
        if (sqList == null) {
            return;
        }
        for (String sql : sqList) {
            DatabaseAccess.doExecuteSql(this.conn, sql);
        }
    }

    @Override
    public String makeCreateViewSql(String selectSql, String viewName) {
        return "create or replace view " + viewName + " as " + selectSql;
    }
}

