/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.ddl;

import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.database.ddl.GeneralDDLOperations;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableInfo;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SqlSvrDDLOperations
extends GeneralDDLOperations {
    public SqlSvrDDLOperations() {
    }

    public SqlSvrDDLOperations(Connection conn) {
        super(conn);
    }

    @Override
    public List<String> makeTableColumnComments(TableInfo tableInfo, int commentContent) {
        return new ArrayList<String>();
    }

    @Override
    public String makeRenameColumnSql(String tableCode, String columnCode, TableField column) {
        return "exec sp_rename ' " + tableCode + "." + columnCode + "','" + column.getColumnName() + "','COLUMN'";
    }

    @Override
    public String makeModifyColumnSql(String tableCode, TableField oldColumn, TableField column) {
        StringBuilder sbsql = new StringBuilder("alter table ");
        sbsql.append(tableCode);
        sbsql.append(" ALTER COLUMN ").append(column.getColumnName()).append(" ");
        if (!(StringUtils.equalsIgnoreCase((CharSequence)oldColumn.getColumnType(), (CharSequence)column.getColumnType()) && GeneralAlgorithm.equals((Object)oldColumn.getMaxLength(), (Object)column.getMaxLength()) && GeneralAlgorithm.equals((Object)oldColumn.getScale(), (Object)column.getScale()))) {
            this.appendColumnTypeSQL(column, sbsql);
        }
        if (oldColumn.isMandatory() != column.isMandatory()) {
            sbsql.append(column.isMandatory() ? " not null" : " null");
        }
        return sbsql.toString();
    }
}

