/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.database.metadata.DatabaseMetadata;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.metadata.SimpleTableReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlSvrMetadata
implements DatabaseMetadata {
    protected static final Logger logger = LoggerFactory.getLogger(SqlSvrMetadata.class);
    private static final String sqlGetTabColumns = "SELECT  a.name, c.name AS typename, a.length , a.xprec, a.xscale, isnullable FROM syscolumns a INNER JOIN sysobjects b ON a.id = b.id INNER JOIN systypes c ON a.xtype = c.xtype WHERE b.xtype = 'U' and b.name = ? ORDER BY a.colorder";
    private static final String sqlPKName = "select a.name,a.object_id, a.parent_object_id ,a.unique_index_id  from sys.key_constraints a , sysobjects b where a.type='PK' and  a.parent_object_id=b.id and b.xtype = 'U' and b.name = ? ";
    private static final String sqlPKColumns = "select a.name from sys.index_columns b join sys.columns a on(a.object_id=b.object_id and a.column_id=b.column_id) where b.object_id=? and b.index_id=? order by b.key_ordinal";
    private static final String sqlFKNames = "select a.name,a.object_id,a.parent_object_id , b.name as tabname from sys.foreign_keys a join sysobjects b ON a.parent_object_id = b.id where referenced_object_id = ? ";
    private static final String sqlFKColumns = "SELECT  a.name, c.name AS typename, a.length , a.xprec, a.xscale, isnullable FROM syscolumns a INNER JOIN sys.foreign_key_columns b ON a.id = b.parent_object_id  and b.parent_column_id=a.colid JOIN systypes c ON a.xtype = c.xtype WHERE b.constraint_object_id=? ORDER BY b.constraint_column_id";
    private String sDBSchema;
    private Connection dbc;

    @Override
    public void setDBConfig(Connection dbc) {
        this.dbc = dbc;
    }

    @Override
    public String getDBSchema() {
        return this.sDBSchema;
    }

    @Override
    public void setDBSchema(String schema) {
        this.sDBSchema = schema;
    }

    @Override
    public SimpleTableInfo getTableMetadata(String tabName) {
        ResultSet rs;
        PreparedStatement pStmt;
        SimpleTableInfo tab = new SimpleTableInfo(tabName);
        int tableId = 0;
        int pkIndId = 0;
        try {
            pStmt = this.dbc.prepareStatement(sqlGetTabColumns);
            try {
                tab.setSchema(this.dbc.getSchema().toUpperCase());
                pStmt.setString(1, tabName);
                rs = pStmt.executeQuery();
                try {
                    while (rs.next()) {
                        SimpleTableField field = new SimpleTableField();
                        field.setColumnName(rs.getString("name"));
                        field.setColumnType(rs.getString("typename"));
                        int l = rs.getInt("length");
                        int p = rs.getInt("xprec");
                        field.setMaxLength(p > 0 ? p : l);
                        field.setScale(rs.getInt("xscale"));
                        field.setNullEnable(rs.getString("isnullable"));
                        field.mapToMetadata();
                        tab.addColumn(field);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
        }
        catch (SQLException e1) {
            logger.error(e1.getLocalizedMessage(), (Throwable)e1);
        }
        if (tab.getColumns().size() == 0) {
            return null;
        }
        try {
            pStmt = this.dbc.prepareStatement(sqlPKName);
            try {
                pStmt.setString(1, tabName);
                rs = pStmt.executeQuery();
                try {
                    if (rs.next()) {
                        tab.setPkName(rs.getString("name"));
                        tableId = rs.getInt("parent_object_id");
                        pkIndId = rs.getInt("unique_index_id");
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
        }
        catch (SQLException e1) {
            logger.error(e1.getLocalizedMessage(), (Throwable)e1);
        }
        try {
            pStmt = this.dbc.prepareStatement(sqlPKColumns);
            try {
                pStmt.setInt(1, tableId);
                pStmt.setInt(2, pkIndId);
                rs = pStmt.executeQuery();
                try {
                    while (rs.next()) {
                        tab.setColumnAsPrimaryKey(rs.getString("name"));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
        }
        catch (SQLException e1) {
            logger.error(e1.getLocalizedMessage(), (Throwable)e1);
        }
        try {
            pStmt = this.dbc.prepareStatement(sqlFKNames);
            try {
                pStmt.setInt(1, tableId);
                rs = pStmt.executeQuery();
                try {
                    while (rs.next()) {
                        SimpleTableReference ref = new SimpleTableReference();
                        ref.setParentTableName(tabName);
                        ref.setTableName(rs.getString("tabname"));
                        ref.setReferenceCode(rs.getString("name"));
                        ref.setObjectId(rs.getInt("object_id"));
                        tab.addReference(ref);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
        }
        catch (SQLException e1) {
            logger.error(e1.getLocalizedMessage(), (Throwable)e1);
        }
        for (SimpleTableReference ref : tab.getReferences()) {
            try {
                PreparedStatement pStmt2 = this.dbc.prepareStatement(sqlFKColumns);
                try {
                    pStmt2.setInt(1, ref.getObjectId());
                    ResultSet rs2 = pStmt2.executeQuery();
                    try {
                        while (rs2.next()) {
                            String columnName = rs2.getString("name");
                            ref.addReferenceColumn(columnName, columnName);
                        }
                    }
                    finally {
                        if (rs2 == null) continue;
                        rs2.close();
                    }
                }
                finally {
                    if (pStmt2 == null) continue;
                    pStmt2.close();
                }
            }
            catch (SQLException e1) {
                logger.error(e1.getLocalizedMessage(), (Throwable)e1);
            }
        }
        return tab;
    }
}

