/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.database.metadata.DatabaseMetadata;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.metadata.SimpleTableReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DB2Metadata
implements DatabaseMetadata {
    protected static final Logger logger = LoggerFactory.getLogger(DB2Metadata.class);
    private static final String sqlGetTabColumns = "select a.name,a.coltype,a.length, a.scale, a.nulls from sysibm.systables b , sysibm.syscolumns a where a.tbcreator= ? and a.tbname= ? and b.name=a.tbname and b.creator=a.tbcreator";
    private static final String sqlPKInfo = "select constname, colname from sysibm.syskeycoluse where tbcreator=? and tbname=? order by colseq";
    private static final String sqlFKInfo = "select tbname, relname, colcount, fkcolnames, pkcolnames from sysibm.sysrels where refkeyname= ?";
    private static final String sqlFKColumn = "select a.name,a.coltype,a.length, a.scale, a.nulls from sysibm.systables b , sysibm.syscolumns a where a.tbcreator= ? and a.tbname= ? and a.name= ? and b.name=a.tbname and b.creator=a.tbcreator";
    private String sDBSchema;
    private Connection dbc;

    @Override
    public void setDBConfig(Connection dbc) {
        this.dbc = dbc;
    }

    @Override
    public String getDBSchema() {
        return this.sDBSchema;
    }

    @Override
    public void setDBSchema(String schema) {
        if (schema != null) {
            this.sDBSchema = schema.toUpperCase();
        }
    }

    @Override
    public SimpleTableInfo getTableMetadata(String tabName) {
        ResultSet rs;
        PreparedStatement pStmt;
        SimpleTableInfo tab = new SimpleTableInfo(tabName);
        try {
            pStmt = this.dbc.prepareStatement(sqlGetTabColumns);
            try {
                pStmt.setString(1, this.sDBSchema);
                pStmt.setString(2, tabName);
                tab.setSchema(this.dbc.getSchema().toUpperCase());
                rs = pStmt.executeQuery();
                try {
                    while (rs.next()) {
                        SimpleTableField field = new SimpleTableField();
                        field.setColumnName(rs.getString("name"));
                        field.setColumnType(rs.getString("coltype"));
                        field.setMaxLength(rs.getInt("length"));
                        field.setScale(rs.getInt("scale"));
                        field.setNullEnable(rs.getString("nulls"));
                        field.mapToMetadata();
                        tab.addColumn(field);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        if (tab.getColumns().size() == 0) {
            return null;
        }
        try {
            pStmt = this.dbc.prepareStatement(sqlPKInfo);
            try {
                pStmt.setString(1, this.sDBSchema);
                pStmt.setString(2, tabName);
                rs = pStmt.executeQuery();
                try {
                    while (rs.next()) {
                        tab.setPkName(rs.getString("constname"));
                        tab.setColumnAsPrimaryKey(rs.getString("colname"));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
        }
        catch (SQLException e1) {
            logger.error(e1.getLocalizedMessage(), (Throwable)e1);
        }
        try {
            pStmt = this.dbc.prepareStatement(sqlFKInfo);
            try {
                pStmt.setString(1, tab.getPkName());
                rs = pStmt.executeQuery();
                try {
                    while (rs.next()) {
                        SimpleTableReference ref = new SimpleTableReference();
                        ref.setParentTableName(tabName);
                        ref.setTableName(rs.getString("tbname"));
                        ref.setReferenceCode(rs.getString("relname"));
                        int nColCount = rs.getInt("colcount");
                        String sFColNames = rs.getString("fkcolnames").trim();
                        String[] p = sFColNames.split("\\s+");
                        String sPColNames = rs.getString("pkcolnames").trim();
                        String[] pK = sPColNames.split("\\s+");
                        if (nColCount != p.length) {
                            System.out.println("\u5916\u952e" + ref.getReferenceCode() + "\u5b57\u6bb5\u5206\u9694\u51fa\u9519\uff01");
                        }
                        for (int i = 0; i < p.length; ++i) {
                            if (i >= pK.length) continue;
                            ref.addReferenceColumn(pK[i], p[i]);
                        }
                        tab.addReference(ref);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
        }
        catch (SQLException e1) {
            logger.error(e1.getLocalizedMessage(), (Throwable)e1);
        }
        return tab;
    }
}

