/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.orm;

import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.compiler.Lexer;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableReference;
import com.centit.support.database.orm.TableMapInfo;
import com.centit.support.database.orm.ValueGenerator;
import com.centit.support.database.utils.FieldType;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JpaMetadata {
    private static final Logger logger = LoggerFactory.getLogger(JpaMetadata.class);
    private static final ConcurrentHashMap<String, TableMapInfo> ORM_JPA_METADATA_CLASSPATH = new ConcurrentHashMap(100);
    private static final ConcurrentHashMap<String, TableMapInfo> ORM_JPA_METADATA_CLASSNAME = new ConcurrentHashMap(100);
    private static final ConcurrentHashMap<String, TableMapInfo> ORM_JPA_METADATA_TABLENAME = new ConcurrentHashMap(100);

    private JpaMetadata() {
        throw new IllegalAccessError("Utility class");
    }

    public static TableMapInfo fetchTableMapInfo(Class<?> type) {
        String className = type.getName();
        TableMapInfo mapInfo = ORM_JPA_METADATA_CLASSPATH.get(className);
        if (mapInfo == null) {
            mapInfo = JpaMetadata.obtainMapInfoFromClass(type);
            if (mapInfo != null) {
                ORM_JPA_METADATA_CLASSPATH.put(className, mapInfo);
                ORM_JPA_METADATA_TABLENAME.put(mapInfo.getTableName(), mapInfo);
                ORM_JPA_METADATA_CLASSNAME.put(className.substring(className.lastIndexOf(".") + 1), mapInfo);
            } else {
                logger.error("\u7c7b\uff1a" + className + "\u4e2d\u6ca1\u6709\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u6620\u5c04\u5173\u7cfb\u4fe1\u606f\u3002");
            }
        }
        return mapInfo;
    }

    public static String translatePropertyNameToColumnName(Class<?> type, String propertyName) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(type);
        if (mapInfo == null) {
            return propertyName;
        }
        SimpleTableField field = mapInfo.findFieldByName(propertyName);
        return field == null ? propertyName : field.getColumnName();
    }

    public static String translatePropertyNameToColumnName(String propertyName, String tableAlias) {
        int n = propertyName.indexOf(46);
        if (n < 0) {
            return propertyName;
        }
        String tableName = propertyName.substring(0, n);
        String fieldName = propertyName.substring(n + 1);
        TableMapInfo mapInfo = ORM_JPA_METADATA_CLASSNAME.get(tableName);
        if (mapInfo == null) {
            mapInfo = ORM_JPA_METADATA_TABLENAME.get(tableName);
        }
        if (mapInfo == null) {
            return propertyName;
        }
        tableName = mapInfo.getTableName();
        SimpleTableField field = mapInfo.findFieldByName(propertyName);
        if (field != null) {
            fieldName = field.getColumnName();
        }
        if (StringUtils.isNotBlank((CharSequence)tableAlias)) {
            return tableAlias + "." + fieldName;
        }
        return tableName + "." + fieldName;
    }

    public static String translatePropertyNameToColumnName(String propertyName) {
        return JpaMetadata.translatePropertyNameToColumnName(propertyName, null);
    }

    private static void obtainField(SimpleTableField column, Class<?> objType, Field field) {
        column.setObjectField(field);
        column.setObjectGetFieldValueFunc(ReflectionOpt.getGetterMethod(objType, field.getType(), (String)field.getName()));
        column.setObjectSetFieldValueFunc(ReflectionOpt.getSetterMethod(objType, field.getType(), (String)field.getName()));
    }

    private static void obtainColumn(SimpleTableField column, Field field) {
        Column colInfo = field.getAnnotation(Column.class);
        column.setColumnName(colInfo.name());
        column.setFieldType(FieldType.mapToFieldType(field.getType()));
        column.setPropertyName(field.getName());
        column.setScale(colInfo.scale());
        column.setMaxLength(colInfo.length());
        if (colInfo.precision() != 0) {
            column.setMaxLength(colInfo.precision());
        }
        column.setObjectField(field);
    }

    private static SimpleTableField obtainColumnFromField(Class<?> objType, Field field) {
        SimpleTableField column = new SimpleTableField();
        JpaMetadata.obtainColumn(column, field);
        JpaMetadata.obtainField(column, objType, field);
        return column;
    }

    public static TableMapInfo obtainMapInfoFromClass(Class<?> objClass) {
        if (!objClass.isAnnotationPresent(Table.class)) {
            return null;
        }
        Table tableInfo = objClass.getAnnotation(Table.class);
        TableMapInfo mapInfo = new TableMapInfo();
        mapInfo.setTableName(tableInfo.name());
        mapInfo.setSchema(tableInfo.schema());
        int nCascade = 0;
        for (Class<?> objType = objClass; nCascade < 5 && objType != Object.class; objType = objType.getSuperclass()) {
            ++nCascade;
            Field[] objFields = objType.getDeclaredFields();
            for (Field field : objFields) {
                Type t;
                ManyToMany manyToMany;
                if (field.isAnnotationPresent(Column.class)) {
                    SimpleTableField column = JpaMetadata.obtainColumnFromField(objType, field);
                    boolean isPK = field.isAnnotationPresent(Id.class);
                    column.setPrimaryKey(isPK);
                    boolean isLazy = false;
                    if (!isPK && field.isAnnotationPresent(Basic.class)) {
                        Basic colBasic = field.getAnnotation(Basic.class);
                        isLazy = colBasic.fetch() == FetchType.LAZY;
                    }
                    column.setLazyFetch(isLazy);
                    mapInfo.addColumn(column);
                    if (field.isAnnotationPresent(ValueGenerator.class)) {
                        ValueGenerator valueGenerator = field.getAnnotation(ValueGenerator.class);
                        mapInfo.addValueGenerator(column.getPropertyName(), valueGenerator);
                    }
                    if (!field.isAnnotationPresent(OrderBy.class)) continue;
                    OrderBy orderBy = field.getAnnotation(OrderBy.class);
                    mapInfo.appendOrderBy(column, orderBy.value());
                    continue;
                }
                if (field.isAnnotationPresent(EmbeddedId.class)) {
                    EmbeddedId embeddedId = field.getAnnotation(EmbeddedId.class);
                    mapInfo.setEmbeddedId(true);
                    mapInfo.setPkName(field.getName());
                    SimpleTableField pkColumn = new SimpleTableField();
                    JpaMetadata.obtainField(pkColumn, objType, field);
                    mapInfo.setEmbeddedIdField(pkColumn);
                    for (Field idField : field.getType().getDeclaredFields()) {
                        if (!idField.isAnnotationPresent(Column.class)) continue;
                        SimpleTableField column = JpaMetadata.obtainColumnFromField(field.getType(), idField);
                        column.setPrimaryKey(true);
                        mapInfo.addColumn(column);
                        if (idField.isAnnotationPresent(ValueGenerator.class)) {
                            ValueGenerator valueGenerator = idField.getAnnotation(ValueGenerator.class);
                            mapInfo.addValueGenerator(column.getPropertyName(), valueGenerator);
                        }
                        if (!idField.isAnnotationPresent(OrderBy.class)) continue;
                        OrderBy orderBy = idField.getAnnotation(OrderBy.class);
                        mapInfo.appendOrderBy(column, orderBy.value());
                    }
                    continue;
                }
                Class targetClass = null;
                if (field.isAnnotationPresent(OneToOne.class)) {
                    OneToOne oneToOne = field.getAnnotation(OneToOne.class);
                    targetClass = oneToOne.targetEntity();
                    if (targetClass.equals(Void.TYPE)) {
                        targetClass = field.getType();
                    }
                } else if (field.isAnnotationPresent(ManyToOne.class)) {
                    ManyToOne manyToOne = field.getAnnotation(ManyToOne.class);
                    targetClass = manyToOne.targetEntity();
                    if (targetClass.equals(Void.TYPE)) {
                        targetClass = field.getType();
                    }
                } else if (field.isAnnotationPresent(OneToMany.class)) {
                    Type t2;
                    OneToMany oneToMany = field.getAnnotation(OneToMany.class);
                    targetClass = oneToMany.targetEntity();
                    if (targetClass.equals(Void.TYPE) && (t2 = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class) {
                        targetClass = (Class)t2;
                    }
                } else if (field.isAnnotationPresent(ManyToMany.class) && (targetClass = (manyToMany = field.getAnnotation(ManyToMany.class)).targetEntity()).equals(Void.TYPE) && (t = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class) {
                    targetClass = (Class)t;
                }
                if (targetClass == null || targetClass.equals(Void.TYPE)) continue;
                SimpleTableReference reference = new SimpleTableReference();
                reference.setTargetEntityType(targetClass);
                boolean haveJoinColumns = false;
                if (field.isAnnotationPresent(JoinColumn.class)) {
                    JoinColumn joinColumn = field.getAnnotation(JoinColumn.class);
                    reference.setReferenceName(field.getName());
                    reference.setReferenceFieldType(field.getType());
                    reference.addReferenceColumn(joinColumn.name(), joinColumn.referencedColumnName());
                    haveJoinColumns = true;
                } else if (field.isAnnotationPresent(JoinColumns.class)) {
                    JoinColumns joinColumns = field.getAnnotation(JoinColumns.class);
                    reference.setReferenceName(field.getName());
                    reference.setReferenceFieldType(field.getType());
                    for (JoinColumn joinColumn : joinColumns.value()) {
                        reference.addReferenceColumn(joinColumn.name(), joinColumn.referencedColumnName());
                    }
                    haveJoinColumns = true;
                }
                if (!haveJoinColumns) continue;
                reference.setObjectField(field);
                reference.setObjectGetFieldValueFunc(ReflectionOpt.getGetterMethod(objType, field.getType(), (String)field.getName()));
                reference.setObjectSetFieldValueFunc(ReflectionOpt.getSetterMethod(objType, field.getType(), (String)field.getName()));
                mapInfo.addReference(reference);
            }
        }
        ORM_JPA_METADATA_CLASSPATH.put(objClass.getName(), mapInfo);
        if (mapInfo.getReferences() != null && mapInfo.getReferences().size() > 0) {
            HashSet<SimpleTableReference> errorRef = new HashSet<SimpleTableReference>(mapInfo.getReferences().size());
            block4: for (SimpleTableReference reference : mapInfo.getReferences()) {
                TableMapInfo refTalbeInfo = JpaMetadata.fetchTableMapInfo(reference.getTargetEntityType());
                if (refTalbeInfo == null) {
                    errorRef.add(reference);
                    continue;
                }
                HashSet<String> keySet = new HashSet<String>(reference.getReferenceColumns().keySet());
                for (String keyName : keySet) {
                    SimpleTableField field = mapInfo.findFieldByName(keyName);
                    SimpleTableField refField = refTalbeInfo.findFieldByName(reference.getReferenceColumns().get(keyName));
                    if (field == null || refField == null) {
                        errorRef.add(reference);
                        continue block4;
                    }
                    if (!keyName.equals(field.getPropertyName())) {
                        reference.getReferenceColumns().remove(keyName);
                    }
                    reference.addReferenceColumn(field.getPropertyName(), refField.getPropertyName());
                }
            }
            if (errorRef.size() > 0) {
                mapInfo.getReferences().removeAll(errorRef);
            }
        }
        return mapInfo;
    }

    public static String translateSqlPropertyToColumn(TableMapInfo mapInfo, String sql, String alias) {
        StringBuilder sqlb = new StringBuilder();
        Lexer lex = new Lexer(sql, 2);
        boolean needTranslate = true;
        int prePos = 0;
        int preWordPos = 0;
        String aWord = lex.getAWord();
        boolean addAlias = StringUtils.isNotBlank((CharSequence)alias);
        if ("[".equals(aWord)) {
            aWord = lex.getAWord();
            while (aWord != null && !"".equals(aWord) && !"|".equals(aWord)) {
                if ("(".equals(aWord)) {
                    lex.seekToRightBracket();
                }
                aWord = lex.getAWord();
            }
        }
        while (aWord != null && !"".equals(aWord)) {
            SimpleTableField col;
            if ("select".equalsIgnoreCase(aWord) || "from".equalsIgnoreCase(aWord)) {
                needTranslate = false;
            } else if ("where".equalsIgnoreCase(aWord)) {
                needTranslate = true;
            }
            if (!needTranslate) {
                preWordPos = lex.getCurrPos();
                aWord = lex.getAWord();
                continue;
            }
            if (":".equals(aWord)) {
                lex.getAWord();
                preWordPos = lex.getCurrPos();
                aWord = lex.getAWord();
            }
            if (Lexer.isLabel((CharSequence)aWord) && (col = mapInfo.findFieldByName(aWord)) != null) {
                if (preWordPos > prePos) {
                    sqlb.append(sql.substring(prePos, preWordPos));
                }
                sqlb.append((String)(addAlias ? " " + alias + "." : " ")).append(col.getColumnName());
                prePos = lex.getCurrPos();
            }
            preWordPos = lex.getCurrPos();
            aWord = lex.getAWord();
        }
        sqlb.append(sql.substring(prePos));
        return sqlb.toString();
    }
}

