/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.service;

import com.centit.search.document.DocumentUtils;
import com.centit.search.service.ESServerConfig;
import com.centit.search.service.Impl.ESIndexer;
import com.centit.search.service.Impl.ESSearcher;
import com.centit.search.service.Impl.PooledRestClientFactory;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.file.PropertiesReader;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.elasticsearch.client.RestHighLevelClient;

public abstract class IndexerSearcherFactory {
    private static ConcurrentHashMap<String, ESIndexer> indexerMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, ESSearcher> searcherMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<ESServerConfig, GenericObjectPool<RestHighLevelClient>> clientPoolMap = new ConcurrentHashMap();

    public static GenericObjectPool<RestHighLevelClient> obtainclientPool(ESServerConfig config, boolean createNew) {
        GenericObjectPool clientPool = clientPoolMap.get(config);
        if (clientPool == null && createNew) {
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            poolConfig.setMaxTotal(100);
            poolConfig.setMinIdle(20);
            clientPool = new GenericObjectPool((PooledObjectFactory)new PooledRestClientFactory(config), poolConfig);
            clientPoolMap.put(config, (GenericObjectPool<RestHighLevelClient>)clientPool);
        }
        return clientPool;
    }

    public static GenericObjectPool<RestHighLevelClient> obtainclientPool(ESServerConfig config) {
        return IndexerSearcherFactory.obtainclientPool(config, true);
    }

    public static ESIndexer obtainIndexer(String indexName) {
        return indexerMap.get(indexName);
    }

    public static ESIndexer obtainIndexer(ESServerConfig config, Class<?> objType) {
        String indexName = DocumentUtils.obtainDocumentIndexName(objType);
        if (StringUtils.isBlank((CharSequence)indexName)) {
            return null;
        }
        ESIndexer index = indexerMap.get(indexName);
        if (index != null) {
            return index;
        }
        ESIndexer indexer = new ESIndexer(IndexerSearcherFactory.obtainclientPool(config), indexName, objType);
        indexerMap.put(indexName, indexer);
        return indexer;
    }

    public static ESSearcher obtainSearcher(String indexName) {
        return searcherMap.get(indexName);
    }

    public static ESSearcher obtainSearcher(ESServerConfig config, Class<?> objType) {
        String indexName = DocumentUtils.obtainDocumentIndexName(objType);
        if (indexName == null) {
            return null;
        }
        ESSearcher search = searcherMap.get(indexName);
        if (search != null) {
            return search;
        }
        ESSearcher searcher = new ESSearcher(config, IndexerSearcherFactory.obtainclientPool(config));
        searcher.initTypeFields(indexName, objType);
        searcher.setHighlightPreTags(new String[]{"<span class='highlight'>"});
        searcher.setHighlightPostTags(new String[]{"</span>"});
        searcherMap.put(indexName, searcher);
        return searcher;
    }

    public static ESServerConfig loadESServerConfigFormProperties(Properties properties) {
        ESServerConfig config = new ESServerConfig();
        config.setServerHostIp(properties.getProperty("elasticsearch.server.ip"));
        config.setServerHostPort(properties.getProperty("elasticsearch.server.port"));
        config.setClusterName(properties.getProperty("elasticsearch.server.cluster"));
        config.setUsername(properties.getProperty("elasticsearch.server.username"));
        config.setPassword(properties.getProperty("elasticsearch.server.password"));
        config.setMinScore(NumberBaseOpt.parseFloat((String)properties.getProperty("elasticsearch.filter.minScore"), (Float)Float.valueOf(0.5f)).floatValue());
        return config;
    }

    public static ESServerConfig loadESServerConfigFormProperties(String propertiesFile) {
        Properties properties = PropertiesReader.getClassPathProperties((String)propertiesFile);
        return IndexerSearcherFactory.loadESServerConfigFormProperties(properties);
    }
}

