/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office;

import com.centit.support.office.commons.SignatureInfo;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.security.BouncyCastleDigest;
import com.itextpdf.text.pdf.security.ExternalDigest;
import com.itextpdf.text.pdf.security.ExternalSignature;
import com.itextpdf.text.pdf.security.MakeSignature;
import com.itextpdf.text.pdf.security.PrivateKeySignature;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PdfSignatureUtil {
    private static final Logger logger = LogManager.getLogger(PdfSignatureUtil.class);

    public static SignatureInfo createSingInfo() {
        return new SignatureInfo();
    }

    public static boolean sign(InputStream srcStream, OutputStream targetStream, SignatureInfo signatureInfo) {
        try {
            ByteArrayOutputStream tempArrayOutputStream = new ByteArrayOutputStream();
            PdfReader reader = new PdfReader(srcStream);
            PdfStamper stamper = PdfStamper.createSignature((PdfReader)reader, (OutputStream)tempArrayOutputStream, (char)'\u0000', null, (boolean)true);
            PdfSignatureAppearance appearance = stamper.getSignatureAppearance();
            appearance.setReason(signatureInfo.getReasonDesc());
            appearance.setLocation(signatureInfo.getLocationDesc());
            appearance.setVisibleSignature(signatureInfo.getSignRect(), signatureInfo.getSignPage(), signatureInfo.getFieldName());
            appearance.setSignatureGraphic(signatureInfo.getSignImage());
            appearance.setCertificationLevel(signatureInfo.getCertificationLevel());
            appearance.setRenderingMode(signatureInfo.getRenderingMode());
            BouncyCastleDigest digest = new BouncyCastleDigest();
            PrivateKeySignature signature = new PrivateKeySignature(signatureInfo.getPk(), signatureInfo.getDigestAlgorithm(), null);
            MakeSignature.signDetached((PdfSignatureAppearance)appearance, (ExternalDigest)digest, (ExternalSignature)signature, (Certificate[])signatureInfo.getChain(), null, null, null, (int)0, (MakeSignature.CryptoStandard)MakeSignature.CryptoStandard.CADES);
            targetStream.write(tempArrayOutputStream.toByteArray());
            targetStream.flush();
            return true;
        }
        catch (DocumentException | IOException | GeneralSecurityException e) {
            logger.error(e.getMessage(), e);
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean sign(String src, String target, SignatureInfo signatureInfo) {
        try (InputStream srcStream = Files.newInputStream(Paths.get(src, new String[0]), new OpenOption[0]);){
            boolean bl;
            block14: {
                OutputStream targetStream = Files.newOutputStream(Paths.get(target, new String[0]), new OpenOption[0]);
                try {
                    bl = PdfSignatureUtil.sign(srcStream, targetStream, signatureInfo);
                    if (targetStream == null) break block14;
                }
                catch (Throwable throwable) {
                    if (targetStream != null) {
                        try {
                            targetStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                targetStream.close();
            }
            return bl;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

