/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public abstract class ImagesToPdf {
    private static final Logger logger = LogManager.getLogger(ImagesToPdf.class);

    public static Image bufferedImageToPdfImage(BufferedImage image) {
        Image image2;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "JPG", outputStream);
            image2 = Image.getInstance((byte[])outputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BadElementException | IOException e) {
                return null;
            }
        }
        outputStream.close();
        return image2;
    }

    public static void bufferedImagesToA4SizePdf(List<BufferedImage> imageList, OutputStream outPdfStram) {
        ArrayList<Image> images = new ArrayList<Image>(imageList.size());
        for (BufferedImage image : imageList) {
            Image img = ImagesToPdf.bufferedImageToPdfImage(image);
            if (img == null) continue;
            images.add(img);
        }
        ImagesToPdf.imagesToA4SizePdf(images, outPdfStram);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void imagesToA4SizePdf(List<Image> imageList, OutputStream outPdfStram) {
        try (Document document = new Document(PageSize.A4, 0.0f, 0.0f, 0.0f, 0.0f);){
            PdfWriter.getInstance((Document)document, (OutputStream)outPdfStram);
            document.open();
            float a4Width = document.getPageSize().getWidth();
            float a4Height = document.getPageSize().getHeight();
            float imageWidth = imageList.get(0).getWidth();
            float imageHeight = imageList.get(0).getHeight();
            int rowTotalCount = (int)(a4Width / imageWidth);
            int totalRowCount = (int)(a4Height / imageHeight);
            int columnCount = 0;
            int rowCount = 1;
            for (int i = 0; i < imageList.size(); ++i) {
                Image image = imageList.get(i);
                image.setAlignment(1);
                if (columnCount >= rowTotalCount) {
                    ++rowCount;
                    columnCount = 0;
                }
                if (totalRowCount == 1 || rowCount > totalRowCount) {
                    document.setPageSize(new Rectangle(a4Width, a4Height));
                    document.newPage();
                    rowCount = 1;
                    columnCount = 0;
                }
                float xBlankTotalWidth = a4Width - imageWidth * (float)rowTotalCount;
                float xBlankWidth = xBlankTotalWidth / (float)(rowTotalCount + 1);
                float x = columnCount > 0 ? xBlankWidth * (float)(columnCount + 1) + imageWidth * (float)columnCount++ : xBlankWidth + imageWidth * (float)columnCount++;
                float yBlankTotalHeight = a4Height - imageHeight * (float)totalRowCount;
                float yBlankHeight = yBlankTotalHeight / (float)(totalRowCount + 1);
                float y = a4Height - imageHeight * (float)rowCount - yBlankHeight * (float)rowCount;
                image.setAbsolutePosition(x, y);
                document.add((Element)image);
            }
        }
    }

    private static PDImageXObject convertToPDImageXObject(PDDocument document, BufferedImage image, String format, String imageName) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (!ImageIO.write((RenderedImage)image, format, baos)) {
            throw new IOException("\u65e0\u6cd5\u7f16\u7801\u56fe\u50cf\uff0c\u8bf7\u68c0\u67e5\u652f\u6301\u7684\u683c\u5f0f\uff1a" + format);
        }
        byte[] imageData = baos.toByteArray();
        return PDImageXObject.createFromByteArray((PDDocument)document, (byte[])imageData, (String)imageName);
    }

    public static boolean imagesToPdf(List<BufferedImage> imageList, OutputStream outPdfStream, float zoom) {
        boolean bl;
        PDDocument doc = new PDDocument();
        try {
            int pageNumber = 0;
            for (BufferedImage imgFile : imageList) {
                PDImageXObject pdImage = ImagesToPdf.convertToPDImageXObject(doc, imgFile, "PNG", "ODF-image-" + pageNumber + ".png");
                ++pageNumber;
                float width = (float)imgFile.getWidth() * zoom;
                float height = (float)imgFile.getHeight() * zoom;
                PDPage page = new PDPage(new PDRectangle(width, height));
                doc.addPage(page);
                try (PDPageContentStream contentStream = new PDPageContentStream(doc, page);){
                    contentStream.drawImage(pdImage, 0.0f, 0.0f, width, height);
                }
            }
            doc.save(outPdfStream);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    doc.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.error(e.getMessage());
                return false;
            }
        }
        doc.close();
        return bl;
    }
}

