/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.quartz;

import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.quartz.AbstractQuartzJob;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class CallProcessJob
extends AbstractQuartzJob {
    private String command;
    private Map<String, Object> envp;
    private String dir;

    @Override
    protected void loadExecutionContext(JobExecutionContext context) {
        JobDataMap paramMap = context.getMergedJobDataMap();
        this.command = paramMap.getString("command");
        Object obj = paramMap.get((Object)"envp");
        this.envp = obj != null ? (Map<Object, Object>)GeneralAlgorithm.castObjectToType((Object)obj, Map.class) : new HashMap<String, Object>(1);
    }

    @Override
    protected boolean runRealJob(JobExecutionContext context) throws JobExecutionException {
        boolean ret = true;
        try {
            if (this.envp == null || this.envp.isEmpty()) {
                if (StringUtils.isBlank((CharSequence)this.dir)) {
                    Runtime.getRuntime().exec(this.command);
                } else {
                    Runtime.getRuntime().exec(this.command, new String[0], new File(this.dir));
                }
            } else {
                ArrayList<String> envp = new ArrayList<String>(this.envp.size() + 1);
                for (Map.Entry<String, Object> ent : this.envp.entrySet()) {
                    envp.add(ent.getKey() + "=" + StringBaseOpt.castObjectToString((Object)ent.getValue()));
                }
                if (StringUtils.isBlank((CharSequence)this.dir)) {
                    Runtime.getRuntime().exec(this.command, envp.toArray(new String[envp.size()]));
                } else {
                    Runtime.getRuntime().exec(this.command, envp.toArray(new String[envp.size()]), new File(this.dir));
                }
            }
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            ret = false;
        }
        return ret;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setEnvp(Map<String, Object> envp) {
        this.envp = envp;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }
}

