/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.json;

import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.compiler.Pretreatment;
import com.centit.support.compiler.VariableFormula;
import com.centit.support.compiler.VariableTranslate;
import com.centit.support.json.JSONTransformDataSupport;
import java.util.ArrayList;
import java.util.List;

public class DefaultJSONTransformDataSupport
implements VariableTranslate,
JSONTransformDataSupport {
    private Object data;
    private int stackLength;
    private List<StackData> stack;

    public DefaultJSONTransformDataSupport(Object obj) {
        this.data = obj;
        this.stackLength = 0;
        this.stack = new ArrayList<StackData>(10);
    }

    private Object getTopStackData() {
        return this.stack.get((int)(this.stackLength - 1)).data;
    }

    private Object peekStackValue() {
        return this.stackLength > 1 ? this.stack.get((int)(this.stackLength - 2)).data : null;
    }

    private StackData getTopStack() {
        return this.stack.get(this.stackLength - 1);
    }

    @Override
    public Object attainExpressionValue(String expression) {
        if (expression == null) {
            return null;
        }
        VariableFormula variableFormula = new VariableFormula();
        variableFormula.setTrans(this);
        variableFormula.setFormula(expression);
        return variableFormula.calcFormula();
    }

    @Override
    public Object getVarValue(String labelName) {
        if (labelName.startsWith("/")) {
            return ReflectionOpt.attainExpressionValue(this.data, labelName.substring(1));
        }
        if (labelName.startsWith("..")) {
            return ReflectionOpt.attainExpressionValue(this.peekStackValue(), labelName.substring(2));
        }
        if (labelName.startsWith(".")) {
            return ReflectionOpt.attainExpressionValue(this.currentValue(), labelName.substring(1));
        }
        if (this.stackLength > 0) {
            if ("__row_index".equals(labelName)) {
                return this.getTopStack().index;
            }
            if ("__row_count".equals(labelName)) {
                return this.getTopStack().count;
            }
        }
        return ReflectionOpt.attainExpressionValue(this.currentValue(), labelName);
    }

    @Override
    public String mapTemplateString(String templateString) {
        return Pretreatment.mapTemplateStringAsFormula(templateString, this);
    }

    private Object currentValue() {
        return this.stackLength > 0 ? this.getTopStackData() : this.data;
    }

    @Override
    public void pushStackValue(Object value, int rowIndex, int rowCount) {
        if (this.stack.size() > this.stackLength) {
            this.stack.set(this.stackLength, new StackData(value, rowIndex, rowCount));
        } else {
            this.stack.add(new StackData(value, rowIndex, rowCount));
        }
        ++this.stackLength;
    }

    @Override
    public Object popStackValue() {
        Object obj;
        Object object = obj = this.stackLength > 0 ? this.getTopStackData() : null;
        if (this.stackLength > 0) {
            --this.stackLength;
        }
        return obj;
    }

    static class StackData {
        Object data;
        int index;
        int count;

        public StackData(Object data, int index, int count) {
            this.data = data;
            this.index = index;
            this.count = count;
        }
    }
}

