/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.security;

import com.centit.support.common.ObjectException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.KeySpec;
import java.util.Locale;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.x509.CertificateFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;

public abstract class SM2Util {
    public static final String CRYPTO_NAME_SM2 = "sm2p256v1";

    public static String obtainPublicKey(String certStr) {
        try {
            CertificateFactory factory = new CertificateFactory();
            X509Certificate certificate = (X509Certificate)factory.engineGenerateCertificate((InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)certStr)));
            String publicKeyStr = Hex.toHexString((byte[])certificate.getPublicKey().getEncoded());
            return publicKeyStr.length() > 130 ? publicKeyStr.substring(publicKeyStr.length() - 130) : publicKeyStr;
        }
        catch (Exception e) {
            throw new ObjectException(611, "\u8bc1\u4e66\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8bc1\u4e66\u683c\u5f0f\uff01", (Throwable)e);
        }
    }

    public static byte[] encryptUsePublicKey(byte[] data, String publicKey) {
        if (publicKey.length() == 128) {
            publicKey = "04" + publicKey;
        } else if (publicKey.length() > 500) {
            publicKey = SM2Util.obtainPublicKey(publicKey);
        }
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        ECPoint pukPoint = sm2ECParameters.getCurve().decodePoint(Hex.decode((String)publicKey));
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);
        SM2Engine sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)publicKeyParameters, new SecureRandom()));
        try {
            return sm2Engine.processBlock(data, 0, data.length);
        }
        catch (Exception e) {
            System.out.println("SM2\u516c\u94a5\u52a0\u5bc6\u65f6\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
            return null;
        }
    }

    public static byte[] decryptUserPrivateKey(byte[] cipherDataByte, String privateKey) {
        BigInteger privateKeyD = new BigInteger(privateKey, 16);
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyD, domainParameters);
        SM2Engine sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
        sm2Engine.init(false, (CipherParameters)privateKeyParameters);
        try {
            return sm2Engine.processBlock(cipherDataByte, 0, cipherDataByte.length);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("SM2\u79c1\u94a5\u89e3\u5bc6\u65f6\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
            return null;
        }
    }

    public static Pair<String, String> generateKey(boolean compressed) {
        try {
            ECGenParameterSpec sm2Spec = new ECGenParameterSpec(CRYPTO_NAME_SM2);
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", (Provider)new BouncyCastleProvider());
            kpg.initialize(sm2Spec);
            KeyPair keyPair = kpg.generateKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            BCECPublicKey p = (BCECPublicKey)publicKey;
            PrivateKey privateKey = keyPair.getPrivate();
            BCECPrivateKey s = (BCECPrivateKey)privateKey;
            return Pair.of((Object)Hex.toHexString((byte[])p.getQ().getEncoded(compressed)), (Object)Hex.toHexString((byte[])s.getD().toByteArray()));
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            return Pair.of((Object)"error", (Object)e.getMessage());
        }
    }

    public static Pair<String, String> generateSm2Keys(boolean compressed) {
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        keyPairGenerator.init((KeyGenerationParameters)new ECKeyGenerationParameters(domainParameters, new SecureRandom()));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = keyPairGenerator.generateKeyPair();
        ECPublicKeyParameters publicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        ECPoint ecPoint = publicKeyParameters.getQ();
        String publicKey = Hex.toHexString((byte[])ecPoint.getEncoded(compressed)).toUpperCase(Locale.ROOT);
        ECPrivateKeyParameters privateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        BigInteger intPrivateKey = privateKeyParameters.getD();
        String privateKey = intPrivateKey.toString(16).toUpperCase(Locale.ROOT);
        return Pair.of((Object)publicKey, (Object)privateKey);
    }

    public static byte[] sign(byte[] data, String priKey) {
        try {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
            ECParameterSpec ecParameterSpec = new ECParameterSpec(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN(), sm2ECParameters.getH());
            KeyFactory keyFactory = KeyFactory.getInstance("EC", (Provider)provider);
            Signature signature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)provider);
            BigInteger bigInteger = new BigInteger(priKey, 16);
            BCECPrivateKey bcecPrivateKey = (BCECPrivateKey)keyFactory.generatePrivate((KeySpec)new ECPrivateKeySpec(bigInteger, ecParameterSpec));
            signature.initSign((PrivateKey)bcecPrivateKey);
            signature.update(data);
            return signature.sign();
        }
        catch (Exception e) {
            throw new ObjectException(e);
        }
    }

    public static boolean verify(byte[] data, String pubKey, byte[] signatureValue) {
        if (pubKey.length() == 128) {
            pubKey = "04" + pubKey;
        }
        try {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
            ECParameterSpec ecParameterSpec = new ECParameterSpec(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN(), sm2ECParameters.getH());
            KeyFactory keyFactory = KeyFactory.getInstance("EC", (Provider)provider);
            Signature signature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)provider);
            ECPoint ecPoint = sm2ECParameters.getCurve().decodePoint(Hex.decode((String)pubKey));
            BCECPublicKey bcecPublicKey = (BCECPublicKey)keyFactory.generatePublic((KeySpec)new ECPublicKeySpec(ecPoint, ecParameterSpec));
            signature.initVerify((PublicKey)bcecPublicKey);
            signature.update(data);
            return signature.verify(signatureValue);
        }
        catch (Exception e) {
            throw new ObjectException(e);
        }
    }

    public static boolean certVerify(byte[] data, String certStr, String signValueStr) {
        try {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            byte[] signValue = Hex.decode((String)signValueStr);
            CertificateFactory factory = new CertificateFactory();
            X509Certificate certificate = (X509Certificate)factory.engineGenerateCertificate((InputStream)new ByteArrayInputStream(Hex.decode((String)certStr)));
            Signature signature = Signature.getInstance(certificate.getSigAlgName(), (Provider)provider);
            signature.initVerify(certificate);
            signature.update(data);
            return signature.verify(signValue);
        }
        catch (Exception e) {
            throw new ObjectException(e);
        }
    }

    public static byte[] toAniBytes(byte[] ansiBytes) throws IOException {
        byte[] source = new byte[32];
        System.arraycopy(ansiBytes, 1, source, 0, 32);
        ASN1Integer x = new ASN1Integer(source);
        System.arraycopy(ansiBytes, 33, source, 0, 32);
        ASN1Integer y = new ASN1Integer(source);
        System.arraycopy(ansiBytes, 65, source, 0, 32);
        DEROctetString derDig = new DEROctetString(source);
        int mwlen = ansiBytes.length - 97;
        byte[] mw = new byte[mwlen];
        System.arraycopy(ansiBytes, 97, mw, 0, mwlen);
        DEROctetString derEnc = new DEROctetString(mw);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)x);
        v.add((ASN1Encodable)y);
        v.add((ASN1Encodable)derDig);
        v.add((ASN1Encodable)derEnc);
        DERSequence seq = new DERSequence(v);
        return seq.getEncoded();
    }

    /*
     * Exception decompiling
     */
    public static byte[] obtainAniBytes(byte[] ansiBytes) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

