/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.extend;

import com.alibaba.fastjson2.JSONArray;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRuntimeContext {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractRuntimeContext.class);
    private ScriptEngine scriptEngine;

    public AbstractRuntimeContext(String engineName) {
        ScriptEngineManager sem = new ScriptEngineManager();
        this.scriptEngine = sem.getEngineByName(engineName);
    }

    public AbstractRuntimeContext compileScript(String js) {
        try {
            this.scriptEngine.eval(js);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return this;
    }

    public AbstractRuntimeContext compileScriptFile(String jsFileName) {
        try {
            FileReader reader = new FileReader(jsFileName);
            this.scriptEngine.eval(reader);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return this;
    }

    public AbstractRuntimeContext compileScriptStream(InputStream is) {
        try {
            InputStreamReader reader = new InputStreamReader(is);
            this.scriptEngine.eval(reader);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return this;
    }

    public static Object checkArrayObject(Object object) {
        if (object instanceof Map) {
            Map objMap = (Map)object;
            JSONArray objArray = new JSONArray();
            HashMap despMap = new HashMap();
            boolean isArray = true;
            for (Map.Entry ent : objMap.entrySet()) {
                Object key = ent.getKey();
                if (key == null) continue;
                if (isArray) {
                    if (StringUtils.isNumeric((CharSequence)key.toString())) {
                        objArray.add(AbstractRuntimeContext.checkArrayObject(ent.getValue()));
                    } else {
                        isArray = false;
                    }
                }
                despMap.put(key, AbstractRuntimeContext.checkArrayObject(ent.getValue()));
            }
            if (isArray && !objArray.isEmpty()) {
                return objArray;
            }
            return despMap;
        }
        return object;
    }

    public Object callFunc(String funcName, Object ... args) throws ScriptException, NoSuchMethodException {
        Invocable invocable = (Invocable)((Object)this.scriptEngine);
        return AbstractRuntimeContext.checkArrayObject(invocable.invokeFunction(funcName, args));
    }

    public Object getObject(String objName) {
        return this.scriptEngine.get(objName);
    }

    public Object getObjectProperty(String objName, String propertyName) throws ScriptException {
        return AbstractRuntimeContext.checkArrayObject(this.scriptEngine.eval(objName + "." + propertyName));
    }

    public Object callObjectMethod(Object jsObject, String methodName, Object ... args) throws ScriptException, NoSuchMethodException {
        Invocable invocable = (Invocable)((Object)this.scriptEngine);
        return AbstractRuntimeContext.checkArrayObject(invocable.invokeMethod(jsObject, methodName, args));
    }
}

