/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.security;

import com.centit.support.security.AESSecurityUtils;
import com.centit.support.security.SM4Util;
import com.centit.support.security.SecurityOptUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class FileEncryptUtils {
    private FileEncryptUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static void encrypt(String sourceFileName, String diminationFileName, String algorithm, String keyValue) throws IOException, GeneralSecurityException {
        FileEncryptUtils.encrypt(new File(sourceFileName), new File(diminationFileName), algorithm, keyValue);
    }

    public static void encrypt(InputStream sourceFile, OutputStream diminationFile, String algorithm, String keyValue) throws IOException, GeneralSecurityException {
        Cipher cipher;
        switch (algorithm) {
            case "SM4": {
                cipher = SM4Util.generateEcbCipher("SM4/ECB/PKCS5Padding", 1, StringUtils.isBlank((CharSequence)keyValue) ? "qbh07dTZ$sO7_wC1".getBytes(StandardCharsets.UTF_8) : keyValue.getBytes(StandardCharsets.UTF_8));
                break;
            }
            case "AES_CBC": {
                Pair<byte[], byte[]> key = SecurityOptUtils.makeCbcKey(keyValue, "AES");
                cipher = AESSecurityUtils.createCbcEncryptCipher((byte[])key.getLeft(), (byte[])key.getRight());
                break;
            }
            case "SM4_CBC": {
                Pair<byte[], byte[]> key = SecurityOptUtils.makeCbcKey(keyValue, "SM4");
                cipher = SM4Util.generateCbcCipher("SM4/CBC/PKCS5Padding", 1, (byte[])key.getLeft(), (byte[])key.getRight());
                break;
            }
            default: {
                cipher = AESSecurityUtils.createEncryptCipher(StringUtils.isBlank((CharSequence)keyValue) ? "U2FsdGVkX1BymlPj" : keyValue);
            }
        }
        try (CipherInputStream cis = new CipherInputStream(sourceFile, cipher);){
            int r;
            byte[] buffer = new byte[1024];
            while ((r = cis.read(buffer)) > 0) {
                diminationFile.write(buffer, 0, r);
            }
        }
    }

    public static void encrypt(File sourceFile, File diminationFile, String algorithm, String keyValue) throws IOException, GeneralSecurityException {
        try (FileInputStream is = new FileInputStream(sourceFile);
             FileOutputStream out = new FileOutputStream(diminationFile);){
            FileEncryptUtils.encrypt(is, out, algorithm, keyValue);
        }
    }

    public static void decrypt(String sourceFileName, String diminationFileName, String algorithm, String keyValue) throws IOException, GeneralSecurityException {
        FileEncryptUtils.decrypt(new File(sourceFileName), new File(diminationFileName), algorithm, keyValue);
    }

    public static void decrypt(InputStream sourceFile, OutputStream diminationFile, String algorithm, String keyValue) throws IOException, GeneralSecurityException {
        Cipher cipher;
        switch (algorithm) {
            case "SM4": {
                cipher = SM4Util.generateEcbCipher("SM4/ECB/PKCS5Padding", 2, StringUtils.isBlank((CharSequence)keyValue) ? "qbh07dTZ$sO7_wC1".getBytes(StandardCharsets.UTF_8) : keyValue.getBytes(StandardCharsets.UTF_8));
                break;
            }
            case "AES_CBC": {
                Pair<byte[], byte[]> key = SecurityOptUtils.makeCbcKey(keyValue, "AES");
                cipher = AESSecurityUtils.createCbcDencryptCipher((byte[])key.getLeft(), (byte[])key.getRight());
                break;
            }
            case "SM4_CBC": {
                Pair<byte[], byte[]> key = SecurityOptUtils.makeCbcKey(keyValue, "SM4");
                cipher = SM4Util.generateCbcCipher("SM4/CBC/PKCS5Padding", 2, (byte[])key.getLeft(), (byte[])key.getRight());
                break;
            }
            default: {
                cipher = AESSecurityUtils.createDencryptCipher(StringUtils.isBlank((CharSequence)keyValue) ? "U2FsdGVkX1BymlPj" : keyValue);
            }
        }
        try (CipherOutputStream cos = new CipherOutputStream(diminationFile, cipher);){
            int r;
            byte[] buffer = new byte[1024];
            while ((r = sourceFile.read(buffer)) >= 0) {
                cos.write(buffer, 0, r);
            }
        }
    }

    public static void decrypt(File sourceFile, File diminationFile, String algorithm, String keyValue) throws IOException, GeneralSecurityException {
        try (FileInputStream is = new FileInputStream(sourceFile);
             FileOutputStream out = new FileOutputStream(diminationFile);){
            FileEncryptUtils.decrypt(is, out, algorithm, keyValue);
        }
    }
}

