/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.file;

import com.alibaba.fastjson2.JSON;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileIOOpt {
    protected static final Logger logger = LoggerFactory.getLogger(FileIOOpt.class);

    private FileIOOpt() {
        throw new IllegalAccessError("Utility class");
    }

    public static int writeInputStreamToOutputStream(InputStream in, OutputStream out) throws IOException {
        int read = 0;
        int length = 0;
        byte[] bytes = new byte[10240];
        while ((read = in.read(bytes)) != -1) {
            out.write(bytes, 0, read);
            length += read;
        }
        return length;
    }

    public static int writeInputStreamToFile(InputStream in, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file, false);){
            int n = FileIOOpt.writeInputStreamToOutputStream(in, out);
            return n;
        }
    }

    public static int writeInputStreamToFile(InputStream in, String filePath) throws IOException {
        return FileIOOpt.writeInputStreamToFile(in, new File(filePath));
    }

    public static int appendInputStreamToFile(InputStream in, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file, true);){
            int n = FileIOOpt.writeInputStreamToOutputStream(in, out);
            return n;
        }
    }

    public static int appendInputStreamToFile(InputStream in, String filePath) throws IOException {
        return FileIOOpt.appendInputStreamToFile(in, new File(filePath));
    }

    public static void writeStringToOutputStream(String strData, OutputStream io) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(io);){
            writer.write(strData);
        }
    }

    public static void writeStringToFile(String strData, File file) throws IOException {
        try (FileWriter writer = new FileWriter(file, false);){
            writer.write(strData);
        }
    }

    public static void writeStringToFile(String strData, String fileName) throws IOException {
        FileIOOpt.writeStringToFile(strData, new File(fileName));
    }

    public static void appendStringToFile(String strData, File file) throws IOException {
        try (FileWriter writer = new FileWriter(file, true);){
            writer.write(strData);
        }
    }

    public static void appendStringToFile(String strData, String fileName) throws IOException {
        FileIOOpt.appendStringToFile(strData, new File(fileName));
    }

    public static String readStringFromRead(Reader reader) throws IOException {
        try (StringWriter writer = new StringWriter();){
            int len;
            char[] buf = new char[1024];
            while ((len = reader.read(buf)) != -1) {
                writer.write(buf, 0, len);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static byte[] readBytesFromInputStream(InputStream is) throws IOException {
        int len = is.available();
        if (len > 0) {
            return FileIOOpt.readBytesFromInputStream(is, len);
        }
        return FileIOOpt.readBytesFromInputStream(is, 0x2000000);
    }

    public static byte[] readBytesFromInputStream(InputStream is, int length) throws IOException {
        int nStep;
        int readed;
        int len;
        byte[] buf = new byte[length];
        for (readed = 0; readed < length && (len = is.read(buf, readed, nStep = length - readed > 65536 ? 65536 : length - readed)) >= 0; readed += len) {
        }
        if (readed < 1) {
            return null;
        }
        if (readed < length) {
            byte[] buffer = new byte[readed];
            System.arraycopy(buf, 0, buffer, 0, readed);
            return buffer;
        }
        return buf;
    }

    public static byte[] readBytesFromFile(File file, int length) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] byArray = FileIOOpt.readBytesFromInputStream(fis, length);
            return byArray;
        }
    }

    public static byte[] readBytesFromFile(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] byArray = FileIOOpt.readBytesFromInputStream(fis, (int)file.length());
            return byArray;
        }
    }

    public static byte[] readBytesFromFile(String filePath, int length) throws IOException {
        return FileIOOpt.readBytesFromFile(new File(filePath), length);
    }

    public static byte[] readBytesFromFile(String filePath) throws IOException {
        return FileIOOpt.readBytesFromFile(new File(filePath));
    }

    public static String readStringFromInputStream(InputStream is, String charsetName) throws IOException {
        return FileIOOpt.readStringFromRead(new InputStreamReader(is, charsetName));
    }

    public static String readStringFromInputStream(InputStream is) throws IOException {
        return FileIOOpt.readStringFromRead(new InputStreamReader(is));
    }

    public static String readStringFromFile(File file, String charsetName) throws IOException {
        return FileIOOpt.readStringFromRead(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
    }

    public static String readStringFromFile(File file) throws IOException {
        return FileIOOpt.readStringFromRead(new InputStreamReader(new FileInputStream(file)));
    }

    public static String readStringFromFile(String fileName, String charsetName) throws IOException {
        return FileIOOpt.readStringFromFile(new File(fileName), charsetName);
    }

    public static String readStringFromFile(String fileName) throws IOException {
        return FileIOOpt.readStringFromFile(new File(fileName));
    }

    public static void writeObjectToFile(Object obj, String fileName) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(fileName, false));){
            oos.writeObject(obj);
        }
    }

    public static Object readObjectFromFile(String fileName) throws IOException, ClassNotFoundException {
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(fileName));){
            Object object = ois.readObject();
            return object;
        }
    }

    public static void writeObjectAsJsonToFile(Object obj, String fileName) throws IOException {
        String sjson = JSON.toJSONString((Object)obj);
        FileIOOpt.writeStringToFile(sjson, fileName);
    }

    public static void writeBytesToFile(byte[] bytes, String fileName) throws IOException {
        FileIOOpt.writeBytesToFile(bytes, new File(fileName));
    }

    public static void writeBytesToFile(byte[] bytes, File file) throws IOException {
        try (FileOutputStream writer = new FileOutputStream(file, false);){
            writer.write(bytes);
        }
    }

    public static void appendBytesToFile(byte[] bytes, File file) throws IOException {
        try (FileOutputStream writer = new FileOutputStream(file, true);){
            writer.write(bytes);
        }
    }

    public static void appendBytesToFile(byte[] bytes, String fileName) throws IOException {
        FileIOOpt.appendBytesToFile(bytes, new File(fileName));
    }

    public static <T> T readObjectAsJsonFromFile(String fileName, Class<T> clazz) throws IOException {
        String sjson = FileIOOpt.readStringFromFile(fileName);
        return (T)JSON.parseObject((String)sjson, clazz);
    }

    public static InputStream castObjectToInputStream(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof ByteArrayInputStream) {
            ByteArrayInputStream inputStream = (ByteArrayInputStream)data;
            inputStream.reset();
            return inputStream;
        }
        if (data instanceof InputStream) {
            return (InputStream)data;
        }
        if (data instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream outputStream = (ByteArrayOutputStream)data;
            return new ByteArrayInputStream(outputStream.toByteArray());
        }
        if (data instanceof byte[]) {
            return new ByteArrayInputStream((byte[])data);
        }
        if (data instanceof String) {
            return new ByteArrayInputStream(((String)data).getBytes(StandardCharsets.UTF_8));
        }
        String dataStr = JSON.toJSONString((Object)data);
        return new ByteArrayInputStream(dataStr.getBytes(StandardCharsets.UTF_8));
    }

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

