/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.image;

import com.centit.support.image.ImageOpt;
import com.centit.support.image.QrCodeConfig;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public abstract class QrCodeGenerator {
    private static final int QUIET_ZONE_SIZE = 4;

    public static void insertLogo(BufferedImage qrCode, BufferedImage logImage) {
        if (logImage == null) {
            return;
        }
        int qrcodeWidth = qrCode.getWidth();
        int qrcodeHeight = qrCode.getHeight();
        int size = logImage.getWidth() > qrcodeWidth / 5 ? qrcodeWidth / 25 : logImage.getWidth() / 5;
        logImage = ImageOpt.makeRoundBorder(logImage, 60, size, Color.WHITE);
        int w = logImage.getWidth() > qrcodeWidth / 5 ? qrcodeWidth / 5 : logImage.getWidth();
        int h = logImage.getHeight() > qrcodeHeight / 5 ? qrcodeHeight / 5 : logImage.getHeight();
        Graphics2D graph = qrCode.createGraphics();
        int x = (qrcodeWidth - w) / 2;
        int y = (qrcodeHeight - h) / 2;
        graph.drawImage(logImage, x, y, w, h, null);
        graph.dispose();
        qrCode.flush();
    }

    private static BufferedImage toBufferedImage(QrCodeConfig qrCodeConfig, BitMatrix bitMatrix) {
        int qrCodeWidth = bitMatrix.getWidth();
        int qrCodeHeight = bitMatrix.getHeight();
        BufferedImage qrCode = new BufferedImage(qrCodeWidth, qrCodeHeight, 1);
        for (int x = 0; x < qrCodeWidth; ++x) {
            for (int y = 0; y < qrCodeHeight; ++y) {
                qrCode.setRGB(x, y, bitMatrix.get(x, y) ? qrCodeConfig.getOnColor() : qrCodeConfig.getOffColor());
            }
        }
        if (qrCodeConfig.getLogoImage() != null) {
            QrCodeGenerator.insertLogo(qrCode, qrCodeConfig.getLogoImage());
        }
        if (StringUtils.isNotBlank((CharSequence)qrCodeConfig.getTopText()) || StringUtils.isNotBlank((CharSequence)qrCodeConfig.getDownText())) {
            qrCode = QrCodeGenerator.addTextInfo(qrCode, qrCodeConfig);
        }
        return qrCode;
    }

    private static BufferedImage addTextInfo(BufferedImage source, QrCodeConfig qrCodeConfig) {
        Graphics2D graphics = (Graphics2D)source.getGraphics();
        String topText = qrCodeConfig.getTopText();
        String downText = qrCodeConfig.getDownText();
        double topTextHeight = 0.0;
        double topTextWidth = 0.0;
        double downTextWidth = 0.0;
        double downTextHeight = 0.0;
        Font topTextFont = null;
        Font downTextFont = null;
        if (StringUtils.isNotBlank((CharSequence)topText)) {
            topTextFont = new Font(qrCodeConfig.getTopTextFontType(), 1, qrCodeConfig.getTopTextFontSize());
            graphics.setFont(topTextFont);
            Rectangle2D stringBounds = topTextFont.getStringBounds(topText, graphics.getFontRenderContext());
            topTextHeight = stringBounds.getHeight();
            topTextWidth = stringBounds.getWidth();
        }
        if (StringUtils.isNotBlank((CharSequence)downText)) {
            downTextFont = new Font(qrCodeConfig.getDownTextFontType(), 1, qrCodeConfig.getDownTextFontSize());
            graphics.setFont(downTextFont);
            Rectangle2D downTextStringBounds = downTextFont.getStringBounds(downText, graphics.getFontRenderContext());
            downTextWidth = downTextStringBounds.getWidth();
            downTextHeight = downTextStringBounds.getHeight();
        }
        double offSetHeight = topTextHeight > 0.0 && downTextHeight > 0.0 ? (topTextHeight + downTextHeight) * 2.0 : (topTextHeight + downTextHeight) * 4.0;
        int newHeight = (int)((double)source.getHeight() + offSetHeight);
        int newQrWidth = (int)((double)source.getWidth() + offSetHeight);
        BufferedImage outImage = new BufferedImage(newQrWidth, newHeight, 1);
        Graphics2D graph = outImage.createGraphics();
        graph.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graph.setBackground(qrCodeConfig.getFrameColor());
        graph.setColor(qrCodeConfig.getTextColor());
        graph.clearRect(0, 0, newQrWidth, newHeight);
        if (StringUtils.isNotBlank((CharSequence)topText)) {
            graph.setFont(topTextFont);
            float x = (float)((double)newQrWidth - topTextWidth) / 2.0f;
            float y = (float)topTextHeight;
            graph.drawString(topText, x, y);
        }
        if (StringUtils.isNotBlank((CharSequence)downText)) {
            graph.setFont(downTextFont);
            int x = (int)((double)newQrWidth - downTextWidth) / 2;
            int y = (int)((double)newHeight - downTextHeight);
            graph.drawString(downText, x, y);
        }
        graph.drawImage(source, (newQrWidth - source.getWidth()) / 2, (newHeight - source.getHeight()) / 2, source.getWidth(), source.getHeight(), null);
        graph.dispose();
        outImage.flush();
        return outImage;
    }

    public static BufferedImage createQRImage(QrCodeConfig qrCodeConfig) throws IOException, WriterException {
        BitMatrix bitMatrix = QrCodeGenerator.encode(qrCodeConfig);
        return QrCodeGenerator.toBufferedImage(qrCodeConfig, bitMatrix);
    }

    public static BufferedImage createQRImage(String message) throws IOException, WriterException {
        QrCodeConfig config = new QrCodeConfig();
        config.setMsg(message);
        return QrCodeGenerator.createQRImage(config);
    }

    private static BitMatrix encode(QrCodeConfig qrCodeConfig) throws WriterException {
        ErrorCorrectionLevel errorCorrectionLevel = qrCodeConfig.getErrorCorrection();
        int quietZone = qrCodeConfig.getPadding();
        if (quietZone > 4) {
            quietZone = 4;
        } else if (quietZone < 0) {
            quietZone = 0;
        }
        QRCode code = Encoder.encode((String)qrCodeConfig.getMsg(), (ErrorCorrectionLevel)errorCorrectionLevel, qrCodeConfig.getHints());
        return QrCodeGenerator.renderResult(code, qrCodeConfig.getQrWidth(), qrCodeConfig.getQrHeight(), quietZone);
    }

    private static BitMatrix renderResult(QRCode code, int width, int height, int quietZone) {
        ByteMatrix input = code.getMatrix();
        if (input == null) {
            throw new IllegalStateException();
        }
        int inputWidth = input.getWidth();
        int inputHeight = input.getHeight();
        int qrWidth = inputWidth + quietZone * 2;
        int qrHeight = inputHeight + quietZone * 2;
        int minSize = Math.min(width, height);
        int scale = QrCodeGenerator.calculateScale(qrWidth, minSize);
        if (scale > 0) {
            int padding = (minSize - qrWidth * scale) / 4 * quietZone;
            int tmpValue = qrWidth * scale + padding;
            if (width == height) {
                width = tmpValue;
                height = tmpValue;
            } else if (width > height) {
                width = width * tmpValue / height;
                height = tmpValue;
            } else {
                height = height * tmpValue / width;
                width = tmpValue;
            }
        }
        int outputWidth = Math.max(width, qrWidth);
        int outputHeight = Math.max(height, qrHeight);
        int multiple = Math.min(outputWidth / qrWidth, outputHeight / qrHeight);
        int leftPadding = (outputWidth - inputWidth * multiple) / 2;
        int topPadding = (outputHeight - inputHeight * multiple) / 2;
        BitMatrix output = new BitMatrix(outputWidth, outputHeight);
        int inputY = 0;
        int outputY = topPadding;
        while (inputY < inputHeight) {
            int inputX = 0;
            int outputX = leftPadding;
            while (inputX < inputWidth) {
                if (input.get(inputX, inputY) == 1) {
                    output.setRegion(outputX, outputY, multiple, multiple);
                }
                ++inputX;
                outputX += multiple;
            }
            ++inputY;
            outputY += multiple;
        }
        return output;
    }

    private static int calculateScale(int qrCodeSize, int expectSize) {
        if (qrCodeSize >= expectSize) {
            return 0;
        }
        int scale = expectSize / qrCodeSize;
        int abs = expectSize - scale * qrCodeSize;
        if ((double)abs < (double)expectSize * 0.15) {
            return 0;
        }
        return scale;
    }
}

