/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.security;

import com.centit.support.algorithm.StringBaseOpt;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class DesensitizeOptUtils {
    public static final String SYMBOL_STAR = "*";
    public static final int ADDRESS_SENSITIVE_SIZE = 7;

    public static SensitiveTypeEnum mapSensitiveType(String sensitiveType) {
        if (StringUtils.isBlank((CharSequence)sensitiveType)) {
            return SensitiveTypeEnum.NONE;
        }
        switch (sensitiveType.toLowerCase()) {
            case "chinesename": 
            case "chinese_name": {
                return SensitiveTypeEnum.CHINESE_NAME;
            }
            case "idcard": 
            case "id_card": {
                return SensitiveTypeEnum.ID_CARD;
            }
            case "phone": {
                return SensitiveTypeEnum.PHONE;
            }
            case "address": {
                return SensitiveTypeEnum.ADDRESS;
            }
            case "email": {
                return SensitiveTypeEnum.EMAIL;
            }
            case "bankcard": 
            case "bank_card": {
                return SensitiveTypeEnum.BANK_CARD;
            }
            case "password": {
                return SensitiveTypeEnum.PASSWORD;
            }
            case "account": {
                return SensitiveTypeEnum.ACCOUNT;
            }
        }
        return SensitiveTypeEnum.NONE;
    }

    public static String desensitize(String sensitive, SensitiveTypeEnum sensitiveType) {
        switch (sensitiveType) {
            case CHINESE_NAME: {
                return DesensitizeOptUtils.chineseName(sensitive, 3);
            }
            case ID_CARD: {
                return DesensitizeOptUtils.idCardNum(sensitive);
            }
            case PHONE: {
                return DesensitizeOptUtils.phone(sensitive);
            }
            case ADDRESS: {
                return DesensitizeOptUtils.address(sensitive, 7);
            }
            case EMAIL: {
                return DesensitizeOptUtils.email(sensitive);
            }
            case BANK_CARD: {
                return DesensitizeOptUtils.bankCard(sensitive);
            }
            case PASSWORD: {
                return DesensitizeOptUtils.password(sensitive);
            }
            case ACCOUNT: {
                return DesensitizeOptUtils.account(sensitive);
            }
        }
        return sensitive;
    }

    public static String chineseName(String fullName, int hideType) {
        if (StringUtils.isBlank((CharSequence)fullName)) {
            return "";
        }
        int nameLen = StringUtils.length((CharSequence)fullName);
        if (hideType == 1) {
            String name = StringUtils.left((String)fullName, (int)1);
            return StringUtils.rightPad((String)name, (int)nameLen, (String)SYMBOL_STAR);
        }
        if (hideType == 3) {
            String name = StringUtils.left((String)fullName, (int)1);
            if (nameLen == 2) {
                return name + SYMBOL_STAR;
            }
            return StringUtils.join((Object[])new String[]{name, StringUtils.rightPad((String)SYMBOL_STAR, (int)(nameLen - 2), (String)SYMBOL_STAR), StringUtils.right((String)fullName, (int)1)});
        }
        return SYMBOL_STAR + StringUtils.substring((String)fullName, (int)1);
    }

    public static String idCardNum(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return "";
        }
        StringBuilder idCard = new StringBuilder(StringUtils.rightPad((String)SYMBOL_STAR, (int)4, (String)SYMBOL_STAR));
        idCard.append(StringUtils.substring((String)id, (int)4, (int)6));
        if (StringUtils.length((CharSequence)id) == 18) {
            idCard.append(StringUtils.rightPad((String)SYMBOL_STAR, (int)8, (String)SYMBOL_STAR));
            idCard.append(StringUtils.substring((String)id, (int)-4));
        } else {
            idCard.append(StringUtils.rightPad((String)SYMBOL_STAR, (int)(StringUtils.length((CharSequence)id) - 9), (String)SYMBOL_STAR));
            idCard.append(StringUtils.substring((String)id, (int)-3));
        }
        return idCard.toString();
    }

    private static String showHeadAndTail(String str, int head, int tail) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        if (head <= 0) {
            return StringUtils.rightPad((String)SYMBOL_STAR, (int)(StringUtils.length((CharSequence)str) - tail), (String)SYMBOL_STAR) + StringUtils.right((String)str, (int)tail);
        }
        return StringUtils.join((Object[])new String[]{StringUtils.left((String)str, (int)head), StringUtils.rightPad((String)SYMBOL_STAR, (int)(StringUtils.length((CharSequence)str) - head - tail), (String)SYMBOL_STAR), StringUtils.right((String)str, (int)tail)});
    }

    public static String account(String id) {
        return DesensitizeOptUtils.showHeadAndTail(id, 2, 2);
    }

    public static String phone(String num) {
        if (StringUtils.isBlank((CharSequence)num)) {
            return "";
        }
        int header = StringUtils.startsWithAny((CharSequence)num, (CharSequence[])new CharSequence[]{"0", "+", "1"}) ? 3 : 0;
        return DesensitizeOptUtils.showHeadAndTail(num, header, 4);
    }

    public static String address(String address, int sensitiveSize) {
        if (StringUtils.isBlank((CharSequence)address)) {
            return "";
        }
        int length = StringUtils.length((CharSequence)address);
        return StringUtils.rightPad((String)StringUtils.left((String)address, (int)(length - sensitiveSize)), (int)length, (String)SYMBOL_STAR);
    }

    public static String email(String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            return "";
        }
        int index = StringUtils.indexOf((CharSequence)email, (CharSequence)"@");
        if (index <= 1) {
            return email;
        }
        return StringUtils.rightPad((String)StringUtils.left((String)email, (int)1), (int)index, (String)SYMBOL_STAR) + StringUtils.substring((String)email, (int)index, (int)StringUtils.length((CharSequence)email));
    }

    public static String bankCard(String cardNum) {
        return DesensitizeOptUtils.showHeadAndTail(cardNum, 4, 3);
    }

    public static String password(String password) {
        if (StringUtils.isBlank((CharSequence)password)) {
            return "";
        }
        return StringUtils.rightPad((String)SYMBOL_STAR, (int)StringUtils.length((CharSequence)password), (String)SYMBOL_STAR);
    }

    public static Map<String, SensitiveTypeEnum> mapDesensitizeOpt(Map<String, String> desenDesc) {
        HashMap<String, SensitiveTypeEnum> optDesc = new HashMap<String, SensitiveTypeEnum>(desenDesc.size());
        for (Map.Entry<String, String> ent : desenDesc.entrySet()) {
            SensitiveTypeEnum sensType = DesensitizeOptUtils.mapSensitiveType(ent.getValue());
            if (SensitiveTypeEnum.NONE == sensType) continue;
            optDesc.put(ent.getKey(), sensType);
        }
        return optDesc;
    }

    public static Map<String, Object> desensitize(Map<String, Object> data, Map<String, SensitiveTypeEnum> desenDesc) {
        for (Map.Entry<String, SensitiveTypeEnum> ent : desenDesc.entrySet()) {
            String sensitive = DesensitizeOptUtils.desensitize(StringBaseOpt.castObjectToString(data.get(ent.getKey())), ent.getValue());
            if (!StringUtils.isNotBlank((CharSequence)sensitive)) continue;
            data.put(ent.getKey(), sensitive);
        }
        return data;
    }

    public static Collection<Object> desensitize(Collection<Object> data, Map<String, SensitiveTypeEnum> desenDesc) {
        if (!desenDesc.isEmpty()) {
            for (Object obj : data) {
                if (!(obj instanceof Map)) continue;
                DesensitizeOptUtils.desensitize((Map)obj, desenDesc);
            }
        }
        return data;
    }

    public static enum SensitiveTypeEnum {
        NONE,
        CHINESE_NAME,
        ID_CARD,
        PHONE,
        ADDRESS,
        EMAIL,
        BANK_CARD,
        ACCOUNT,
        PASSWORD;

    }
}

