/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.image;

import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.security.Md5Encoder;
import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public abstract class ImageOpt {
    private ImageOpt() {
        throw new IllegalAccessError("Utility class");
    }

    public static void createThumbnail(String filename, int thumbWidth, int thumbHeight, int quality, String outFilename) throws InterruptedException, IOException {
        Image image = Toolkit.getDefaultToolkit().getImage(filename);
        MediaTracker mediaTracker = new MediaTracker(new Container());
        mediaTracker.addImage(image, 0);
        mediaTracker.waitForID(0);
        double thumbRatio = (double)thumbWidth / (double)thumbHeight;
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        double imageRatio = (double)imageWidth / (double)imageHeight;
        if (thumbRatio < imageRatio) {
            thumbHeight = (int)((double)thumbWidth / imageRatio);
        } else {
            thumbWidth = (int)((double)thumbHeight * imageRatio);
        }
        BufferedImage thumbImage = new BufferedImage(thumbWidth, thumbHeight, 1);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, thumbWidth, thumbHeight, null);
        ImageOpt.saveBufferedImage(outFilename, thumbImage, quality);
    }

    public static void saveBufferedImage(String filename, BufferedImage image, int quality) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(Paths.get(filename, new String[0]), new OpenOption[0]));){
            ImageIO.write((RenderedImage)image, "jpg", out);
        }
    }

    public static void captureScreen(String fileName) throws AWTException, IOException {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle screenRectangle = new Rectangle(screenSize);
        Robot robot = new Robot();
        BufferedImage image = robot.createScreenCapture(screenRectangle);
        ImageIO.write((RenderedImage)image, "png", new File(fileName));
    }

    public static BufferedImage saveSubImage(BufferedImage image, Rectangle subImageBounds) {
        BufferedImage subImage = new BufferedImage(subImageBounds.width, subImageBounds.height, 1);
        Graphics g = subImage.getGraphics();
        if (subImageBounds.width > image.getWidth() || subImageBounds.height > image.getHeight()) {
            int left = subImageBounds.x;
            int top = subImageBounds.y;
            if (image.getWidth() < subImageBounds.width) {
                left = (subImageBounds.width - image.getWidth()) / 2;
            }
            if (image.getHeight() < subImageBounds.height) {
                top = (subImageBounds.height - image.getHeight()) / 2;
            }
            g.setColor(Color.white);
            g.fillRect(0, 0, subImageBounds.width, subImageBounds.height);
            g.drawImage(image, left, top, null);
            return image;
        }
        g.drawImage(image.getSubimage(subImageBounds.x, subImageBounds.y, subImageBounds.width, subImageBounds.height), 0, 0, null);
        g.dispose();
        return subImage;
    }

    public static List<BufferedImage> splitImage(BufferedImage image, int divisions) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        if (divisions < 2) {
            images.add(image);
            return images;
        }
        int imgWidth = image.getWidth();
        int subImgWidth = imgWidth / divisions;
        int imgHeight = image.getHeight();
        for (int i = 0; i < divisions; ++i) {
            BufferedImage subImage = new BufferedImage(subImgWidth, imgHeight, 1);
            Graphics g = subImage.getGraphics();
            g.drawImage(image.getSubimage(imgWidth * i / divisions, 0, subImgWidth, imgHeight), 0, 0, null);
            g.dispose();
            images.add(subImage);
        }
        return images;
    }

    public static BufferedImage mergeImages(List<BufferedImage> imageList, int imagesPreRow, int whiteSpace) {
        BufferedImage image = imageList.get(0);
        int w = image.getWidth();
        int h = image.getHeight();
        int imgWidth = whiteSpace + (whiteSpace + w) * imagesPreRow;
        int imgHeight = whiteSpace + (whiteSpace + h) * ((imageList.size() - 1) / imagesPreRow + 1);
        BufferedImage mergeImage = new BufferedImage(imgWidth, imgHeight, 1);
        Graphics g = mergeImage.getGraphics();
        int i = 0;
        for (BufferedImage img : imageList) {
            g.drawImage(img, whiteSpace + (whiteSpace + w) * (i % imagesPreRow), whiteSpace + (whiteSpace + h) * (i / imagesPreRow), null);
            ++i;
        }
        g.dispose();
        return mergeImage;
    }

    public static int[] getRGB(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] inPixels = new int[width * height];
        return ImageOpt.getRGB(image, 0, 0, width, height, inPixels);
    }

    public static int[] getRGB(BufferedImage image, int x, int y, int width, int height, int[] pixels) {
        int type = image.getType();
        if (type == 2 || type == 1) {
            return (int[])image.getRaster().getDataElements(x, y, width, height, pixels);
        }
        return image.getRGB(x, y, width, height, pixels, 0, width);
    }

    public static BufferedImage createIdIcon(String id, int imageSize, int pointWidth, boolean singleColor, boolean symmetric) {
        byte[] idMd5;
        int step = imageSize / pointWidth;
        if (step > 11) {
            step = 10;
            pointWidth = imageSize / 10;
        }
        if (imageSize % pointWidth != 0) {
            imageSize = step * pointWidth;
        }
        if ((idMd5 = Md5Encoder.rawEncode(id.getBytes())) == null) {
            return null;
        }
        BufferedImage image = new BufferedImage(imageSize, imageSize, 1);
        Color showColor = new Color(idMd5[0] & 0xFF, idMd5[1] & 0xFF, idMd5[2] & 0xFF);
        Graphics2D g = image.createGraphics();
        int mid = (step - 1) / 2;
        for (int i = 0; i < step; ++i) {
            for (int j = 0; j < step; ++j) {
                boolean isColor;
                int row = symmetric && i > mid ? step - i - 1 : i;
                int n = (row * step + j) / 8;
                int b = (row * step + j) % 8;
                boolean bl = isColor = (idMd5[n] & 1 << b) != 0;
                if (j == 0 || row == 0 || j == step - 1 || row == step - 1) {
                    if (isColor) {
                        g.setColor(new Color(214, 214, 214));
                    } else {
                        g.setColor(new Color(235, 235, 235));
                    }
                } else if (isColor) {
                    if (singleColor) {
                        g.setColor(showColor);
                    } else {
                        g.setColor(new Color(idMd5[n] & 0xFF, idMd5[(n * b + b) % 16] % 256 & 0xFF, idMd5[(n + b) % 16] % 256 & 0xFF));
                    }
                } else {
                    g.setColor(Color.LIGHT_GRAY);
                }
                g.fillRect(i * pointWidth, j * pointWidth, pointWidth, pointWidth);
            }
        }
        g.dispose();
        return image;
    }

    public static BufferedImage createIdIcon(String id, int imageSize, int pointWidth) {
        return ImageOpt.createIdIcon(id, imageSize, pointWidth, true, true);
    }

    public static BufferedImage createNameIcon(String word, int imageSize, Color wordColor, boolean withEdge) {
        ColorModel cm = ColorModel.getRGBdefault();
        WritableRaster wr = cm.createCompatibleWritableRaster(imageSize, imageSize);
        BufferedImage image = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), null);
        Graphics2D g = image.createGraphics();
        g.setColor(wordColor);
        int strLen = word.length() >= 4 ? 4 : 1;
        int edgeWidth = withEdge ? imageSize / 20 : 0;
        int fontSize = strLen > 1 ? (imageSize / 2 - edgeWidth) * 15 / 16 : (imageSize - edgeWidth * 2) * 15 / 16;
        g.setFont(new Font("\u6977\u4f53", 1, fontSize));
        if (withEdge) {
            g.setStroke(new BasicStroke(edgeWidth));
            g.drawRoundRect(edgeWidth / 2, edgeWidth / 2, imageSize - edgeWidth, imageSize - edgeWidth, imageSize / 3, imageSize / 3);
        }
        if (strLen < 4) {
            g.drawString(word.substring(0, 1), edgeWidth, imageSize * 15 / 16 - edgeWidth * 2);
        } else {
            g.drawString(word.substring(0, 1), edgeWidth, imageSize / 2 - edgeWidth);
            g.drawString(word.substring(1, 2), imageSize / 2, imageSize / 2 - edgeWidth);
            g.drawString(word.substring(2, 3), edgeWidth, imageSize * 15 / 16 - edgeWidth * 2);
            g.drawString(word.substring(3, 4), imageSize / 2, imageSize * 15 / 16 - edgeWidth * 2);
        }
        return image;
    }

    public static InputStream imageToInputStream(BufferedImage image) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "jpg", os);
        return new ByteArrayInputStream(os.toByteArray());
    }

    public static byte[] imageToByteArray(BufferedImage image) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "jpg", os);
        return os.toByteArray();
    }

    public static byte[] imageToByteArray(BufferedImage image, String formatName) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, formatName, os);
        return os.toByteArray();
    }

    public static BufferedImage loadImage(String uri) throws IOException {
        if (uri.startsWith("http")) {
            return ImageIO.read(new URL(uri));
        }
        return ImageIO.read(new File(uri));
    }

    public static BufferedImage makeRoundedCorner(BufferedImage image, int cornerRadius) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage output = new BufferedImage(w, h, 2);
        Graphics2D g2 = output.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, cornerRadius, cornerRadius));
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage((Image)image, 0, 0, null);
        g2.dispose();
        return output;
    }

    public static BufferedImage makeRoundBorder(BufferedImage image, int cornerRadius, int size, Color color) {
        image = ImageOpt.makeRoundedCorner(image, cornerRadius);
        int borderSize = size << 1;
        int w = image.getWidth() + borderSize;
        int h = image.getHeight() + borderSize;
        BufferedImage output = new BufferedImage(w, h, 2);
        Graphics2D g2 = output.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(color == null ? Color.WHITE : color);
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, cornerRadius, cornerRadius));
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage((Image)image, size, size, null);
        g2.dispose();
        return output;
    }

    public static Color castObjectToColor(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Color) {
            return (Color)obj;
        }
        if (obj instanceof Number) {
            return new Color(((Number)obj).intValue());
        }
        String colorStr = StringBaseOpt.castObjectToString(obj);
        int strLen = colorStr.length();
        if (colorStr.startsWith("#")) {
            int r = 0;
            int g = 0;
            int b = 0;
            int a = 255;
            if (strLen > 6) {
                r = Integer.parseInt(colorStr.substring(1, 3), 16);
                g = Integer.parseInt(colorStr.substring(3, 5), 16);
                b = Integer.parseInt(colorStr.substring(5, 7), 16);
                if (strLen > 8) {
                    a = Integer.parseInt(colorStr.substring(7, 9), 16);
                }
            } else if (strLen > 1) {
                r = Integer.parseInt(colorStr.substring(1, 2), 16);
                if (strLen > 2) {
                    g = Integer.parseInt(colorStr.substring(2, 3), 16);
                    if (strLen > 3) {
                        b = Integer.parseInt(colorStr.substring(3, 4), 16);
                        if (strLen > 4) {
                            a = Integer.parseInt(colorStr.substring(4, 5), 16);
                        }
                    }
                }
            }
            return new Color(r, g, b, a);
        }
        if (StringRegularOpt.isDigit(colorStr)) {
            if (strLen == 9) {
                int r = Integer.getInteger(colorStr.substring(0, 3));
                int g = Integer.getInteger(colorStr.substring(3, 6));
                int b = Integer.getInteger(colorStr.substring(6, 9));
                return new Color(r, g, b);
            }
            return new Color(Integer.getInteger(colorStr));
        }
        switch (colorStr = colorStr.toLowerCase()) {
            case "white": {
                return Color.white;
            }
            case "lightgray": {
                return Color.lightGray;
            }
            case "gray": {
                return Color.gray;
            }
            case "darkgray": {
                return Color.darkGray;
            }
            case "black": {
                return Color.black;
            }
            case "red": {
                return Color.red;
            }
            case "pink": {
                return Color.pink;
            }
            case "orange": {
                return Color.orange;
            }
            case "yellow": {
                return Color.yellow;
            }
            case "green": {
                return Color.green;
            }
            case "magenta": {
                return Color.magenta;
            }
            case "cyan": {
                return Color.cyan;
            }
            case "blue": {
                return Color.blue;
            }
        }
        return null;
    }

    public static Color castObjectToColor(Object obj, Color defaultColor) {
        Color cr = ImageOpt.castObjectToColor(obj);
        return cr == null ? defaultColor : cr;
    }

    public static ImageTextInfo createImageText(float x, float y, String t) {
        return new ImageTextInfo(x, y, t);
    }

    public static BufferedImage addTextToImage(BufferedImage image, String fontName, Color color, int size, List<ImageTextInfo> textList) {
        Graphics2D g2d = image.createGraphics();
        g2d.setComposite(AlphaComposite.getInstance(10, 0.5f));
        g2d.setColor(color);
        g2d.setFont(new Font(fontName, 0, size));
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        for (ImageTextInfo iti : textList) {
            int xx = iti.x >= 1.0f ? (int)iti.x : (int)((float)image.getWidth() * iti.x);
            int yy = iti.y >= 1.0f ? (int)iti.y : (int)((float)image.getHeight() * iti.y);
            g2d.drawString(iti.text, xx, yy);
        }
        g2d.dispose();
        return image;
    }

    public static boolean addTextToImage(InputStream imageIS, String imageType, OutputStream imageOS, String waterMark, String fontName, Color color, int size, float x, float y) {
        try {
            BufferedImage image = ImageIO.read(imageIS);
            BufferedImage markImage = ImageOpt.addTextToImage(image, fontName, color, size, CollectionsOpt.createList(ImageOpt.createImageText(x, y, waterMark)));
            ImageIO.write((RenderedImage)markImage, imageType, imageOS);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean addTextToImage(InputStream imageIS, String imageType, OutputStream imageOS, String fontName, Color color, int size, List<ImageTextInfo> textList) {
        try {
            BufferedImage image = ImageIO.read(imageIS);
            BufferedImage markImage = ImageOpt.addTextToImage(image, fontName, color, size, textList);
            ImageIO.write((RenderedImage)markImage, imageType, imageOS);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static class ImageTextInfo {
        public float x;
        public float y;
        public String text;

        public ImageTextInfo(float x, float y, String t) {
            this.x = x;
            this.y = y;
            this.text = t;
        }
    }
}

