/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.image;

import com.centit.support.image.ImageOpt;
import com.google.zxing.EncodeHintType;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class QrCodeConfig {
    private String msg;
    private String topText;
    private Integer topTextFontSize = 8;
    private String downText;
    private Integer downTextFontSize = 7;
    private String topTextFontType = "\u96c5\u9ed1";
    private String downTextFontType = "\u96c5\u9ed1";
    private BufferedImage logoImage = null;
    private Integer qrWidth = 200;
    private Integer qrHeight = 200;
    private String code = "UTF-8";
    private int padding = 0;
    private ErrorCorrectionLevel errorCorrection = ErrorCorrectionLevel.Q;
    private int onColor = -16777216;
    private int offColor = -1;
    private String picType = "png";
    private Color textColor;
    private Color frameColor = Color.white;

    public QrCodeConfig() {
        this.textColor = Color.black;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    private void validate() {
        if (this.msg == null || this.msg.length() == 0) {
            throw new IllegalArgumentException("\u4e8c\u7ef4\u7801\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    public String getTopText() {
        return this.topText;
    }

    public void setTopText(String topText) {
        this.topText = topText;
    }

    public Integer getTopTextFontSize() {
        return this.topTextFontSize;
    }

    public void setTopTextFontSize(Integer topTextFontSize) {
        if (topTextFontSize == null || topTextFontSize < 0) {
            return;
        }
        this.topTextFontSize = topTextFontSize;
    }

    public String getDownText() {
        return this.downText;
    }

    public void setDownText(String downText) {
        this.downText = downText;
    }

    public Integer getDownTextFontSize() {
        return this.downTextFontSize;
    }

    public void setDownTextFontSize(Integer downTextFontSize) {
        if (downTextFontSize == null || downTextFontSize < 0) {
            return;
        }
        this.downTextFontSize = downTextFontSize;
    }

    public String getTopTextFontType() {
        return this.topTextFontType;
    }

    public void setTopTextFontType(String topTextFontType) {
        if (StringUtils.isBlank((CharSequence)topTextFontType)) {
            return;
        }
        this.topTextFontType = topTextFontType;
    }

    public String getDownTextFontType() {
        return this.downTextFontType;
    }

    public void setDownTextFontType(String downTextFontType) {
        if (StringUtils.isBlank((CharSequence)downTextFontType)) {
            return;
        }
        this.downTextFontType = downTextFontType;
    }

    public BufferedImage getLogoImage() {
        return this.logoImage;
    }

    public void setLogoImageUrl(String logoImageUrl) {
        if (StringUtils.isBlank((CharSequence)logoImageUrl)) {
            return;
        }
        try {
            this.logoImage = ImageOpt.loadImage(logoImageUrl);
        }
        catch (IOException e) {
            this.logoImage = null;
        }
    }

    public void setLogoImage(BufferedImage logoImage) {
        this.logoImage = logoImage;
    }

    public Integer getQrWidth() {
        return this.qrWidth;
    }

    public void setQrWidth(Integer qrWidth) {
        if (qrWidth == null || qrWidth < 0) {
            return;
        }
        this.qrWidth = qrWidth;
    }

    public Integer getQrHeight() {
        return this.qrHeight;
    }

    public void setQrHeight(Integer qrHeight) {
        if (qrHeight == null || qrHeight < 0) {
            return;
        }
        this.qrHeight = qrHeight;
    }

    public int getOnColor() {
        return this.onColor;
    }

    public void setOnColor(Integer onColor) {
        if (onColor != null) {
            this.onColor = onColor;
        }
    }

    public int getOffColor() {
        return this.offColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Color getFrameColor() {
        return this.frameColor;
    }

    public void setFrameColor(Color frameColor) {
        this.frameColor = frameColor;
    }

    public void setOffColor(Integer offColor) {
        if (offColor != null) {
            this.offColor = offColor;
        }
    }

    public String getPicType() {
        return this.picType;
    }

    public void setPicType(String picType) {
        if (StringUtils.isBlank((CharSequence)picType)) {
            return;
        }
        this.picType = picType;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return;
        }
        this.code = code;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(Integer padding) {
        if (padding == null || padding < 0) {
            return;
        }
        this.padding = padding;
    }

    public ErrorCorrectionLevel getErrorCorrection() {
        return this.errorCorrection;
    }

    public void setErrorCorrection(ErrorCorrectionLevel errorCorrection) {
        if (errorCorrection == null) {
            return;
        }
        this.errorCorrection = errorCorrection;
    }

    public Map<EncodeHintType, Object> getHints() {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>(3);
        hints.put(EncodeHintType.ERROR_CORRECTION, this.getErrorCorrection());
        hints.put(EncodeHintType.CHARACTER_SET, this.getCode());
        hints.put(EncodeHintType.MARGIN, this.getPadding());
        return hints;
    }
}

