/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.xml;

import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.common.JavaBeanField;
import com.centit.support.common.JavaBeanMetaData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XMLObject {
    protected static final Logger logger = LoggerFactory.getLogger(XMLObject.class);

    private XMLObject() {
        throw new IllegalAccessError("Utility class");
    }

    public static Element createXMLElement(String elementName, String valueType, Object value, boolean addAttr) {
        Element element = DocumentHelper.createElement((String)elementName);
        if (addAttr) {
            element.addAttribute("type", valueType);
        }
        element.setText(StringBaseOpt.objectToString(value));
        return element;
    }

    public static Element createXMLElementFromObject(String elementName, Object object, boolean addAttr, boolean fieldAsKeyAttr, HashSet<Object> hasSerialized) {
        if (object instanceof String) {
            return XMLObject.createXMLElement(elementName, "String", object, addAttr);
        }
        if (object instanceof Long) {
            return XMLObject.createXMLElement(elementName, "Long", object, addAttr);
        }
        if (object instanceof BigDecimal) {
            return XMLObject.createXMLElement(elementName, "BigDecimal", object, addAttr);
        }
        if (object instanceof Boolean) {
            return XMLObject.createXMLElement(elementName, "Boolean", object, addAttr);
        }
        if (object instanceof Integer) {
            return XMLObject.createXMLElement(elementName, "Integer", object, addAttr);
        }
        if (object instanceof Number) {
            return XMLObject.createXMLElement(elementName, "Number", object, addAttr);
        }
        if (object instanceof Date) {
            return XMLObject.createXMLElement(elementName, "Date", object, addAttr);
        }
        if (object instanceof Map) {
            Element element = DocumentHelper.createElement((String)elementName);
            if (addAttr) {
                element.addAttribute("type", "Object");
                element.addAttribute("class", object.getClass().getName());
            }
            for (Map.Entry jo : ((Map)object).entrySet()) {
                if (jo.getValue() == null) continue;
                String keyName = StringBaseOpt.objectToString(jo.getKey());
                String keyEntName = fieldAsKeyAttr ? "entry" : keyName;
                Element entry = XMLObject.createXMLElementFromObject(keyEntName, jo.getValue(), addAttr, fieldAsKeyAttr, hasSerialized);
                if (fieldAsKeyAttr) {
                    entry.addAttribute("key", keyName);
                }
                element.add(entry);
            }
            return element;
        }
        if (object instanceof Object[]) {
            Element element = DocumentHelper.createElement((String)elementName);
            element.addAttribute("type", "Array");
            if (addAttr) {
                element.addAttribute("class", object.getClass().getName());
            }
            for (Object obj : (Object[])object) {
                if (obj == null) continue;
                element.add(XMLObject.createXMLElementFromObject("item", obj, addAttr, fieldAsKeyAttr, hasSerialized));
            }
            return element;
        }
        if (object instanceof Collection) {
            Element element = DocumentHelper.createElement((String)elementName);
            element.addAttribute("type", "Array");
            if (addAttr) {
                element.addAttribute("class", object.getClass().getName());
            }
            for (Object obj : (Collection)object) {
                if (obj == null) continue;
                element.add(XMLObject.createXMLElementFromObject("item", obj, addAttr, fieldAsKeyAttr, hasSerialized));
            }
            return element;
        }
        if (ReflectionOpt.isScalarType(object.getClass())) {
            return XMLObject.createXMLElement(elementName, "String", object, addAttr);
        }
        if (hasSerialized.contains(object)) {
            return XMLObject.createXMLElement(elementName, "recursion", object.getClass().getName(), addAttr);
        }
        hasSerialized.add(object);
        JavaBeanMetaData jbm = JavaBeanMetaData.createBeanMetaDataFromType(object.getClass());
        Map<String, JavaBeanField> fields = jbm.getFileds();
        if (fields == null) {
            return XMLObject.createXMLElement(elementName, "String", object, addAttr);
        }
        Element element = DocumentHelper.createElement((String)elementName);
        if (addAttr) {
            element.addAttribute("type", "Object");
            element.addAttribute("class", object.getClass().getName());
        }
        for (Map.Entry<String, JavaBeanField> field : fields.entrySet()) {
            Object obj = field.getValue().getObjectFieldValue(object);
            if (obj == null) continue;
            String keyEntName = fieldAsKeyAttr ? "entry" : field.getKey();
            Element entry = XMLObject.createXMLElementFromObject(keyEntName, obj, addAttr, fieldAsKeyAttr, hasSerialized);
            if (fieldAsKeyAttr) {
                entry.addAttribute("key", field.getKey());
            }
            element.add(entry);
        }
        return element;
    }

    public static String objectToXMLString(String rootName, Object object, boolean addAttr, boolean fieldAsKeyAttr) {
        HashSet<Object> hasSerialized = new HashSet<Object>();
        Element element = XMLObject.createXMLElementFromObject(rootName, object, addAttr, fieldAsKeyAttr, hasSerialized);
        return element.asXML();
    }

    public static String objectToXMLString(String rootName, String nameSpacePrefix, String namespace, Object object, boolean addAttr, boolean fieldAsKeyAttr) {
        HashSet<Object> hasSerialized = new HashSet<Object>();
        Element element = XMLObject.createXMLElementFromObject(nameSpacePrefix + ":" + rootName, object, addAttr, fieldAsKeyAttr, hasSerialized);
        element.add(new Namespace(nameSpacePrefix, namespace));
        return element.asXML();
    }

    public static String objectToXMLString(String rootName, Object object) {
        return XMLObject.objectToXMLString(rootName, object, true, true);
    }

    public static String objectToXMLString(Object object) {
        return XMLObject.objectToXMLString("object", object);
    }

    public static Object elementToObject(Element element) {
        String sType;
        Attribute attr = element.attribute("type");
        String string = sType = attr == null ? null : attr.getValue();
        if (StringUtils.equals((CharSequence)"Date", (CharSequence)sType)) {
            return DatetimeOpt.smartPraseDate(element.getTextTrim());
        }
        if (StringUtils.equals((CharSequence)"Long", (CharSequence)sType)) {
            return NumberBaseOpt.castObjectToLong(element.getTextTrim());
        }
        if (StringUtils.equals((CharSequence)"Integer", (CharSequence)sType)) {
            return NumberBaseOpt.castObjectToInteger(element.getTextTrim());
        }
        if (StringUtils.equals((CharSequence)"Number", (CharSequence)sType)) {
            return NumberBaseOpt.castObjectToDouble(element.getTextTrim());
        }
        if (StringUtils.equals((CharSequence)"Boolean", (CharSequence)sType)) {
            return StringRegularOpt.isTrue(element.getTextTrim());
        }
        if (StringUtils.equals((CharSequence)"BigDecimal", (CharSequence)sType)) {
            return new BigDecimal(element.getTextTrim());
        }
        if (StringUtils.equals((CharSequence)"Array", (CharSequence)sType)) {
            List subElements = element.elements();
            if (subElements == null) {
                return null;
            }
            ArrayList<Object> objs = new ArrayList<Object>(subElements.size());
            for (Element subE : subElements) {
                if (!StringUtils.equals((CharSequence)"item", (CharSequence)element.getName())) continue;
                objs.add(XMLObject.elementToObject(subE));
            }
            return objs;
        }
        List subElements = element.elements();
        if (subElements == null || subElements.isEmpty()) {
            return element.getTextTrim();
        }
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        for (Element subE : subElements) {
            String keyName = subE.getName();
            Attribute keyAttr = subE.attribute("key");
            if (attr != null) {
                keyName = attr.getValue();
            }
            objectMap.put(keyName, XMLObject.elementToObject(subE));
        }
        return objectMap;
    }

    public static Map<String, Object> elementToJSONObject(Element element) {
        Object obj = XMLObject.elementToObject(element);
        if (obj instanceof Map) {
            return (Map)obj;
        }
        return null;
    }

    public static Map<String, Object> xmlStringToJSONObject(String xmlString) {
        try {
            Document doc = DocumentHelper.parseText((String)xmlString);
            return XMLObject.elementToJSONObject(doc.getRootElement());
        }
        catch (DocumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Object xmlStringToObject(String xmlString) {
        try {
            Document doc = DocumentHelper.parseText((String)xmlString);
            return XMLObject.elementToObject(doc.getRootElement());
        }
        catch (DocumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

