/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import java.util.ArrayList;
import java.util.List;

public class TreeNode<T> {
    private T value;
    private TreeNode<T> parent;
    private List<TreeNode<T>> children;

    public TreeNode() {
        this.children = null;
        this.parent = null;
    }

    public TreeNode(T value) {
        this.value = value;
        this.children = null;
        this.parent = null;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public List<TreeNode<T>> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeNode<T>> children) {
        this.children = children;
    }

    public TreeNode<T> addChild(T child) {
        TreeNode<T> treeNode = new TreeNode<T>(child);
        this.addChild(treeNode);
        return treeNode;
    }

    public void addChild(TreeNode<T> child) {
        if (this.children == null) {
            this.children = new ArrayList<TreeNode<T>>();
        }
        child.parent = this;
        this.children.add(child);
    }

    public TreeNode<T> getParent() {
        return this.parent;
    }

    public void setParent(TreeNode<T> parent) {
        this.parent = parent;
    }

    public boolean isLeaf() {
        return this.children == null || this.children.isEmpty();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public JSONObject toJSONObject(String childrenPropertyName) {
        JSONObject jo;
        if (ReflectionOpt.isScalarType(this.getValue().getClass())) {
            jo = new JSONObject();
            jo.put((Object)"value", (Object)StringBaseOpt.objectToString(this.getValue()));
        } else {
            jo = JSONObject.from(this.getValue());
        }
        if (this.children != null && !this.children.isEmpty()) {
            JSONArray ja = new JSONArray();
            for (TreeNode<T> c : this.children) {
                ja.add((Object)c.toJSONObject(childrenPropertyName));
            }
            jo.put((Object)childrenPropertyName, (Object)ja);
        }
        return jo;
    }

    public static JSONArray toJSONArray(List<? extends TreeNode<?>> forest, String childrenPropertyName) {
        JSONArray ja = new JSONArray();
        for (TreeNode<?> c : forest) {
            ja.add((Object)c.toJSONObject(childrenPropertyName));
        }
        return ja;
    }

    public static JSONArray toJSONArray(List<? extends TreeNode<?>> forest) {
        return TreeNode.toJSONArray(forest, "children");
    }

    public JSONObject toJSONObject() {
        return this.toJSONObject("children");
    }

    public String toString() {
        return this.toJSONObject("children").toJSONString(new JSONWriter.Feature[0]);
    }

    public int getPathCount() {
        int result = 0;
        for (TreeNode<T> path = this; path != null; path = path.getParent()) {
            ++result;
        }
        return result;
    }

    public TreeNode<T>[] getTreeNodePath() {
        int i = this.getPathCount();
        TreeNode[] result = new TreeNode[i--];
        for (TreeNode<T> path = this; path != null; path = path.getParent()) {
            result[i--] = path;
        }
        return result;
    }

    public TreeNode<T> getRootTreeNode() {
        for (TreeNode<T> path = this; path != null; path = path.getParent()) {
            if (!path.isRoot()) continue;
            return path;
        }
        return this;
    }

    public T[] getPath() {
        int i = this.getPathCount();
        Object[] result = new Object[i--];
        for (TreeNode<T> path = this; path != null; path = path.getParent()) {
            result[i--] = path.getValue();
        }
        return result;
    }

    public T getRootValue() {
        T rootValue = this.getValue();
        for (TreeNode<T> path = this.getParent(); path != null; path = path.getParent()) {
            rootValue = path.getValue();
        }
        return rootValue;
    }
}

