/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.file;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;

public abstract class CsvFileIO {
    public static List<Map<String, Object>> readDataFromInputStream(InputStream inputStream, boolean firstRowAsHeader, List<String> columnNames, String charsetType) throws IOException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName(charsetType)), 8192);){
            List<String> headers;
            CSVParser csvParser = CSVFormat.EXCEL.parse((Reader)reader);
            List recordList = csvParser.getRecords();
            if (recordList == null || recordList.isEmpty()) {
                ArrayList<Map<String, Object>> arrayList = list;
                return arrayList;
            }
            int dataPos = 0;
            if (firstRowAsHeader) {
                dataPos = 1;
                headers = CollectionsOpt.mergeTwoList(columnNames, ((CSVRecord)recordList.get(0)).toList());
            } else {
                headers = columnNames;
            }
            int headLen = headers == null ? 0 : headers.size();
            for (int k = dataPos; k < recordList.size(); ++k) {
                CSVRecord record = (CSVRecord)recordList.get(k);
                int splitResultLength = record.size();
                HashMap<String, String> map = new HashMap<String, String>(splitResultLength);
                for (int i = 0; i < splitResultLength; ++i) {
                    String columnName = i < headLen ? headers.get(i) : "column" + i;
                    map.put(columnName, record.get(i));
                }
                list.add(map);
            }
            csvParser.close();
            ArrayList<Map<String, Object>> arrayList = list;
            return arrayList;
        }
    }

    public static void saveData2OutputStream(List<Map<String, Object>> listData, OutputStream outs, boolean firstRowAsHeader, List<String> columnNames, String charsetType) throws IOException {
        if (listData == null || listData.isEmpty()) {
            return;
        }
        if (columnNames == null || columnNames.isEmpty()) {
            LinkedHashSet<String> headers = new LinkedHashSet<String>(50);
            for (Map<String, Object> row : listData) {
                headers.addAll(row.keySet());
            }
            columnNames = CollectionsOpt.cloneList(headers);
        }
        if (columnNames == null || columnNames.isEmpty()) {
            return;
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outs, Charset.forName(charsetType)));
        Object object = null;
        try {
            CSVPrinter csvPrinter = CSVFormat.EXCEL.print((Appendable)writer);
            if (firstRowAsHeader) {
                csvPrinter.printRecord(columnNames);
            }
            Object[] values = new String[columnNames.size()];
            for (Map<String, Object> row : listData) {
                for (int i = 0; i < columnNames.size(); ++i) {
                    values[i] = StringBaseOpt.castObjectToString(row.get(columnNames.get(i)), "");
                }
                csvPrinter.printRecord(values);
            }
            csvPrinter.flush();
            csvPrinter.close();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (writer != null) {
                if (object != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    writer.close();
                }
            }
        }
    }

    public static void saveJSON2OutputStream(JSONArray listData, OutputStream outs, boolean firstRowAsHeader, List<String> columnNames, String charsetType) throws IOException {
        if (listData == null || listData.isEmpty()) {
            return;
        }
        if (columnNames == null || columnNames.isEmpty()) {
            HashSet headers = new HashSet(20);
            for (Object row : listData) {
                if (!(row instanceof JSONObject)) continue;
                headers.addAll(((JSONObject)row).keySet());
            }
            columnNames = CollectionsOpt.cloneList(headers);
        }
        if (columnNames == null || columnNames.isEmpty()) {
            return;
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outs, Charset.forName(charsetType)));
        Object object = null;
        try {
            CSVPrinter csvPrinter = CSVFormat.EXCEL.print((Appendable)writer);
            if (firstRowAsHeader) {
                csvPrinter.printRecord(columnNames);
            }
            Object[] values = new String[columnNames.size()];
            for (Object row : listData) {
                if (!(row instanceof JSONObject)) continue;
                JSONObject rowJson = (JSONObject)row;
                for (int i = 0; i < columnNames.size(); ++i) {
                    values[i] = StringBaseOpt.castObjectToString(rowJson.get(columnNames.get(i)), "");
                    values[i] = ((String)values[i]).replaceAll("\\u00A0", " ");
                }
                csvPrinter.printRecord(values);
            }
            csvPrinter.flush();
            csvPrinter.close();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (writer != null) {
                if (object != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    writer.close();
                }
            }
        }
    }
}

