/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.network;

import java.util.Collection;
import org.apache.commons.text.StringEscapeUtils;

public abstract class HtmlFormUtils {
    private HtmlFormUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static String htmlValue(String value) {
        return StringEscapeUtils.escapeHtml4((String)value);
    }

    public static String htmlString(String value) {
        return StringEscapeUtils.unescapeHtml4((String)value);
    }

    public static String[] htmlValue(String[] strArr) {
        if (strArr == null || strArr.length == 0) {
            return null;
        }
        String[] resStrArr = new String[strArr.length];
        for (int i = 0; i < strArr.length; ++i) {
            resStrArr[i] = HtmlFormUtils.htmlValue(strArr[i]);
        }
        return resStrArr;
    }

    public static Object htmlValue(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof String[]) {
            String[] strArr = HtmlFormUtils.htmlValue((String[])v);
            return strArr;
        }
        if (v instanceof String) {
            return HtmlFormUtils.htmlValue((String)v);
        }
        return v;
    }

    public static String getParameterString(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof String[]) {
            String[] strArr = (String[])v;
            StringBuilder sb = new StringBuilder();
            if (strArr.length > 0) {
                for (int i = 0; i < strArr.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(strArr[i]);
                }
                return sb.toString();
            }
            return null;
        }
        if (v instanceof Collection) {
            Collection objArr = (Collection)v;
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (Object obj : objArr) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(obj.toString());
                ++i;
            }
            return sb.toString();
        }
        if (v instanceof String) {
            return (String)v;
        }
        return v.toString();
    }

    public static String[] getParameterStringArray(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof String[]) {
            String[] strArr = (String[])v;
            if (strArr.length > 0) {
                return strArr;
            }
            return null;
        }
        if (v instanceof Object[]) {
            Object[] objArr = (Object[])v;
            if (objArr.length > 0) {
                String[] strArr = new String[objArr.length];
                for (int i = 0; i < objArr.length; ++i) {
                    strArr[i] = objArr[i].toString();
                }
                return strArr;
            }
            return null;
        }
        if (v instanceof Collection) {
            Collection objArr = (Collection)v;
            String[] strArr = new String[objArr.size()];
            int i = 0;
            for (Object obj : objArr) {
                strArr[i++] = obj.toString();
            }
            return strArr;
        }
        if (v instanceof String) {
            return new String[]{(String)v};
        }
        return new String[]{v.toString()};
    }
}

