/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.algorithm;

import com.centit.support.common.ObjectException;
import org.apache.commons.lang3.StringUtils;

public abstract class EnumBaseOpt {
    public static <T> T ordinalToEnum(Class<T> enumType, int ordinal) {
        if (!enumType.isEnum()) {
            throw new ObjectException(enumType, enumType.getName() + " is not an Enum type.");
        }
        T[] values = enumType.getEnumConstants();
        if (ordinal < 0 || ordinal >= values.length) {
            throw new ObjectException(enumType, "IndexOutOfBoundsException: Enum " + enumType.getName() + "invalid ordinal");
        }
        return values[ordinal];
    }

    public static <T> T stringToEnum(Class<T> enumType, String name, boolean ignoreCase) {
        T[] values;
        if (!enumType.isEnum()) {
            throw new ObjectException(enumType, enumType.getName() + " is not an Enum type.");
        }
        for (T value : values = enumType.getEnumConstants()) {
            if (!StringUtils.equals((CharSequence)((Enum)value).name(), (CharSequence)name) && (!ignoreCase || !StringUtils.equalsIgnoreCase((CharSequence)((Enum)value).name(), (CharSequence)name))) continue;
            return value;
        }
        return null;
    }

    public static <T> T stringToEnum(Class<T> enumType, String name) {
        return EnumBaseOpt.stringToEnum(enumType, name, false);
    }

    public static int enumToOrdinal(Object enumObj) {
        if (!enumObj.getClass().isEnum()) {
            throw new ObjectException(enumObj, enumObj.getClass().getName() + " is not an object of Enum.");
        }
        return ((Enum)enumObj).ordinal();
    }

    public static String enumToString(Object enumObj) {
        if (!enumObj.getClass().isEnum()) {
            throw new ObjectException(enumObj, enumObj.getClass().getName() + " is not an object of Enum.");
        }
        return ((Enum)enumObj).name();
    }
}

