/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.algorithm;

import com.centit.support.common.ObjectException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;

public abstract class ZipCompressor {
    static final int BUFFER = 102400;

    private ZipCompressor() {
        throw new IllegalAccessError("Utility class");
    }

    public static ZipArchiveOutputStream convertToZipOutputStream(OutputStream os) {
        ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream(os);
        zipOut.setEncoding(StandardCharsets.UTF_8.name());
        return zipOut;
    }

    public static void compress(String zipFilePathName, String fileName, String srcPathName) {
        File file = new File(srcPathName);
        if (!file.exists()) {
            throw new RuntimeException(srcPathName + "\u4e0d\u5b58\u5728\uff01");
        }
        try {
            File zipFile = new File(zipFilePathName);
            FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
            ZipArchiveOutputStream out = ZipCompressor.convertToZipOutputStream(fileOutputStream);
            String basedir = "";
            ZipCompressor.compress(file, fileName, out, basedir);
            out.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void compress(String zipFilePathName, String srcPathName) {
        File file = new File(srcPathName);
        if (!file.exists()) {
            throw new RuntimeException(srcPathName + "\u4e0d\u5b58\u5728\uff01");
        }
        try {
            File zipFile = new File(zipFilePathName);
            FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
            ZipArchiveOutputStream out = ZipCompressor.convertToZipOutputStream(fileOutputStream);
            String basedir = "";
            ZipCompressor.compress(file, out, basedir);
            out.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void compressFiles(String zipFilePathName, String[] srcPathNames) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(zipFilePathName);
             ZipArchiveOutputStream out = ZipCompressor.convertToZipOutputStream(fileOutputStream);){
            String basedir = "";
            for (String srcPathName : srcPathNames) {
                File file = new File(srcPathName);
                if (!file.exists()) continue;
                ZipCompressor.compress(file, out, basedir);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void compressFiles(String zipFilePathName, Collection<String> srcPathNames) {
        ZipCompressor.compressFiles(zipFilePathName, srcPathNames.toArray(new String[0]));
    }

    public static void compressFileInDirectory(String zipFilePathName, String srcPathName) {
        File file = new File(srcPathName);
        if (!file.exists()) {
            throw new RuntimeException(srcPathName + "\u4e0d\u5b58\u5728\uff01");
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(zipFilePathName);
             ZipArchiveOutputStream out = ZipCompressor.convertToZipOutputStream(fileOutputStream);){
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    ZipCompressor.compress(f, out, "");
                }
            }
        }
        catch (Exception e) {
            throw new ObjectException((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void compress(File file, String fileName, ZipArchiveOutputStream out, String basedir) {
        if (file.isDirectory()) {
            ZipCompressor.compressDirectory(file, out, basedir);
        } else {
            ZipCompressor.compressFile(file, fileName, out, basedir);
        }
    }

    public static void compress(File file, ZipArchiveOutputStream out, String basedir) {
        if (file.isDirectory()) {
            ZipCompressor.compressDirectory(file, out, basedir);
        } else {
            ZipCompressor.compressFile(file, file.getName(), out, basedir);
        }
    }

    public static void compressDirectory(File dir, ZipArchiveOutputStream out, String basedir) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            ZipCompressor.compress(file, out, basedir + dir.getName() + "/");
        }
    }

    public static void compressFile(InputStream fis, String fileName, ZipArchiveOutputStream out, String basedir) {
        Object filePath = StringUtils.isBlank((CharSequence)basedir) ? fileName : (basedir.endsWith("/") || basedir.endsWith("\\") ? basedir + fileName : basedir + File.separatorChar + fileName);
        try (BufferedInputStream bis = new BufferedInputStream(fis);){
            ZipArchiveEntry entry = new ZipArchiveEntry((String)filePath);
            out.putArchiveEntry(entry);
            bis.transferTo((OutputStream)out);
            out.closeArchiveEntry();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void compressFile(File file, String fileName, ZipArchiveOutputStream out, String basedir) {
        if (!file.exists()) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            ZipCompressor.compressFile(fis, fileName, out, basedir);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void compressFile(File file, ZipArchiveOutputStream out, String basedir) {
        ZipCompressor.compressFile(file, file.getName(), out, basedir);
    }

    public static void release(String zipPath, String dirPath) {
        ZipCompressor.release(new File(zipPath), dirPath);
    }

    public static void release(File zipFile, String dirPath) {
        File pathFile;
        Object descDir = dirPath;
        if (!((String)descDir).endsWith("/")) {
            descDir = dirPath + "/";
        }
        if (!(pathFile = new File((String)descDir)).exists()) {
            pathFile.mkdirs();
        }
        try (ZipFile zip = ((ZipFile.Builder)((ZipFile.Builder)ZipFile.builder().setFile(zipFile)).setCharset(StandardCharsets.UTF_8)).get();){
            Enumeration entries = zip.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                String zipEntryName = entry.getName();
                String outPath = ((String)descDir + zipEntryName).replaceAll("\\*", "/");
                File file = new File(outPath.substring(0, outPath.lastIndexOf(47)));
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (new File(outPath).isDirectory()) continue;
                InputStream in = zip.getInputStream(entry);
                try (FileOutputStream out = new FileOutputStream(outPath);){
                    in.transferTo(out);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

